/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.main;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.IOStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.main.DummyAnalogInput;
import org.lsst.ccs.subsystem.motorplatform.main.DummyAxis;
import org.lsst.ccs.subsystem.motorplatform.main.DummyDigitalInput;
import org.lsst.ccs.subsystem.motorplatform.main.DummyDigitalOutput;

public class DummyController
implements MotorCommandListener,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<DummyAxis> axisList = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<DummyAnalogInput> analogList = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<DummyDigitalInput> inputList = Collections.synchronizedList(new ArrayList());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<DummyDigitalOutput> outputList = Collections.synchronizedList(new ArrayList());
    private Map<String, DummyAxis> axes;
    private List<DummyAnalogInput> analogs;
    private List<DummyDigitalInput> inputs;
    private List<DummyDigitalOutput> outputs;
    private PlatformConfig config;

    public void init() {
        this.axes = this.axisList.stream().collect(Collectors.toMap(x -> x.getName(), x -> x));
        ArrayList<DummyAxis> axisOrder = new ArrayList<DummyAxis>(this.axisList);
        axisOrder.sort((x, y) -> Integer.compare(x.getIndex(), y.getIndex()));
        this.analogs = new ArrayList<DummyAnalogInput>(this.analogList);
        this.analogs.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.inputs = new ArrayList<DummyDigitalInput>(this.inputList);
        this.inputs.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.outputs = new ArrayList<DummyDigitalOutput>(this.outputList);
        this.outputs.sort((x, y) -> Integer.compare(x.getOrder(), y.getOrder()));
        this.config = new PlatformConfig(axisOrder.stream().map(DummyAxis::getName).collect(Collectors.toList()), Collections.emptyList(), this.inputs.stream().map(DummyDigitalInput::getName).collect(Collectors.toList()), this.outputs.stream().map(DummyDigitalOutput::getName).collect(Collectors.toList()), this.analogs.stream().map(DummyAnalogInput::getDescription).collect(Collectors.toList()), "DUMMY", axisOrder.stream().map(DummyAxis::getUnits).collect(Collectors.toList()));
    }

    public void changeAxisEnable(ChangeAxisEnable cmd) {
        DummyAxis axis = this.axes.get(cmd.getAxisName());
        axis.setEnabled(cmd.isEnabled());
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)axis.getStatus()));
    }

    public void changeOutputLine(ChangeOutputLine cmd) {
        DummyDigitalOutput out = this.outputs.get(cmd.getLineIndex());
        out.setState(cmd.getNewState());
        this.publishIOStatus();
    }

    private void publishIOStatus() {
        int[] digis = new int[]{0, 0};
        this.inputs.forEach(x -> {
            digis[0] = digis[0] >> 1 | (x.getState() ? 0x800000 : 0);
        });
        digis[0] = digis[0] >> 24 - this.inputs.size();
        this.outputs.forEach(x -> {
            digis[1] = digis[1] >> 1 | (x.getState() ? 0x800000 : 0);
        });
        digis[1] = digis[1] >> 24 - this.outputs.size();
        List anas = this.analogs.stream().map(DummyAnalogInput::getValue).collect(Collectors.toList());
        IOStatus status = new IOStatus(digis[0], digis[1], anas);
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("IOStatus", (Serializable)status));
    }

    public void clearAllFaults(ClearAllFaults cmd) {
        this.axes.values().forEach(x -> {
            x.clearFaults();
            this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)x.getStatus()));
        });
    }

    public void clearAxisFaults(ClearAxisFaults cmd) {
        DummyAxis axis = this.axes.get(cmd.getAxisName());
        axis.clearFaults();
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)axis.getStatus()));
    }

    public void clearCapture(ClearCapture cmd) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void enableAllAxes(EnableAllAxes cmd) {
        this.axes.values().forEach(x -> {
            x.setEnabled(true);
            this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)x.getStatus()));
        });
    }

    public void moveAxisRelative(MoveAxisRelative cmd) {
        DummyAxis axis = this.axes.get(cmd.getAxisName());
        axis.moveRelative(cmd.getDistance());
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)axis.getStatus()));
    }

    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        DummyAxis axis = this.axes.get(cmd.getAxisName());
        axis.moveAbsolute(cmd.getPosition());
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)axis.getStatus()));
    }

    public void homeAxis(HomeAxis cmd) {
        DummyAxis axis = this.axes.get(cmd.getAxisName());
        axis.home();
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)axis.getStatus()));
    }

    public void sendAxisStatus(SendAxisStatus cmd) {
        DummyAxis axis = this.axes.get(cmd.getAxisName());
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)axis.getStatus()));
    }

    public void sendConfiguration(SendConfiguration cmd) {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("PlatformConfig", (Serializable)this.config));
        this.publishIOStatus();
        this.sendControllerStatus(new SendControllerStatus());
        this.axes.values().forEach(x -> this.sendAxisStatus(new SendAxisStatus(x.getName())));
    }

    public void sendControllerStatus(SendControllerStatus cmd) {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ControllerStatus", (Serializable)new ControllerStatus("UP", true, "OK")));
    }

    public void setupCapture(SetupCapture cmd) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void stopAllMotion(StopAllMotion cmd) {
    }
}

