/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.indilib.i4j.Constants;
import org.indilib.i4j.INDIDateFormat;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIBLOBProperty;
import org.indilib.i4j.client.INDIDevice;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDILightProperty;
import org.indilib.i4j.client.INDINumberProperty;
import org.indilib.i4j.client.INDIPropertyListener;
import org.indilib.i4j.client.INDISwitchProperty;
import org.indilib.i4j.client.INDITextProperty;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.properties.INDIStandardElement;
import org.indilib.i4j.properties.INDIStandardProperty;
import org.indilib.i4j.protocol.DefVector;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.NewVector;
import org.indilib.i4j.protocol.OneElement;
import org.indilib.i4j.protocol.SetVector;

public abstract class INDIProperty<Element extends INDIElement>
implements Iterable<Element> {
    private INDIDevice device;
    private String name;
    private String label;
    private String group;
    private Constants.PropertyStates state;
    private Constants.PropertyPermissions permission;
    private int timeout;
    private Map<String, Element> elements;
    private List<INDIPropertyListener> listeners;

    protected INDIProperty(DefVector<?> xml, INDIDevice device) {
        this.device = device;
        this.name = xml.getName();
        if (this.name.isEmpty()) {
            throw new IllegalArgumentException("No name for the Property");
        }
        this.label = xml.getLabel();
        if (this.label.isEmpty()) {
            this.label = this.name;
        }
        this.group = xml.getGroup();
        if (this.group.isEmpty()) {
            this.group = "Unsorted";
        }
        String sta = xml.getState();
        this.setState(sta);
        if (this instanceof INDITextProperty || this instanceof INDINumberProperty || this instanceof INDISwitchProperty || this instanceof INDIBLOBProperty) {
            this.permission = Constants.parsePropertyPermission((String)xml.getPerm());
            String to = xml.getTimeout();
            if (!to.isEmpty()) {
                this.setTimeout(to);
            } else {
                this.timeout = 0;
            }
        }
        if (this.getClass() == INDILightProperty.class) {
            this.timeout = 0;
            this.permission = Constants.PropertyPermissions.RO;
        }
        this.elements = new LinkedHashMap<String, Element>();
        this.listeners = new ArrayList<INDIPropertyListener>();
    }

    protected abstract void update(SetVector<?> var1);

    protected void update(SetVector<?> xml, Class<?> childNodesType) {
        try {
            String to;
            String sta = xml.getState();
            if (sta.length() != 0) {
                this.setState(sta);
            }
            if ((to = xml.getTimeout()).length() != 0) {
                this.setTimeout(to);
            }
            for (OneElement element : xml.getElements()) {
                String ename;
                Element iel;
                if (!childNodesType.isAssignableFrom(element.getClass()) || (iel = this.getElement(ename = element.getName())) == null) continue;
                ((INDIElement)iel).setValue(element);
            }
        }
        catch (IllegalArgumentException e) {
            this.state = Constants.PropertyStates.ALERT;
        }
        this.notifyListeners();
    }

    private void setState(String newState) {
        this.state = Constants.parsePropertyState((String)newState);
    }

    private void setTimeout(String newTimeout) {
        try {
            this.timeout = Integer.parseInt(newTimeout);
            if (this.timeout < 0) {
                throw new IllegalArgumentException("Illegal timeout for the Property");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal timeout for the Property");
        }
    }

    public INDIDevice getDevice() {
        return this.device;
    }

    public String getGroup() {
        return this.group;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public Constants.PropertyPermissions getPermission() {
        return this.permission;
    }

    public Constants.PropertyStates getState() {
        return this.state;
    }

    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected void setState(Constants.PropertyStates state) {
        this.state = state;
        this.notifyListeners();
    }

    protected void setPermission(Constants.PropertyPermissions permission) {
        this.permission = permission;
    }

    protected void addElement(Element element) {
        this.elements.put(((INDIElement)element).getName(), element);
    }

    public Element getElement(String elementName) {
        return (Element)((INDIElement)this.elements.get(elementName));
    }

    public Element getElement(INDIStandardElement elementName) {
        return (Element)((INDIElement)this.elements.get(elementName.name()));
    }

    public Element getElement(INDIStandardProperty elementName) {
        return (Element)((INDIElement)this.elements.get(elementName.name()));
    }

    public List<Element> getElementsAsList() {
        return new ArrayList<Element>(this.elements.values());
    }

    public void sendChangesToDriver() throws INDIValueException, IOException {
        if (this.permission == Constants.PropertyPermissions.RO) {
            throw new INDIValueException(null, "The property is read only");
        }
        int changedElements = 0;
        NewVector<?> xml = this.getXMLPropertyChangeInit();
        for (INDIElement el : this) {
            if (!el.isChanged()) continue;
            ++changedElements;
            xml.getElements().add(el.getXMLOneElementNewValue());
        }
        if (changedElements > 0) {
            this.setState(Constants.PropertyStates.BUSY);
            xml.setDevice(this.getDevice().getName());
            xml.setName(this.getName());
            xml.setTimestamp(INDIDateFormat.dateFormat().getCurrentTimestamp());
            this.device.sendMessageToServer((INDIProtocol<?>)xml);
        }
    }

    public void addINDIPropertyListener(INDIPropertyListener listener) {
        this.listeners.add(listener);
    }

    public void removeINDIPropertyListener(INDIPropertyListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (INDIPropertyListener l : new ArrayList<INDIPropertyListener>(this.listeners)) {
            l.propertyChanged(this);
        }
    }

    protected abstract NewVector<?> getXMLPropertyChangeInit();

    public abstract INDIPropertyListener getDefaultUIComponent() throws INDIException;

    public String[] getElementNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (INDIElement l : this) {
            names.add(l.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public String getNameStateAndValuesAsString() {
        StringBuffer aux = new StringBuffer(this.getName()).append(" - ").append(this.getState()).append("\n");
        for (INDIElement l : this) {
            aux.append("  ").append(l.getNameAndValueAsString()).append("\n");
        }
        return aux.toString();
    }

    public String getValuesAsString() {
        StringBuffer aux = new StringBuffer("[");
        for (INDIElement l : this) {
            if (aux.length() > 1) {
                aux.append(',');
            }
            aux.append(l);
        }
        return aux.append("]").toString();
    }

    @Override
    public Iterator<Element> iterator() {
        return this.elements.values().iterator();
    }
}

