/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.MonitorDeviceInterface;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class CanOpenSeneca4RTD
extends CanOpenDevice
implements MonitorDeviceInterface {
    final int INDEX = 8454;
    final int SDO_SIZE = 2;
    final short MEASURE_TYPE = 0;
    final short CONNEXION_TYPE = 1;
    final short FREQUENCY_REJECTION = 1;
    final short FILTER_VALUE = (short)2;
    final int SENSOR_TYPE = 3;

    private int getIndex(int channelNO) {
        return 8454 + channelNO - 1;
    }

    public void setSensorType(int channelNO, int sensorType) {
        this.writeSDO(this.getIndex(channelNO), 1, 2, sensorType);
    }

    public void setMeasureType(int channelNO, int measureType) {
        this.writeSDO(this.getIndex(channelNO), 2, 2, measureType);
    }

    public void setConnexionType(int channelNO, int connexionType) {
        this.writeSDO(this.getIndex(channelNO), 3, 2, connexionType);
    }

    public void setFrequencyRejection(int channelNO, int frequencyRejection) {
        this.writeSDO(this.getIndex(channelNO), 4, 2, frequencyRejection);
    }

    public void setFilterValue(int channelNO, int filterValue) {
        this.writeSDO(this.getIndex(channelNO), 5, 2, filterValue);
    }

    public void enableChannel(int channelNO) {
        this.writeSDO(this.getIndex(channelNO), 6, 2, 1L);
    }

    @Override
    public void initializeAndCheckHardware() {
        if (!this.isBooted()) {
            throw new RejectedCommandException(this.name + " is not booted");
        }
        this.initialize();
    }

    @Override
    public void initialize() {
        for (int i = 1; i < 4; ++i) {
            this.setSensorType(i, 3);
            this.setMeasureType(i, 0);
            this.setConnexionType(i, 1);
            this.setFrequencyRejection(i, 1);
            this.setFilterValue(i, 2);
            this.enableChannel(i);
        }
        this.initialized = true;
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.name + ": is INITIALIZED."));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="read channel and return its value")
    public double readChannel(int channelNO) {
        return (double)((short)this.readSDO(25601, channelNO)) / 10.0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read sensor type for a channel")
    public int readSensorType(int channelNO) {
        return (int)this.readSDO(this.getIndex(channelNO), 1);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read measure type for a channel")
    public int readMeasureType(int channelNO) {
        return (int)this.readSDO(this.getIndex(channelNO), 2);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read connexion type for a channel")
    public int readConnexionType(int channelNO) {
        return (int)this.readSDO(this.getIndex(channelNO), 3);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read frequency rejection for a channel")
    public int readFrequenceRejection(int channelNO) {
        return (int)this.readSDO(this.getIndex(channelNO), 4);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read filter value for a channel")
    public int readFilterValue(int channelNO) {
        return (int)this.readSDO(this.getIndex(channelNO), 5);
    }

    public void postStart() {
        if (this.isBooted()) {
            this.initialize();
        } else {
            this.raiseWarningIfMissing();
        }
    }
}

