import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.rafts.RaftsMain
import org.lsst.ccs.subsystem.rafts.GlobalProc
import org.lsst.ccs.subsystem.rafts.REBDevice
import org.lsst.ccs.subsystem.rafts.DacControl
import org.lsst.ccs.subsystem.rafts.BiasControl
import org.lsst.ccs.subsystem.rafts.AspicControl
import org.lsst.ccs.drivers.reb.PowerAdcs
import org.lsst.ccs.drivers.reb.SlowAdcs
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.daq.utilities.FitsService
import org.lsst.ccs.imagenaming.service.ImageNameService
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;


Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")

CCSBuilder builder = ["ats-wreb"]

builder.main (RaftsMain) {
     
    imageNameService (ImageNameService, 
        dbURL: props.getProperty("org.lsst.ccs.dbUrl", "jdbc:h2:mem:test;MODE=MYSQL"), 
        source: "AuxTel",
        controller: "CCS"
    )

    if (runMode.equals("simulation")) {
        clientFactory (ClientFactorySimulation)
    }

    globalProc(GlobalProc, partition: "ats", dfltFolder: "base")
    
    def reb = "WREB"

    "$reb" (REBDevice, id: 0, 
            dataSegmentMap: [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0], useScienceCCD: true) {

        fitsService (FitsService, 
            headerFilesList:["ats-primary:primary", "extended", "ats-reb_cond", "ats-test_cond"]            
        )

        for (int j = 0; j < 2; j++) {
            "${reb}.ASPIC$j" (AspicControl, hwChan: j)
        }

        "${reb}.DAC"  (DacControl)

        for (int j = 0; j < 1; j++) {
            "${reb}.Bias$j" (BiasControl, hwChan: j)
        }
    }

    String title = "Temperatures\\"
    for (int j = 1; j <= 6; j++) {
        "${reb}.Temp$j" (Channel, description: "${title}Board temperature $j", units: "\u00b0C",
                         devcName: reb, hwChan: j - 1, type: "TEMP")
        title = ""
    }

    "${reb}.Atemp0U" (Channel, description: "ASPIC 0 upper temp", units: "\u00b0C",
                      devcName: reb, hwChan: 0, type: "ATEMP")

    "${reb}.Atemp0L" (Channel, description: "ASPIC 0 lower temp", units: "\u00b0C",
                      devcName: reb, hwChan: 1, type: "ATEMP")

    "${reb}.CCDtemp0" (Channel, description: "CCD 0 temperature", units: "\u00b0C",
                      devcName: reb, hwChan: 0, type: "RTD")

    "${reb}.DigV"   (Channel, description: "Board power\\Digital PS voltage", units: "Volts",
                     devcName: reb, hwChan: PowerAdcs.ADC_DIG_VOLTAGE, type: "POWER")

    "${reb}.DigI"   (Channel, description: "Digital PS current", format: ".1f", units: "mA",
                     devcName: reb, hwChan: PowerAdcs.ADC_DIG_CURRENT, type: "POWER", scale: 1000)

    "${reb}.AnaV"   (Channel, description: "Analog PS voltage", units: "Volts",
                     devcName: reb, hwChan: PowerAdcs.ADC_ANA_VOLTAGE, type: "POWER")

    "${reb}.AnaI"   (Channel, description: "Analog PS current", format: ".1f", units: "mA",
                     devcName: reb, hwChan: PowerAdcs.ADC_ANA_CURRENT, type: "POWER", scale: 1000)

    "${reb}.ClkHV"  (Channel, description: "CLK_H PS voltage", units: "Volts",
                     devcName: reb, hwChan: PowerAdcs.ADC_CLKH_VOLTAGE, type: "POWER")

    "${reb}.ClkHI"  (Channel, description: "CLK_H PS current", format: ".1f", units: "mA",
                     devcName: reb, hwChan: PowerAdcs.ADC_CLKH_CURRENT, type: "POWER", scale: 1000)

    "${reb}.ClkLV"  (Channel, description: "CLK_L PS voltage", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_V_CLKL, type: "CRVOLT")

    "${reb}.ODV"    (Channel, description: "OD PS voltage", units: "Volts",
                     devcName: reb, hwChan: PowerAdcs.ADC_OD_VOLTAGE, type: "POWER")

    "${reb}.ODI"    (Channel, description: "OD PS current", format: ".1f", units: "mA",
                     devcName: reb, hwChan: PowerAdcs.ADC_OD_CURRENT, type: "POWER", scale: 1000)

    "${reb}.Power"  (Channel, description: "Total power", format: ".2f", units: "Watts",
                     devcName: reb, hwChan: REBDevice.CHAN_TOTAL_POWER, type: "POWER")

    "${reb}.PClkU"  (Channel, description: "Clock rails\\Parallel upper", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_CKP_U, type: "CRVOLT")

    "${reb}.PClkL"  (Channel, description: "Parallel lower", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_CKP_L, type: "CRVOLT")

    "${reb}.SClkU"  (Channel, description: "Serial upper", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_SCK_U, type: "CRVOLT")

    "${reb}.SClkL"  (Channel, description: "Serial lower", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_SCK_L, type: "CRVOLT")

    "${reb}.RGU"    (Channel, description: "RG upper", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_RG_U, type: "CRVOLT")

    "${reb}.RGL"    (Channel, description: "RG lower", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_RG_L, type: "CRVOLT")

    "${reb}.PClk0"  (Channel, description: "Clock states\\Parallel 0", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_CKP_0, type: "CRVOLT")

    "${reb}.SClk0"  (Channel, description: "Serial 0", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_CKS_0, type: "CRVOLT")

    "${reb}.RG0"    (Channel, description: "RG 0", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_RG_0, type: "CRVOLT")

    "${reb}.OD0V"   (Channel, description: "Bias voltages\\OD 0 voltage", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_OD_0, type: "CRVOLT")

    "${reb}.OG0V"   (Channel, description: "OG 0 voltage", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_OG_0, type: "CRVOLT")

    "${reb}.RD0V"   (Channel, description: "RD 0 voltage", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_RD_0, type: "CRVOLT")

    "${reb}.GD0V"   (Channel, description: "GD 0 voltage", format: ".2f", units: "Volts",
                     devcName: reb, hwChan: SlowAdcs.CHAN_GD_0, type: "CRVOLT")

    "${reb}.OD0I"   (Channel, description: "OD 0 current", format: ".1f", units: "mA",
                     devcName: reb, hwChan: SlowAdcs.CHAN_ODI_0, type: "CRVOLT", scale: 1000)

}
