/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.aerotech;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestAerotechPro165
extends TestAscii {
    protected final AerotechPro165 mydev;

    public TestAerotechPro165() {
        super((Ascii)new AerotechPro165());
        this.mydev = (AerotechPro165)this.dev;
    }

    @Command(name="version", description="get the version")
    public String version() throws DriverException {
        return this.mydev.getVersion();
    }

    @Command(name="enable", description="enable")
    public void enable() throws DriverException {
        this.mydev.enableAxis('X');
        this.mydev.enableAxis('Y');
        this.mydev.enableAxis('Z');
    }

    @Command(name="getpos", description="get position")
    public String getpos() throws DriverException {
        return "x: " + this.mydev.getPosX() + ", y: " + this.mydev.getPosY() + ", z: " + this.mydev.getPosZ();
    }

    @Command(name="moveinc", description="step position by dx, dy, dz")
    public void moveinc(@Argument(name="dx", description="X step") double dx, @Argument(name="dy", description="Y step") double dy, @Argument(name="dz", description="Z step") double dz) throws DriverException {
        this.mydev.moveInc(dx, dy, dz);
    }

    @Command(name="moveabs", description="move to position x, y, z")
    public void moveabs(@Argument(name="dx", description="X step") double dx, @Argument(name="dy", description="Y step") double dy, @Argument(name="dz", description="Z step") double dz) throws DriverException {
        this.mydev.moveAbs(dx, dy, dz);
    }

    @Command(name="getpos_xyz", description="get position x, y, z")
    public double[] getposXYZ() throws DriverException {
        return this.mydev.getPosXYZ();
    }

    @Command(name="readap", description="execute comand and read response")
    public String readAP(@Argument(description="Command to execute") String command) throws DriverException {
        return this.mydev.readAP(command);
    }

    @Command(name="writeap", description="execute command")
    public void writeAP(@Argument(description="Command to execute") String command) throws DriverException {
        this.mydev.writeAP(command);
    }
}

