/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;

public class DictionaryProvider
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(DictionaryProvider.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dpdService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private OCSBridgeConfig config;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private OCSSubsystem ocsSubsystem;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private OCSBridgeConfig ocsBridgeConfig;
    private final Listener listener = new Listener();
    private final Map<String, SALClassDescription> salMonitoringClassDescriptions = new HashMap<String, SALClassDescription>();
    private final Map<String, SALClassDescription> salConfigurationClassDescriptions = new HashMap<String, SALClassDescription>();

    public void start() {
        this.dpdService.addDataProviderDictionaryListener((DataProviderDictionaryService.DataProviderDictionaryListener)this.listener);
    }

    Map<String, SALClassDescription> getStatusClassDescriptions() {
        return this.salMonitoringClassDescriptions;
    }

    Map<String, SALClassDescription> getConfigurationClassDescriptions() {
        return this.salConfigurationClassDescriptions;
    }

    private class Listener
    implements DataProviderDictionaryService.DataProviderDictionaryListener {
        Mapping mapping = Mapping.defaultMapping();

        private Listener() {
        }

        public void dataProviderDictionaryUpdate(DataProviderDictionaryService.DataProviderDictionaryEvent evt) {
            block5: {
                try {
                    if (evt.getEventType() == DataProviderDictionaryService.DataProviderDictionaryEvent.EventType.ADDED) {
                        AgentInfo.AgentType type = evt.getAgentInfo().getType();
                        if (type != AgentInfo.AgentType.WORKER && type != AgentInfo.AgentType.SERVICE) break block5;
                        String name = evt.getAgentInfo().getName();
                        for (String l : DictionaryProvider.this.ocsBridgeConfig.getListenSubsystems()) {
                            if (!l.equals(name)) continue;
                            DataProviderDictionary dictionary = evt.getDictionary();
                            DictionaryProvider.this.ocsSubsystem.addSubsystem(name, dictionary);
                            LOG.log(Level.INFO, "Added dictionary for {0}", new Object[]{name});
                            break block5;
                        }
                        break block5;
                    }
                    if (evt.getEventType() == DataProviderDictionaryService.DataProviderDictionaryEvent.EventType.REMOVED) {
                        DictionaryProvider.this.ocsSubsystem.removeSubsystem(evt.getAgentInfo().getName());
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Exception adding dictionary", t);
                }
            }
        }
    }
}

