/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gantry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.gantry.AnalogInput;
import org.lsst.ccs.subsystem.motorplatform.gantry.Axis;
import org.lsst.ccs.subsystem.motorplatform.gantry.DigitalOutput;

public class LoadCellAxis
extends Axis
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private volatile AnalogInput loadCell;
    @ConfigurationParameter(description="The axis intervals (mm) for upward motion in Z.", maxLength=20)
    private volatile List<Double> upwardIntervalTable = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="The load cell thresholds (N) for upward motion in Z.", maxLength=20)
    private volatile List<Double> upwardThresholdTable = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="The axis intervals (mm) for downward motion in Z.", maxLength=20)
    private volatile List<Double> downwardIntervalTable = Collections.synchronizedList(new ArrayList());
    @ConfigurationParameter(description="The load cell thresholds (N) for downward motion in Z.", maxLength=20)
    private volatile List<Double> downwardThresholdTable = Collections.synchronizedList(new ArrayList());
    private volatile boolean ignoreLoadCell = false;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private volatile DigitalOutput airBrake;

    public AnalogInput getLoadCell() {
        return this.loadCell;
    }

    public DigitalOutput getAirBrake() {
        return this.airBrake;
    }

    public void setIgnoreLoadCell(boolean ignore) {
        this.ignoreLoadCell = ignore;
    }

    public boolean isIgnored() {
        return this.ignoreLoadCell;
    }

    @Override
    public void enable(AerotechPro165 aero) {
        super.enable(aero);
        try {
            if (this.getAirBrake() != null) {
                aero.readAP(String.format("DOUT Z,%d,%d:1", this.getAirBrake().getPort(), this.getAirBrake().getBit()));
            }
        }
        catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void disable(AerotechPro165 aero) {
        super.disable(aero);
        try {
            if (this.getAirBrake() != null) {
                aero.readAP(String.format("DOUT Z,%d,%d:0", this.getAirBrake().getPort(), this.getAirBrake().getBit()));
            }
        }
        catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void moveRelative(AerotechPro165 aero, MoveAxisRelative cmd) {
        try {
            if (this.ignoreLoadCell) {
                super.moveRelative(aero, cmd);
            } else {
                double d = cmd.getDistance();
                double t = (double)cmd.getTime().toMillis() / 1000.0;
                double v = Math.abs(d) / (t - 0.2);
                v = Math.min(v, this.maxSpeed);
                double a = 10.0 * v;
                aero.writeAP("DGLOBAL(0) = " + d);
                aero.writeAP("DGLOBAL(1) = " + v);
                aero.writeAP("DGLOBAL(2) = " + a);
                aero.writeAP("DGLOBAL(3) = " + (Math.abs(d) / v + 0.2));
                aero.writeAP("DGLOBAL(4) = 0");
                aero.writeAP("PROGRAM RUN 1, \"CellMove.bcx\"");
            }
        }
        catch (DriverException exc) {
            throw new RuntimeException(exc);
        }
        finally {
            this.ignoreLoadCell = false;
        }
    }

    @Override
    public void moveAbsolute(AerotechPro165 aero, MoveAxisAbsolute cmd) {
        try {
            if (this.ignoreLoadCell) {
                super.moveAbsolute(aero, cmd);
            } else {
                double d = cmd.getPosition();
                double v = Math.min(cmd.getSpeed(), this.maxSpeed);
                double a = 10.0 * v;
                double t = (double)this.getAbsoluteMoveTimeout(cmd).toMillis() / 1000.0;
                aero.writeAP("DGLOBAL(0) = " + d);
                aero.writeAP("DGLOBAL(1) = " + v);
                aero.writeAP("DGLOBAL(2) = " + a);
                aero.writeAP("DGLOBAL(3) = " + t);
                aero.writeAP("DGLOBAL(4) = 1");
                aero.writeAP("PROGRAM RUN 1, \"CellMove.bcx\"");
            }
        }
        catch (DriverException exc) {
            throw new RuntimeException(exc);
        }
        finally {
            this.ignoreLoadCell = false;
        }
    }

    public void uploadTables(AerotechPro165 aero) throws DriverException {
        int index = 100;
        for (double val : this.downwardIntervalTable) {
            this.setDGlobal(aero, index++, val);
        }
        index = 120;
        for (double thr : this.downwardThresholdTable) {
            this.setDGlobal(aero, index++, this.getLoadCell().engineeringUnitsToVolts(thr));
        }
        index = 140;
        for (double val : this.upwardIntervalTable) {
            this.setDGlobal(aero, index++, val);
        }
        index = 160;
        for (double thr : this.upwardThresholdTable) {
            this.setDGlobal(aero, index++, this.getLoadCell().engineeringUnitsToVolts(thr));
        }
    }

    private void setDGlobal(AerotechPro165 aero, int index, double value) throws DriverException {
        aero.readAP(String.format("DGLOBAL(%d) = %g", index, value));
    }
}

