/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.indilib.i4j.Constants;
import org.indilib.i4j.INDIDateFormat;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIBLOBProperty;
import org.indilib.i4j.client.INDIDeviceListener;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDILightProperty;
import org.indilib.i4j.client.INDINumberProperty;
import org.indilib.i4j.client.INDIProperty;
import org.indilib.i4j.client.INDIServerConnection;
import org.indilib.i4j.client.INDISwitchProperty;
import org.indilib.i4j.client.INDITextProperty;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.protocol.DefBlobVector;
import org.indilib.i4j.protocol.DefLightVector;
import org.indilib.i4j.protocol.DefNumberVector;
import org.indilib.i4j.protocol.DefSwitchVector;
import org.indilib.i4j.protocol.DefTextVector;
import org.indilib.i4j.protocol.DefVector;
import org.indilib.i4j.protocol.DelProperty;
import org.indilib.i4j.protocol.EnableBLOB;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.SetBlobVector;
import org.indilib.i4j.protocol.SetLightVector;
import org.indilib.i4j.protocol.SetNumberVector;
import org.indilib.i4j.protocol.SetSwitchVector;
import org.indilib.i4j.protocol.SetTextVector;
import org.indilib.i4j.protocol.SetVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIDevice {
    private static final Logger LOG = LoggerFactory.getLogger(INDIDevice.class);
    private String name;
    private INDIServerConnection server;
    private Map<String, INDIProperty<?>> properties;
    private List<INDIDeviceListener> listeners;
    private INDIDeviceListener uiComponent;
    private Date timestamp;
    private String message;
    private int blobCount;

    protected INDIDevice(String name, INDIServerConnection server) {
        this.name = name;
        this.server = server;
        this.properties = new LinkedHashMap();
        this.listeners = new ArrayList<INDIDeviceListener>();
        this.timestamp = new Date();
        this.message = "";
        this.blobCount = 0;
    }

    public void addINDIDeviceListener(INDIDeviceListener listener) {
        this.listeners.add(listener);
    }

    public void removeINDIDeviceListener(INDIDeviceListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListenersNewProperty(INDIProperty<?> property) {
        for (INDIDeviceListener l : new ArrayList<INDIDeviceListener>(this.listeners)) {
            l.newProperty(this, property);
        }
    }

    private void notifyListenersDeleteProperty(INDIProperty<?> property) {
        for (INDIDeviceListener l : new ArrayList<INDIDeviceListener>(this.listeners)) {
            l.removeProperty(this, property);
        }
    }

    private void notifyListenersMessageChanged() {
        for (INDIDeviceListener l : new ArrayList<INDIDeviceListener>(this.listeners)) {
            l.messageChanged(this);
        }
    }

    public void blobsEnable(Constants.BLOBEnables enable) throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setTextContent(Constants.getBLOBEnableAsString((Constants.BLOBEnables)enable)));
    }

    public void blobsEnable(Constants.BLOBEnables enable, INDIProperty<?> property) throws IOException {
        if (this.properties.containsValue(property) && property instanceof INDIBLOBProperty) {
            this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setName(property.getName())).setTextContent(Constants.getBLOBEnableAsString((Constants.BLOBEnables)enable)));
        }
    }

    @Deprecated
    public void blobsEnableNever() throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setTextContent("Never"));
    }

    @Deprecated
    public void blobsEnableAlso() throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setTextContent("Also"));
    }

    @Deprecated
    public void blobsEnableOnly() throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setTextContent("Only"));
    }

    @Deprecated
    public void blobsEnableNever(INDIBLOBProperty property) throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setName(property.getName())).setTextContent("Never"));
    }

    @Deprecated
    public void blobsEnableAlso(INDIBLOBProperty property) throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setName(property.getName())).setTextContent("Also"));
    }

    @Deprecated
    public void blobsEnableOnly(INDIBLOBProperty property) throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)((EnableBLOB)((EnableBLOB)new EnableBLOB().setDevice(this.getName())).setName(property.getName())).setTextContent("Only"));
    }

    public String getLastMessage() {
        return this.message;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getName() {
        return this.name;
    }

    protected void messageReceived(INDIProtocol<?> xml) {
        if (xml.hasMessage()) {
            String time = xml.getTimestamp();
            this.timestamp = INDIDateFormat.dateFormat().parseTimestamp(time);
            this.message = xml.getMessage();
            this.notifyListenersMessageChanged();
        }
    }

    protected void deleteProperty(DelProperty xml) {
        String propertyName = xml.getName();
        if (propertyName.length() != 0) {
            this.messageReceived((INDIProtocol<?>)xml);
            INDIProperty<?> p = this.getProperty(propertyName);
            if (p != null) {
                this.removeProperty(p);
            }
        }
    }

    public INDIProperty<?> waitForProperty(String propertyName) {
        return this.waitForProperty(propertyName, Integer.MAX_VALUE);
    }

    public INDIProperty<?> waitForProperty(String propertyName, int maxWait) {
        INDIProperty<?> p = null;
        long startTime = new Date().getTime();
        boolean timeElapsed = false;
        while (p == null && !timeElapsed) {
            long endTime;
            p = this.getProperty(propertyName);
            if (p == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.warn("sleep interrupted", (Throwable)e);
                }
            }
            if (((endTime = new Date().getTime()) - startTime) / 1000L <= (long)maxWait) continue;
            timeElapsed = true;
        }
        return p;
    }

    protected void updateProperty(SetVector<?> xml) {
        String propertyName = xml.getName();
        if (!propertyName.isEmpty()) {
            this.messageReceived((INDIProtocol<?>)xml);
            INDIProperty<?> p = this.getProperty(propertyName);
            if (p != null) {
                if (p instanceof INDITextProperty && xml instanceof SetTextVector) {
                    p.update(xml);
                } else if (p instanceof INDINumberProperty && xml instanceof SetNumberVector) {
                    p.update(xml);
                } else if (p instanceof INDISwitchProperty && xml instanceof SetSwitchVector) {
                    p.update(xml);
                } else if (p instanceof INDILightProperty && xml instanceof SetLightVector) {
                    p.update(xml);
                } else if (p instanceof INDIBLOBProperty && xml instanceof SetBlobVector) {
                    p.update(xml);
                }
            }
        }
    }

    protected void addProperty(DefVector<?> xml) {
        String propertyName = xml.getName();
        if (!propertyName.isEmpty()) {
            this.messageReceived((INDIProtocol<?>)xml);
            INDIProperty<?> p = this.getProperty(propertyName);
            if (p == null) {
                try {
                    if (xml instanceof DefSwitchVector) {
                        INDISwitchProperty sp = new INDISwitchProperty((DefSwitchVector)xml, this);
                        this.addProperty(sp);
                        this.notifyListenersNewProperty(sp);
                    } else if (xml instanceof DefTextVector) {
                        INDITextProperty tp = new INDITextProperty((DefTextVector)xml, this);
                        this.addProperty(tp);
                        this.notifyListenersNewProperty(tp);
                    } else if (xml instanceof DefNumberVector) {
                        INDINumberProperty np = new INDINumberProperty((DefNumberVector)xml, this);
                        this.addProperty(np);
                        this.notifyListenersNewProperty(np);
                    } else if (xml instanceof DefLightVector) {
                        INDILightProperty lp = new INDILightProperty((DefLightVector)xml, this);
                        this.addProperty(lp);
                        this.notifyListenersNewProperty(lp);
                    } else if (xml instanceof DefBlobVector) {
                        INDIBLOBProperty bp = new INDIBLOBProperty((DefBlobVector)xml, this);
                        this.addProperty(bp);
                        this.notifyListenersNewProperty(bp);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Some problem with the parameters", (Throwable)e);
                }
            }
        }
    }

    public int getBLOBCount() {
        return this.blobCount;
    }

    private void addProperty(INDIProperty<?> property) {
        this.properties.put(property.getName(), property);
        if (property instanceof INDIBLOBProperty) {
            ++this.blobCount;
        }
    }

    private void removeProperty(INDIProperty<?> property) {
        this.properties.remove(property.getName());
        if (property instanceof INDIBLOBProperty) {
            --this.blobCount;
        }
        this.notifyListenersDeleteProperty(property);
    }

    public INDIServerConnection getServer() {
        return this.server;
    }

    public INDIProperty<?> getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public List<String> getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (INDIProperty<?> p : this.properties.values()) {
            String groupName = p.getGroup();
            if (groupNames.contains(groupName)) continue;
            groupNames.add(groupName);
        }
        return groupNames;
    }

    public List<INDIProperty<?>> getAllProperties() {
        return new ArrayList(this.properties.values());
    }

    public List<INDIProperty<?>> getPropertiesOfGroup(String groupName) {
        ArrayList props = new ArrayList();
        for (INDIProperty iNDIProperty : props) {
            if (iNDIProperty.getGroup().compareTo(groupName) != 0) continue;
            props.add(iNDIProperty);
        }
        return props;
    }

    public INDIElement getElement(String propertyName, String elementName) {
        INDIProperty<?> p = this.getProperty(propertyName);
        if (p == null) {
            return null;
        }
        return p.getElement(elementName);
    }

    protected void sendMessageToServer(INDIProtocol<?> xmlMessage) throws IOException {
        this.server.sendMessageToServer(xmlMessage);
    }

    public INDIDeviceListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIDeviceListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createDeviceView(this);
        this.addINDIDeviceListener(this.uiComponent);
        return this.uiComponent;
    }

    public List<INDIProperty<?>> getPropertiesAsList() {
        return new ArrayList(this.properties.values());
    }

    public String[] getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (INDIProperty<?> indiProperty : this.properties.values()) {
            names.add(indiProperty.getName());
        }
        return names.toArray(new String[names.size()]);
    }
}

