/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services.alert;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.RaisedAlertBookkeeper;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AgentAlertStateAlertListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class AlertService
implements HasLifecycle,
AgentService,
ServiceLifecycle,
ClearAlertHandler {
    public static int TESTINT = 10;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MessagingService messagingService;
    private final Object alertLock = new Object();
    long alertAccumulationPeriod = Duration.ofMinutes(1L).toMillis();
    private final Map<String, AlertRunnable> alertRunnables = new HashMap<String, AlertRunnable>();
    private final Map<String, ScheduledFuture> alertTasks = new HashMap<String, ScheduledFuture>();
    private final CopyOnWriteArrayList<AlertListener> listeners = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, RaisedAlertSummary> source2summary = new ConcurrentHashMap();
    private ConcurrentMessagingUtils messagingUtils;
    private final AgentPresenceListener alertManagementAgentPresenceManager = new AlertManagementAgentPresenceListener();
    private final AgentPresenceListener alertListeningAgentPresenceManager = new AlertListeningAgentPresenceListener();
    private final StatusMessageListener alertListeningStatusMessageListener = new AgentListeningStatusMessageListener();
    private Predicate<AgentInfo> statusListeningAgentSelection = null;
    private boolean requiresPublicationOfAlertHistory = false;
    private boolean alreadyStarted = false;
    private final Map<Alert, List<ClearAlertHandler>> registeredAlerts = new ConcurrentHashMap<Alert, List<ClearAlertHandler>>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<ClearAlertHandler> treeClearAlertHandlers = new ArrayList<ClearAlertHandler>();

    @Override
    public String getAgentServiceName() {
        return "alertService";
    }

    @Override
    public void build() {
        this.addListener(new AgentAlertStateAlertListener(this.agent, this.stateService, this.messagingService));
    }

    @Override
    public void postInit() {
        if (this.agent.getAgentInfo().isGraphicalConsole() || this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) > 0) {
            this.startStatusAlertListening(info -> info.isAgentWorkerOrService());
            this.requiresPublicationOfAlertHistory();
        }
    }

    @Override
    public void afterInit() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.alertManagementAgentPresenceManager);
        }
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.alertListeningAgentPresenceManager);
        }
        this.alreadyStarted = true;
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().addStatusMessageListener(this.alertListeningStatusMessageListener);
        }
    }

    @Override
    public void shutdown() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.alertManagementAgentPresenceManager);
        }
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.alertListeningAgentPresenceManager);
        }
        if (this.statusListeningAgentSelection != null) {
            this.agent.getMessagingAccess().removeStatusMessageListener(this.alertListeningStatusMessageListener);
        }
    }

    @Override
    public void postShutdown() {
    }

    public void registerAlert(Alert alert, ClearAlertHandler clearAlertHandler) {
        List registeredHandlers = this.registeredAlerts.computeIfAbsent(alert, a -> new CopyOnWriteArrayList());
        if (clearAlertHandler != null) {
            registeredHandlers.add(clearAlertHandler);
        }
    }

    public void registerAlert(Alert alert) {
        this.registerAlert(alert, null);
    }

    public void startStatusAlertListening(Predicate<AgentInfo> agentSelection) {
        if (this.alreadyStarted) {
            throw new RuntimeException("This method must be invoked before the HasLifecycle::postStart phase");
        }
        if (agentSelection == null) {
            throw new IllegalArgumentException("Cannot provide a null predicate.");
        }
        this.statusListeningAgentSelection = agentSelection;
    }

    public void requiresPublicationOfAlertHistory() {
        this.requiresPublicationOfAlertHistory = true;
    }

    public void raiseAlert(String source, Alert alert, AlertState severity, String cause) {
        this.raiseAlert(source, alert, severity, cause, RaiseAlertStrategy.ALWAYS);
    }

    public void raiseAlert(String source, Alert alert, AlertState severity, String cause, RaiseAlertStrategy strategy) {
        RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(source);
        this.internalRaiseAlert(source, keeper, alert, severity, cause, strategy);
        if (!this.registeredAlerts.containsKey(alert)) {
            this.agent.getLogger().log(Level.WARNING, "Raised Alert {0} has not been registered. Please register it using AlertService::registerAlert no later than HasLifecyle::init.", new Object[]{alert.getAlertId()});
        }
    }

    public void raiseAlert(Alert alert, AlertState severity, String cause) {
        this.raiseAlert(alert, severity, cause, RaiseAlertStrategy.ALWAYS);
    }

    public void raiseAlert(Alert alert, AlertState severity, String cause, RaiseAlertStrategy strategy) {
        this.raiseAlert(this.agent.getName(), alert, severity, cause, strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void internalRaiseAlert(String source, RaisedAlertBookkeeper keeper, Alert alert, AlertState severity, String cause, RaiseAlertStrategy strategy) {
        CCSTimeStamp ts = CCSTimeStamp.currentTime();
        Object object = this.alertLock;
        synchronized (object) {
            ScheduledFuture task;
            String alertId = alert.getAlertId();
            if (strategy == RaiseAlertStrategy.ON_SEVERITY_CHANGE) {
                RaisedAlertHistory history = this.getRaisedAlertSummary().getRaisedAlert(alertId);
                if (history != null) {
                    AlertState latestState = history.getLatestAlertInstance().getAlertState();
                    if (latestState == severity) {
                        return;
                    }
                } else if (severity == AlertState.NOMINAL) {
                    return;
                }
            }
            if ((task = this.alertTasks.get(alertId)) == null || task.isDone()) {
                this.raiseAlertAndAccumulate(source, keeper, alert, severity, ts, cause);
            } else {
                AlertRunnable ar = this.alertRunnables.get(alertId);
                if (ar.severity != severity) {
                    if (task.cancel(false)) {
                        ar.updateBookkeeperAndSendStatusAlert();
                    }
                    this.raiseAlertAndAccumulate(source, keeper, alert, severity, ts, cause);
                } else {
                    ar.accumulate(cause);
                }
            }
        }
    }

    private void raiseAlertAndAccumulate(String source, RaisedAlertBookkeeper keeper, Alert alert, AlertState severity, CCSTimeStamp ts, String cause) {
        AlertRunnable immediateAlert = new AlertRunnable(source, keeper, alert, severity, ts, cause);
        immediateAlert.accumulate(cause);
        immediateAlert.updateBookkeeperAndSendStatusAlert();
        this.scheduleTask(source, keeper, alert, severity, ts, cause);
    }

    private void scheduleTask(String source, RaisedAlertBookkeeper keeper, Alert alert, AlertState severity, CCSTimeStamp ts, String cause) {
        AlertRunnable r = new AlertRunnable(source, keeper, alert, severity, ts, cause);
        ScheduledFuture task = this.agent.getScheduler().schedule((Runnable)r, this.alertAccumulationPeriod, TimeUnit.MILLISECONDS);
        this.alertRunnables.put(alert.getAlertId(), r);
        this.alertTasks.put(alert.getAlertId(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] clearAlertsForSource(String source, String ... alertId) {
        Object object = this.alertLock;
        synchronized (object) {
            String summary;
            RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(source);
            ArrayList<String> clearedAlerts = new ArrayList<String>();
            for (String id : alertId) {
                RaisedAlertHistory raisedAlert;
                ScheduledFuture alertTask = this.alertTasks.get(id);
                if (alertTask != null) {
                    alertTask.cancel(true);
                    this.alertTasks.remove(id);
                }
                if ((raisedAlert = keeper.getRaisedAlert(id)) == null) {
                    throw new IllegalArgumentException("Illegal alert id: \"" + id + "\"");
                }
                ClearAlertHandler.ClearAlertCode clearAlert = ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
                Alert alertToClear = raisedAlert.getLatestAlert();
                AlertState alertState = raisedAlert.getLatestAlertState();
                if (alertState != AlertState.NOMINAL) {
                    List<ClearAlertHandler> clearAlertHandlers = this.registeredAlerts.get(alertToClear);
                    if (clearAlertHandlers == null) {
                        clearAlertHandlers = this.treeClearAlertHandlers;
                    }
                    for (ClearAlertHandler handler : clearAlertHandlers) {
                        ClearAlertHandler.ClearAlertCode code = handler.canClearAlert(alertToClear, alertState);
                        if (code == ClearAlertHandler.ClearAlertCode.CLEAR_ALERT) {
                            clearAlert = code;
                            continue;
                        }
                        if (code != ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT) continue;
                        clearAlert = code;
                        break;
                    }
                } else {
                    clearAlert = ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                if (clearAlert == ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT) {
                    clearAlert = ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
                    if (alertState != AlertState.ALARM && raisedAlert.getHighestAlertState() == AlertState.ALARM) {
                        keeper.setHighestSeverity(id, AlertState.WARNING);
                        clearedAlerts.add(id);
                    }
                }
                if (clearAlert != ClearAlertHandler.ClearAlertCode.CLEAR_ALERT) continue;
                keeper.clearAlert(id);
                clearedAlerts.add(id);
            }
            String[] clearedIds = new String[clearedAlerts.size()];
            if (!clearedAlerts.isEmpty()) {
                clearedIds = clearedAlerts.toArray(clearedIds);
                this.fireAlertEvent(new AlertEvent(source, clearedIds, new RaisedAlertSummary((RaisedAlertSummary)keeper), AlertEvent.AlertEventType.ALERT_CLEARED));
            }
            if (clearedIds.length > 0) {
                summary = "Cleared Alert Id" + (clearedIds.length > 1 ? "s" : "") + " (";
                for (int i = 0; i < clearedIds.length; ++i) {
                    summary = summary + clearedIds[i];
                    if (i >= clearedIds.length - 1) continue;
                    summary = summary + ", ";
                }
                summary = summary + ")";
            } else {
                summary = "Attempt to clear alerts, but no Alerts were cleared";
            }
            this.agent.getLogger().info((Object)(summary + " the resulting Alert State is " + keeper.getAlertState().name()));
            return clearedIds;
        }
    }

    @Command(description="Clear alerts", type=Command.CommandType.ACTION, category=Command.CommandCategory.CORE)
    public String[] clearAlerts(String ... alertId) {
        return this.clearAlertsForSource(this.agent.getName(), alertId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] clearAllAlertsForSource(String source) {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(source);
            Set alerts = keeper.getAllRaisedAlertHistories();
            String[] alertId = new String[alerts.size()];
            int count = 0;
            for (RaisedAlertHistory alert : alerts) {
                alertId[count++] = alert.getLatestAlert().getAlertId();
            }
            return this.clearAlerts(alertId);
        }
    }

    @Command(description="Clear all alerts", type=Command.CommandType.ACTION, category=Command.CommandCategory.CORE)
    public String[] clearAllAlerts() {
        return this.clearAllAlertsForSource(this.agent.getName());
    }

    private Level getLogLevelForAlertState(AlertState state) {
        if (state == AlertState.ALARM) {
            return Level.SEVERE;
        }
        if (state == AlertState.WARNING) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Get the Raised Alert Summary", type=Command.CommandType.QUERY)
    public RaisedAlertSummary getRaisedAlertSummary() {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertBookkeeper keeper = this.getBookkeeperForSource(this.agent.getName());
            return keeper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Publish the Raised Alert Summary", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void publishRaisedAlertSummary() {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertSummary keeper = this.getRaisedAlertSummary();
            this.agent.sendStatusMessage((StatusMessage)new StatusRaisedAlertSummary(new RaisedAlertSummary(keeper)));
        }
    }

    @Command(description="Print Registered Alerts", type=Command.CommandType.QUERY, category=Command.CommandCategory.USER)
    public String printRegisteredAlerts() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.agent.getName()).append(" registered Alerts: ").append("\n\tAlert Id\t\tAlert Description");
        for (Alert a : this.registeredAlerts.keySet()) {
            sb.append("\t").append(a.getAlertId()).append(" \t(").append(a.getDescription()).append(")\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(AlertListener listener) {
        Object object = this.alertLock;
        synchronized (object) {
            boolean ok = this.listeners.addIfAbsent(listener);
            if (!ok) {
                throw new IllegalArgumentException("The listener is already registered");
            }
            for (String source : this.source2summary.keySet()) {
                listener.onAlert(new AlertEvent(source, new String[0], this.source2summary.get(source), AlertEvent.AlertEventType.AGENT_CONNECTION));
            }
        }
    }

    public final void removeListener(AlertListener listener) {
        this.listeners.remove(listener);
    }

    private void fireAlertEvent(AlertEvent event) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (AlertListener l : this.listeners) {
            try {
                l.onAlert(event);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            exceptions.forEach(ex -> this.agent.getLogger().log(Level.SEVERE, "Exception raised when notifying AlertListeners", (Throwable)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaisedAlertBookkeeper getBookkeeperForSource(String source) {
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertSummary summary = this.source2summary.get(source);
            if (summary == null) {
                summary = new RaisedAlertBookkeeper();
                this.source2summary.put(source, summary);
            }
            return (RaisedAlertBookkeeper)summary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaisedAlertSummary getSummary(String source) {
        Object object = this.alertLock;
        synchronized (object) {
            return this.source2summary.get(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RaisedAlertSummary> getAllSummaries() {
        Object object = this.alertLock;
        synchronized (object) {
            return new HashMap<String, RaisedAlertSummary>(this.source2summary);
        }
    }

    private ConcurrentMessagingUtils getConcurrentMessagingUtils() {
        if (this.messagingUtils == null) {
            this.messagingUtils = new ConcurrentMessagingUtils(this.agent.getMessagingAccess());
        }
        return this.messagingUtils;
    }

    public void setAccumulationDuration(Duration accDur) {
        this.alertAccumulationPeriod = accDur.toMillis();
    }

    class AgentListeningStatusMessageListener
    implements StatusMessageListener {
        AgentListeningStatusMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusAlert && AlertService.this.statusListeningAgentSelection.test(((StatusAlert)msg).getOriginAgentInfo())) {
                String source = msg.getOriginAgentInfo().getName();
                StatusAlert message = (StatusAlert)msg;
                AgentListeningStatusMessageListener agentListeningStatusMessageListener = this;
                synchronized (agentListeningStatusMessageListener) {
                    RaisedAlertBookkeeper summary;
                    boolean justAdded = false;
                    if (message instanceof StatusRaisedAlertSummary) {
                        Object object = AlertService.this.alertLock;
                        synchronized (object) {
                            justAdded = AlertService.this.source2summary.put(source, new RaisedAlertBookkeeper((RaisedAlertSummary)((StatusRaisedAlertSummary)message).getObject())) == null;
                        }
                    }
                    if ((summary = AlertService.this.getBookkeeperForSource(source)) != null) {
                        if (message instanceof StatusRaisedAlert) {
                            StatusRaisedAlert raisedAlertMsg = (StatusRaisedAlert)message;
                            Alert alert = raisedAlertMsg.getRaisedAlert();
                            summary.raiseAlert(alert, raisedAlertMsg.getRaisedAlertState(), raisedAlertMsg.getCCSTimeStamp(), raisedAlertMsg.getCause(), raisedAlertMsg.getRaisedAlertCount());
                            AlertService.this.fireAlertEvent(new AlertEvent(source, alert, new RaisedAlertSummary((RaisedAlertSummary)summary), AlertEvent.AlertEventType.ALERT_RAISED));
                        } else if (message instanceof StatusClearedAlert) {
                            String[] ids;
                            for (String id : ids = ((StatusClearedAlert)message).getClearAlertIds()) {
                                summary.clearAlert(id);
                            }
                            AlertService.this.fireAlertEvent(new AlertEvent(source, ids, new RaisedAlertSummary((RaisedAlertSummary)summary), AlertEvent.AlertEventType.ALERT_CLEARED));
                        } else if (message instanceof StatusRaisedAlertSummary && justAdded) {
                            AlertService.this.fireAlertEvent(new AlertEvent(source, new String[0], new RaisedAlertSummary((RaisedAlertSummary)summary), AlertEvent.AlertEventType.AGENT_CONNECTION));
                        }
                    }
                }
            }
        }
    }

    class AlertListeningAgentPresenceListener
    implements AgentPresenceListener {
        AlertListeningAgentPresenceListener() {
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo a : agents) {
                if (!a.isAgentWorkerOrService() || !AlertService.this.requiresPublicationOfAlertHistory) continue;
                AlertService.this.agent.getScheduler().schedule(() -> {
                    if (AlertService.this.agent.getMessagingAccess().getAgentPresenceManager().agentExists(a.getName()) && !AlertService.this.source2summary.containsKey(a.getName())) {
                        AlertService.this.agent.getLogger().warn((Object)("requested raised alert summary for " + a.getName()));
                        CommandRequest cmd = new CommandRequest(a.getName(), "publishRaisedAlertSummary");
                        AlertService.this.getConcurrentMessagingUtils().sendAsynchronousCommand(cmd);
                    }
                }, 5L, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo agent : agents) {
                String source = agent.getName();
                AlertListeningAgentPresenceListener alertListeningAgentPresenceListener = this;
                synchronized (alertListeningAgentPresenceListener) {
                    RaisedAlertSummary current = (RaisedAlertSummary)AlertService.this.source2summary.remove(source);
                    if (current != null) {
                        AlertService.this.fireAlertEvent(new AlertEvent(source, new String[0], null, AlertEvent.AlertEventType.AGENT_DISCONNECTION));
                    }
                }
            }
        }
    }

    class AlertManagementAgentPresenceListener
    implements AgentPresenceListener {
        AlertManagementAgentPresenceListener() {
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo info : agents) {
                if (info.getType().compareTo((Enum)AgentInfo.AgentType.SERVICE) < 0 && !info.isGraphicalConsole()) continue;
                AlertService.this.publishRaisedAlertSummary();
                return;
            }
        }
    }

    private final class AlertRunnable
    implements Runnable {
        private final Alert alert;
        private final AlertState severity;
        private String cause;
        private final CCSTimeStamp ts;
        private int count = 0;
        private final RaisedAlertBookkeeper keeper;
        private final String source;

        private AlertRunnable(String source, RaisedAlertBookkeeper keeper, Alert alert, AlertState severity, CCSTimeStamp timestamp, String cause) {
            this.alert = alert;
            this.severity = severity;
            this.ts = timestamp;
            this.cause = cause;
            this.keeper = keeper;
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accumulate(String cause) {
            Object object = AlertService.this.alertLock;
            synchronized (object) {
                this.cause = cause;
                ++this.count;
            }
        }

        @Override
        public void run() {
            this.updateBookkeeperAndSendStatusAlert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBookkeeperAndSendStatusAlert() {
            Object object = AlertService.this.alertLock;
            synchronized (object) {
                if (this.count <= 0) {
                    return;
                }
                RaisedAlertHistory raisedAlert = this.keeper.raiseAlert(this.alert, this.severity, this.ts, this.cause, this.count);
                AlertService.this.fireAlertEvent(new AlertEvent(this.source, this.alert, new RaisedAlertSummary((RaisedAlertSummary)this.keeper), AlertEvent.AlertEventType.ALERT_RAISED));
                AlertService.this.agent.getLogger().log(AlertService.this.getLogLevelForAlertState(raisedAlert.getLatestAlertState()), "Raised Alert {0} ({1}) at severity {2} {3} time" + (this.count > 1 ? "s" : "") + ". Last cause : \"{4}\". Overall AlertState= {5}", new Object[]{this.alert.getAlertId(), this.alert.getDescription(), this.severity, this.count, this.cause, this.keeper.getAlertState().name()});
                AlertService.this.scheduleTask(this.source, this.keeper, this.alert, this.severity, CCSTimeStamp.currentTime(), this.cause);
            }
        }
    }

    public static enum RaiseAlertStrategy {
        ALWAYS,
        ON_SEVERITY_CHANGE;

    }
}

