/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.status;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

@SkipEncoding
public final class MotionDone
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ShutterSide _side;
    private final CCSTimeStamp _startTime;
    private final double _startPosition;
    private final Duration _targetDuration;
    private final double _targetPosition;
    private final double _endPosition;
    private final Duration _actualDuration;
    private final List<HallTransition> _hallTransitions;
    private final List<EncoderSample> _encoderSamples;

    private MotionDone(ShutterSide side, CCSTimeStamp startTime, double startPosition, Duration targetDuration, double targetPosition, double endPosition, Duration actualDuration, List<HallTransition> hallTransitions, List<EncoderSample> encoderSamples) {
        this._side = side;
        this._startPosition = startPosition;
        this._startTime = startTime;
        this._targetPosition = targetPosition;
        this._targetDuration = targetDuration;
        this._endPosition = endPosition;
        this._actualDuration = actualDuration;
        this._encoderSamples = encoderSamples;
        this._hallTransitions = hallTransitions;
    }

    public ShutterSide side() {
        return this._side;
    }

    public double startPosition() {
        return this._startPosition;
    }

    public CCSTimeStamp startTime() {
        return this._startTime;
    }

    public double targetPosition() {
        return this._targetPosition;
    }

    public Duration targetDuration() {
        return this._targetDuration;
    }

    public double endPosition() {
        return this._endPosition;
    }

    public Duration actualDuration() {
        return this._actualDuration;
    }

    public List<EncoderSample> encoderSamples() {
        return this._encoderSamples;
    }

    public List<HallTransition> hallTransitions() {
        return this._hallTransitions;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("MotionDone{");
        bld.append("side=");
        bld.append((Object)this.side());
        bld.append(", startTime=");
        bld.append(this.startTime());
        bld.append(", startPosition=");
        bld.append(this.startPosition());
        bld.append(", targetDuration=");
        bld.append(this.targetDuration());
        bld.append(", targetPosition=");
        bld.append(this.targetPosition());
        bld.append(", endPosition=");
        bld.append(this.endPosition());
        bld.append(", actualDuration=");
        bld.append(this.actualDuration());
        bld.append(", no. of Hall transitions=");
        bld.append(this.hallTransitions().size());
        bld.append(", no. of encoder samples=");
        bld.append(this.encoderSamples().size());
        bld.append("}");
        return bld.toString();
    }

    public boolean isDummy() {
        return this.hallTransitions().isEmpty() && this.encoderSamples().isEmpty();
    }

    public static final class Builder {
        private static final Logger LOG = Logger.getLogger(Builder.class.getName());
        private ShutterSide _side;
        private Double _startPosition;
        private CCSTimeStamp _startTime;
        private Double _targetPosition;
        private Duration _targetDuration;
        private Double _endPosition;
        private Duration _actualDuration;
        private List<EncoderSample> _encoderSamples;
        private List<HallTransition> _hallTransitions;
        private final boolean noThrow;

        public Builder() {
            this.noThrow = false;
        }

        public Builder(boolean noThrow) {
            this.noThrow = noThrow;
        }

        public Builder side(ShutterSide side) {
            this._side = side;
            return this;
        }

        public Builder startPosition(double pos) {
            this._startPosition = pos;
            return this;
        }

        public Builder startTime(CCSTimeStamp time) {
            this._startTime = time;
            return this;
        }

        public Builder targetPosition(double pos) {
            this._targetPosition = pos;
            return this;
        }

        public Builder endPosition(double pos) {
            this._endPosition = pos;
            return this;
        }

        public Builder targetDuration(Duration dur) {
            if (dur.isNegative() || dur.isZero()) {
                if (this.noThrow) {
                    LOG.warning("Non-positive duration.");
                } else {
                    throw new IllegalArgumentException("Non-positive duration.");
                }
            }
            this._targetDuration = dur;
            return this;
        }

        public Builder actualDuration(Duration dur) {
            if (dur.isNegative() || dur.isZero()) {
                if (this.noThrow) {
                    LOG.warning("Non-positive duration.");
                } else {
                    throw new IllegalArgumentException("Non-positive duration.");
                }
            }
            this._actualDuration = dur;
            return this;
        }

        public Builder encoderSamples(List<EncoderSample> samps) {
            this._encoderSamples = new ArrayList<EncoderSample>(samps);
            return this;
        }

        public Builder addEncoderSample(EncoderSample samp) {
            if (this._encoderSamples == null) {
                this._encoderSamples = new ArrayList<EncoderSample>(100);
            }
            this._encoderSamples.add(samp);
            return this;
        }

        public Builder hallTransitions(List<HallTransition> halls) {
            this._hallTransitions = new ArrayList<HallTransition>(halls);
            return this;
        }

        public Builder addHallTransition(HallTransition hall) {
            if (this._hallTransitions == null) {
                this._hallTransitions = new ArrayList<HallTransition>(100);
            }
            this._hallTransitions.add(hall);
            return this;
        }

        public MotionDone build() {
            ArrayList<String> missing = new ArrayList<String>(20);
            if (this._side == null) {
                missing.add("side");
            }
            if (this._startPosition == null) {
                missing.add("startPosition");
            }
            if (this._startTime == null) {
                missing.add("startTime");
            }
            if (this._targetPosition == null) {
                missing.add("targetPosition");
            }
            if (this._targetDuration == null) {
                missing.add("targetDuration");
            }
            if (this._endPosition == null) {
                missing.add("endPosition");
            }
            if (this._actualDuration == null) {
                missing.add("actualDuration");
            }
            if (this._encoderSamples == null) {
                missing.add("encoderSamples");
            }
            if (this._hallTransitions == null) {
                missing.add("hallTransitions");
            }
            if (missing.size() > 0) {
                String msg = String.format("Missing components of MotionDone: %s.", String.join((CharSequence)", ", missing));
                if (this.noThrow) {
                    LOG.warning(msg);
                } else {
                    throw new IllegalStateException(msg);
                }
            }
            Collections.sort(this._encoderSamples);
            Collections.sort(this._hallTransitions);
            return new MotionDone(this._side, this._startTime, this._startPosition, this._targetDuration, this._targetPosition, this._endPosition, this._actualDuration, Collections.unmodifiableList(this._hallTransitions), Collections.unmodifiableList(this._encoderSamples));
        }
    }
}

