/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;
import org.lsst.ccs.localdb.statusdb.model.RaisedAlertData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StateChangeNotificationData;
import org.lsst.ccs.localdb.statusdb.server.AlertEvent;
import org.lsst.ccs.localdb.statusdb.server.AlertInfo;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.DataSubsystem;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.StateInfo;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

@Path(value="/dataserver")
@Singleton
public class DataServer {
    private static final Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    private final SessionFactory fac = StatusdbUtils.getSessionFactory();

    public DataServer() {
        log.log(Level.INFO, "Starting Data Server");
    }

    public SessionFactory getSessionFactory() {
        return this.fac;
    }

    private List<DataChannel> getListOfChannels(long dtSeconds) {
        long start = System.currentTimeMillis();
        ArrayList<DataChannel> channels = new ArrayList<DataChannel>();
        try (Session sess = this.fac.openSession();){
            Query dataQuery = sess.createQuery("from DataDesc as dd where dd.id in  (select d.dataId from DataDescLastUpdate d where d.lastUpdate >:t)");
            if (dtSeconds > 0L) {
                dataQuery.setParameter("t", (Object)(System.currentTimeMillis() - dtSeconds * 1000L));
            } else {
                dataQuery.setParameter("t", (Object)0L);
            }
            dataQuery.setReadOnly(true);
            List l = dataQuery.list();
            for (DataDesc d : l) {
                DataChannel dc = new DataChannel(d);
                dc.getMetadata().put("subsystem", d.getDataPath().getAgentName());
                dc.getMetadata().put("type", d.getDataType());
                channels.add(dc);
            }
            double delta = System.currentTimeMillis() - start;
            log.log(Level.INFO, "Fetched list of channels ({0})  in {1} ms", new Object[]{l.size(), delta});
        }
        return channels;
    }

    private long getDataIdForPath(String path) {
        long dataId;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        int index = path.indexOf("/");
        String agentName = path.substring(0, index);
        String dataName = path.substring(index + 1);
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("select dd.id from DataDesc dd where dd.dataPath = :dataPath");
            q.setReadOnly(true);
            q.setParameter("dataPath", (Object)new DataPath(agentName, dataName));
            dataId = (Long)q.uniqueResult();
        }
        return dataId;
    }

    private String getPathForId(long id) {
        String path = null;
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("select dd.dataPath from DataDesc dd where dd.id = :id");
            q.setReadOnly(true);
            q.setParameter("id", (Object)id);
            path = ((DataPath)q.uniqueResult()).getFullKey();
        }
        return path;
    }

    @GET
    @Path(value="/data/latest/")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public TrendingData getLatestDataByPath(@QueryParam(value="path") String path) {
        long dataId = this.getDataIdForPath(path);
        TrendingData result = null;
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("from RawData r where r.dataDesc.id = :id order by r.time DESC");
            q.setReadOnly(true);
            q.setMaxResults(1);
            q.setParameter("id", (Object)dataId);
            RawData data = (RawData)q.uniqueResult();
            if (data != null) {
                long tStamp = data.getTime();
                result = new TrendingData();
                TrendingData.AxisValue axisValue = new TrendingData.AxisValue("time", tStamp);
                result.setAxisValue(axisValue);
                TrendingData.DataValue[] dataValue = new TrendingData.DataValue[1];
                Double dd = data.getDoubleData();
                dataValue[0] = dd == null ? new TrendingData.DataValue("value", data.getStringData()) : new TrendingData.DataValue("value", dd);
                result.setDataValue(dataValue);
            }
        }
        return result;
    }

    @GET
    @Path(value="/data/search/")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public List<Data> getDataByPath(@QueryParam(value="path") List<String> paths, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2, @QueryParam(value="flavor") String flavor, @QueryParam(value="n") @DefaultValue(value="30") int nbins) {
        ArrayList<Data> result = new ArrayList<Data>();
        for (String path : paths) {
            long dataId = this.getDataIdForPath(path);
            Data d = this.getInnerData(path, dataId, t1, t2, flavor, nbins);
            result.add(d);
        }
        return result;
    }

    @GET
    @Path(value="/data/")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public List<Data> getData(@QueryParam(value="id") List<Long> ids, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2, @QueryParam(value="flavor") String flavor, @QueryParam(value="n") @DefaultValue(value="30") int nbins) {
        ArrayList<Data> result = new ArrayList<Data>();
        for (long id : ids) {
            Data d = this.getData(id, t1, t2, flavor, nbins);
            result.add(d);
        }
        return result;
    }

    @GET
    @Path(value="/data/{id:  \\d+}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Data getData(@PathParam(value="id") long id, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2, @QueryParam(value="flavor") String flavor, @QueryParam(value="n") @DefaultValue(value="30") int nbins) {
        return this.getInnerData(null, id, t1, t2, flavor, nbins);
    }

    private Data getInnerData(String path, long id, long t1, long t2, String flavor, int nbins) {
        long start = System.currentTimeMillis();
        if (path == null) {
            path = this.getPathForId(id);
        }
        boolean useStat = false;
        boolean useRaw = false;
        if ("stat".equals(flavor)) {
            useStat = true;
        } else if ("raw".equals(flavor)) {
            useRaw = true;
        } else {
            flavor = "unspecified";
        }
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        long rawId = id;
        Data result = null;
        if (useRaw) {
            result = this.exportRawData(path, rawId, t1, t2);
        } else if (useStat) {
            StatDesc statSource = null;
            long statSourceN = -1L;
            List<StatDesc> stats = this.getAvailableStats(rawId);
            for (StatDesc s : stats) {
                long n = (t2 - t1) / s.getTimeBinWidth();
                if (n <= (long)(nbins / 2)) continue;
                if (statSource != null) {
                    if (n >= statSourceN) continue;
                    statSource = s;
                    statSourceN = n;
                    continue;
                }
                statSource = s;
                statSourceN = n;
            }
            if (statSource != null) {
                result = this.exportStatDataFromStat(path, statSource, t1, t2, nbins);
            }
        }
        if (result == null) {
            result = this.exportStatDataFromRaw(path, rawId, t1, t2, nbins);
        }
        long delta = System.currentTimeMillis() - start;
        log.log(Level.FINE, "Request for data id: {0} interval: [{1}:{2}] delta: {6} ms flavor: {3} nbins: {4} took {5} ms for {7} entries", new Object[]{String.valueOf(id), String.valueOf(t1), String.valueOf(t2), flavor, nbins, String.valueOf(delta), String.valueOf(t2 - t1), result.getTrendingResult().data.length});
        return result;
    }

    @GET
    @Path(value="/metadata/")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public List<ChannelMetaData> getMetadataForChannel(@QueryParam(value="id") int channelId, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        List l = null;
        Session sess = this.fac.openSession();
        Object object = null;
        try {
            Query q;
            String queryStr;
            String groupQuery = "select g.id from DataGroup g inner join g.members m where m.id=:id";
            Query qGroup = sess.createQuery(groupQuery);
            qGroup.setLockMode("g", LockMode.NONE);
            qGroup.setReadOnly(true);
            qGroup.setLong("id", (long)channelId);
            List lgid = qGroup.list();
            if (lgid.isEmpty()) {
                ArrayList<ChannelMetaData> arrayList = new ArrayList<ChannelMetaData>();
                return arrayList;
            }
            if (t1 > -1L && t2 > -1L) {
                queryStr = "select md from MetaDataData md where md.dataGroup.id in (select g.id from DataGroup g inner join g.members m where m.id=:id)  and (startTime >= :t1 and startTime < :t2)";
                q = sess.createQuery(queryStr);
                q.setLockMode("md", LockMode.NONE);
                q.setReadOnly(true);
                q.setLong("id", (long)channelId);
                q.setParameter("t1", (Object)t1);
                q.setParameter("t2", (Object)t2);
                l = q.list();
                queryStr = "select md from MetaDataData md where md.dataGroup.id in (select g.id from DataGroup g inner join g.members m where m.id=:id)  and (startTime < :t1 and (endTime > :t1 or endTime = -1))";
                q = sess.createQuery(queryStr);
                q.setLockMode("md", LockMode.NONE);
                q.setLong("id", (long)channelId);
                q.setParameter("t1", (Object)t1);
                q.setReadOnly(true);
                l.addAll(q.list());
            } else if (t2 < 0L && t1 > -1L) {
                queryStr = "select md from MetaDataData md where md.dataGroup.id in (select g.id from DataGroup g inner join g.members m where m.id=:id)  and startTime >= :t1";
                q = sess.createQuery(queryStr);
                q.setLockMode("md", LockMode.NONE);
                q.setLong("id", (long)channelId);
                q.setReadOnly(true);
                q.setParameter("t1", (Object)t1);
                l = q.list();
            } else if (t2 > -1L && t1 < 0L) {
                queryStr = "select md from MetaDataData md where md.dataGroup.id in (select g.id from DataGroup g inner join g.members m where m.id=:id)  and (startTime < :t2 or endTime = -1)";
                q = sess.createQuery(queryStr);
                q.setLong("id", (long)channelId);
                q.setLockMode("md", LockMode.NONE);
                q.setReadOnly(true);
                q.setParameter("t2", (Object)t2);
                l = q.list();
            } else {
                queryStr = "select md from MetaDataData md where md.dataGroup.id in (select g.id from DataGroup g inner join g.members m where m.id=:id) ";
                q = sess.createQuery(queryStr);
                q.setLong("id", (long)channelId);
                q.setLockMode("md", LockMode.NONE);
                q.setReadOnly(true);
                l = q.list();
            }
        }
        catch (Throwable groupQuery) {
            object = groupQuery;
            throw groupQuery;
        }
        finally {
            if (sess != null) {
                if (object != null) {
                    try {
                        sess.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    sess.close();
                }
            }
        }
        ArrayList<ChannelMetaData> out = new ArrayList<ChannelMetaData>();
        for (MetaDataData md : l) {
            out.add(new ChannelMetaData(md));
        }
        return out;
    }

    @GET
    @Path(value="/channelinfo/{id}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public ChannelMetaData.ChannelMetadataList getMetadataList(@PathParam(value="id") long channelId) {
        long rawId = channelId;
        return new ChannelMetaData.ChannelMetadataList(this.getMetadataForChannel((int)rawId, -1L, -1L));
    }

    @GET
    @Path(value="listsubsystems")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public DataSubsystem.DataSubsystemList getSubsystems() {
        return new DataSubsystem.DataSubsystemList(this.getListOfSubsystems());
    }

    private List<DataSubsystem> getListOfSubsystems() {
        List<DataSubsystem> l = null;
        try (Session sess = this.fac.openSession();){
            Query dataQuery = sess.createQuery("select distinct dd.dataPath.agentName from DataDesc dd");
            dataQuery.setReadOnly(true);
            l = dataQuery.list().stream().map(agentName -> new DataSubsystem((String)agentName)).collect(Collectors.toList());
        }
        return l;
    }

    @GET
    @Path(value="/listchannels")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public DataChannel.DataChannelList getChannels(@QueryParam(value="maxIdleSeconds") @DefaultValue(value="604800") long dt) {
        return new DataChannel.DataChannelList(this.getListOfChannels(dt), System.currentTimeMillis() - dt * 1000L);
    }

    @GET
    @Path(value="/listchannels/{subsystem}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public DataChannel.DataChannelList getChannels(@PathParam(value="subsystem") String subsystemName, @QueryParam(value="maxIdleSeconds") @DefaultValue(value="604800") long dt) {
        List<DataChannel> channels = this.getListOfChannels(dt);
        ArrayList<DataChannel> subChannels = new ArrayList<DataChannel>();
        for (DataChannel dc : channels) {
            if (!dc.getPath()[0].equals(subsystemName)) continue;
            subChannels.add(dc);
        }
        return new DataChannel.DataChannelList(subChannels, System.currentTimeMillis() - dt * 1000L);
    }

    public DataChannel[] getChannels(String partialPath, int level) {
        return null;
    }

    public List<StatDesc> getAvailableStats(long rawId) {
        try (Session sess = this.fac.openSession();){
            List stats;
            List list = stats = sess.getNamedQuery("findStatDescById").setLong("id", rawId).setFlushMode(FlushMode.COMMIT).setCacheable(true).setReadOnly(true).setLockMode("sd", LockMode.NONE).list();
            return list;
        }
    }

    public List<RawData> getRawData(long id, long t1, long t2) {
        List l = null;
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("from RawData r where r.dataDesc.id = :id and r.time between :t1 and :t2 order by r.time");
            q.setReadOnly(true);
            q.setLockMode("r", LockMode.NONE);
            q.setParameter("id", (Object)id);
            q.setParameter("t1", (Object)t1);
            q.setParameter("t2", (Object)t2);
            l = q.list();
        }
        return l;
    }

    public List<StatData> getStatData(StatDesc statDesc, long t1, long t2) {
        List l = null;
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("from StatData r join fetch r.statTimeInterval where r.statDesc.id = :id and r.statTimeInterval.startTime > :tlow and r.statTimeInterval.startTime < :thigh order by r.statTimeInterval.startTime");
            q.setReadOnly(true);
            q.setLockMode("r", LockMode.NONE);
            q.setParameter("id", (Object)statDesc.getId());
            q.setParameter("tlow", (Object)(t1 - statDesc.getTimeBinWidth()));
            q.setParameter("thigh", (Object)t2);
            l = q.list();
        }
        return l;
    }

    protected Data exportRawData(String path, long rawId, long t1, long t2) {
        List<RawData> l = this.getRawData(rawId, t1, t2);
        Data d = new Data();
        d.setMetaDataData(this.getMetadataForChannel((int)rawId, t1, t2));
        TrendingData[] data = new TrendingData[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            TrendingData dt;
            RawData r = l.get(i);
            data[i] = dt = new TrendingData();
            long tStamp = r.getTime();
            TrendingData.AxisValue axisValue = new TrendingData.AxisValue("time", tStamp);
            dt.setAxisValue(axisValue);
            TrendingData.DataValue[] dataValue = new TrendingData.DataValue[1];
            Double dd = r.getDoubleData();
            dataValue[0] = dd == null ? new TrendingData.DataValue("value", r.getStringData()) : new TrendingData.DataValue("value", dd);
            dt.setDataValue(dataValue);
        }
        d.getTrendingResult().setTrendingDataArray(data);
        d.setId(rawId);
        d.setPath(path);
        return d;
    }

    protected Data exportStatDataFromRaw(String path, long rawId, long t1, long t2, int nsamples) {
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("select new org.lsst.ccs.localdb.statusdb.server.DataServer$StatEntry(min(rd.time), max(rd.time), sum(rd.doubleData),  sum(rd.doubleData*rd.doubleData), count(1), min(rd.doubleData), max(rd.doubleData)) from RawData rd where rd.dataDesc.id = :id and rd.time >= :t1  and rd.time < :t2  group by floor(rd.time/:deltat) having count(1) > 0 ORDER BY min(rd.time) ASC");
            q.setReadOnly(true);
            long deltat = (t2 - t1) / (long)nsamples;
            q.setParameter("id", (Object)rawId);
            q.setParameter("t1", (Object)t1);
            q.setParameter("t2", (Object)t2);
            q.setParameter("deltat", (Object)deltat);
            List l = q.list();
            ArrayList<TrendingData> trendingDataList = new ArrayList<TrendingData>();
            for (StatEntry se : l) {
                long low = se.getLow();
                long high = se.getHigh();
                TrendingData dt = new TrendingData();
                dt.setAxisValue(new TrendingData.AxisValue("time", (low + high) / 2L, low, high));
                TrendingData.DataValue[] dataValue = new TrendingData.DataValue[5];
                double value = se.getMean();
                double stddev = se.getStdDev();
                double min = se.getMin();
                double max = se.getMax();
                dataValue[0] = new TrendingData.DataValue("value", value);
                dataValue[1] = new TrendingData.DataValue("rms", stddev);
                dataValue[2] = new TrendingData.DataValue("stddev", stddev);
                dataValue[3] = new TrendingData.DataValue("min", min);
                dataValue[4] = new TrendingData.DataValue("max", max);
                dt.setDataValue(dataValue);
                trendingDataList.add(dt);
            }
            TrendingData[] trendingData = trendingDataList.toArray(new TrendingData[0]);
            Data d = new Data();
            d.setId(rawId);
            d.setPath(path);
            d.setMetaDataData(this.getMetadataForChannel((int)rawId, t1, t2));
            d.getTrendingResult().setTrendingDataArray(trendingData);
            Data data = d;
            return data;
        }
    }

    protected Data exportStatDataFromStat(String path, StatDesc statDesc, long t1, long t2, int nsamples) {
        List<StatData> in = this.getStatData(statDesc, t1, t2);
        int n = in.size();
        int rebin = 1;
        int nout = n;
        if (n > nsamples * 3) {
            rebin = n / nsamples;
            nout = (n + rebin - 1) / rebin;
            log.log(Level.FINEST, "will rebin stat by {0} : {1}", new Object[]{rebin, nout});
        }
        Data d = new Data();
        d.setMetaDataData(this.getMetadataForChannel((int)statDesc.getDataDesc().getId(), t1, t2));
        d.setPath(path);
        d.getTrendingResult().setTrendingDataArray(new TrendingData[nout]);
        int iout = 0;
        int ibin = 0;
        double sum = 0.0;
        double s2 = 0.0;
        long nsamp = 0L;
        long low = 0L;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (StatData sd : in) {
            if (ibin == 0) {
                sum = 0.0;
                s2 = 0.0;
                nsamp = 0L;
                low = sd.getStatTimeInterval().getStartTime();
                max = -1.7976931348623157E308;
                min = Double.MAX_VALUE;
            }
            sum += sd.getSum();
            s2 += sd.getSum2();
            if (sd.getMax() > max) {
                max = sd.getMax();
            }
            if (sd.getMin() < min) {
                min = sd.getMin();
            }
            nsamp += (long)sd.getN();
            if (ibin == rebin - 1 || iout * rebin + ibin == n - 1) {
                TrendingData dt;
                d.getTrendingResult().getTrendingDataArray()[iout] = dt = new TrendingData();
                dt.setAxisValue(new TrendingData.AxisValue("time", (low + sd.getStatTimeInterval().getEndTime()) / 2L, low, sd.getStatTimeInterval().getEndTime()));
                TrendingData.DataValue[] dataValue = new TrendingData.DataValue[5];
                dataValue[0] = new TrendingData.DataValue("value", sum / (double)nsamp);
                double stddev = Math.sqrt(s2 / (double)nsamp - sum / (double)nsamp * (sum / (double)nsamp));
                dataValue[1] = new TrendingData.DataValue("rms", stddev);
                dataValue[2] = new TrendingData.DataValue("stddev", stddev);
                dataValue[3] = new TrendingData.DataValue("min", min);
                dataValue[4] = new TrendingData.DataValue("max", max);
                dt.setDataValue(dataValue);
                ++iout;
                ibin = 0;
                continue;
            }
            ++ibin;
        }
        d.setId(statDesc.getDataDesc().getId());
        return d;
    }

    @GET
    @Path(value="liststates/{subsystem}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public StateInfo.StateInfoList getStateInfo(@PathParam(value="subsystem") String subsystem) {
        ArrayList<StateInfo> res = new ArrayList<StateInfo>();
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("select distinct isd from AgentState as ags inner join ags.componentStates as sbd inner join sbd.componentStates as isd where ags.agentDesc.agentName=:agentName").setString("agentName", subsystem).setReadOnly(true);
            HashMap<String, StateInfo> innerStateInfoMap = new HashMap<String, StateInfo>();
            List isdl = q.list();
            for (InnerStateDesc isd : isdl) {
                String isdClassName = isd.getEnumClassName();
                StateInfo si = (StateInfo)innerStateInfoMap.get(isdClassName);
                if (si == null) {
                    si = new StateInfo(isdClassName);
                    innerStateInfoMap.put(isdClassName, si);
                }
                si.getStateValues().add(isd.getEnumValue());
            }
            for (StateInfo si : innerStateInfoMap.values()) {
                res.add(si);
            }
        }
        return new StateInfo.StateInfoList(res);
    }

    @GET
    @Path(value="/statechanges/{subsystem}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public StateChange.StateChangesList getStateChangeList(@PathParam(value="subsystem") String subsystem, @QueryParam(value="state") List<String> states, @QueryParam(value="component") List<String> components, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        return this.innerGetStateChangeList(subsystem, components, states, t1, t2);
    }

    @GET
    @Path(value="/statechanges/{subsystem}/{component}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public StateChange.StateChangesList getComponentStateChangeList(@PathParam(value="subsystem") String subsystem, @PathParam(value="component") String component, @QueryParam(value="state") List<String> states, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        return this.innerGetStateChangeList(subsystem, Arrays.asList(component), states, t1, t2);
    }

    private StateChange.StateChangesList innerGetStateChangeList(String subsystem, List<String> components, List<String> states, long t1, long t2) {
        List<StateChangeNotificationData> stateChangeNotifications;
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        if ((stateChangeNotifications = this.getStateChanges(subsystem, t1, t2)).isEmpty()) {
            return new StateChange.StateChangesList();
        }
        ArrayList<StateChange> stateChanges = new ArrayList<StateChange>();
        StateChangeNotificationData firstSCND = stateChangeNotifications.get(0);
        Map<String, Map<String, String>> origStates = null;
        origStates = firstSCND.getTime() <= t1 ? firstSCND.getNewState().asFlatStatesMap(components) : firstSCND.getOldState().asFlatStatesMap(components);
        StateChange sc = new StateChange();
        sc.setTime(t1);
        for (Map.Entry<String, Map<String, String>> e1 : origStates.entrySet()) {
            for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                if (states != null && !states.isEmpty() && !states.contains(e2.getKey())) continue;
                sc.addStateEvent(e1.getKey(), e2.getKey(), e2.getValue());
            }
        }
        stateChanges.add(sc);
        StateChange originSE = sc;
        for (StateChangeNotificationData scnd : stateChangeNotifications) {
            if (scnd.getTime() <= t1) continue;
            sc = new StateChange();
            Map<String, Map<String, String>> oldState = scnd.getOldState().asFlatStatesMap(components);
            Map<String, Map<String, String>> newState = scnd.getNewState().asFlatStatesMap(components);
            for (Map.Entry<String, Map<String, String>> e1 : newState.entrySet()) {
                String component = e1.getKey();
                for (Map.Entry<String, String> e2 : e1.getValue().entrySet()) {
                    Map<String, String> prevCompStates;
                    String enumClassName = e2.getKey();
                    String enumValue = e2.getValue();
                    if (states != null && !states.isEmpty() && !states.contains(enumClassName) || (prevCompStates = oldState.get(component)) != null && enumValue.equals(prevCompStates.get(enumClassName))) continue;
                    sc.addStateEvent(component, enumClassName, enumValue);
                    if (originSE.containsEvent(component, enumClassName)) continue;
                    originSE.addStateEvent(component, enumClassName, "_UNDEF_");
                }
            }
            if (sc.isEmpty()) continue;
            sc.setTime(scnd.getTime());
            stateChanges.add(sc);
        }
        return new StateChange.StateChangesList(stateChanges);
    }

    private List<StateChangeNotificationData> getStateChanges(String subsystemName, long t1, long t2) {
        List res = null;
        try (Session sess = this.fac.openSession();){
            Query q = sess.createQuery("from StateChangeNotificationData scnd where scnd.agentDesc.agentName=:name and scnd.time >:t1 and scnd.time <=:t2").setString("name", subsystemName).setLong("t1", t1).setLong("t2", t2).setReadOnly(true);
            res = q.list();
            if (res.isEmpty()) {
                q = sess.createQuery("from StateChangeNotificationData scnd where scnd.agentDesc.agentName=:name and scnd.time <=:t1 order by scnd.time desc").setString("name", subsystemName).setLong("t1", t1).setMaxResults(1).setReadOnly(true);
                res = q.list();
            }
        }
        return res;
    }

    @Path(value="/listalerts")
    @GET
    public AlertInfo.AlertInfoList getAlertInfo() {
        return this.getAlertInfo(null);
    }

    @Path(value="/listalerts/{subsystem}")
    @GET
    public AlertInfo.AlertInfoList getAlertInfo(@PathParam(value="subsystem") String subsystem) {
        ArrayList<AlertInfo> res = new ArrayList<AlertInfo>();
        try (Session sess = this.fac.openSession();){
            Query q = subsystem == null ? sess.createQuery("from AlertDesc ad") : sess.createQuery("from AlertDesc ad where ad.agentDesc.agentName=:name").setString("name", subsystem);
            q.setReadOnly(true);
            List l = q.list();
            for (AlertDesc ad : l) {
                res.add(new AlertInfo(ad.getId(), ad.getAgentDesc().getAgentName(), ad.getAlertId(), ad.getAlertDescription()));
            }
        }
        return new AlertInfo.AlertInfoList(res);
    }

    @Path(value="activealerts")
    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public AlertEvent.AlertEventList getActiveAlerts(@QueryParam(value="id") List<Long> ids) {
        ArrayList<AlertEvent> res = new ArrayList<AlertEvent>();
        try (Session sess = this.fac.openSession();){
            Query q = ids == null || ids.isEmpty() ? sess.createQuery("from RaisedAlertData arad where arad.active=true") : sess.createQuery("from RaisedAlertData arad where arad.alertDesc.id in (:ids) and arad.active=true").setParameterList("ids", ids).setReadOnly(true);
            q.setReadOnly(true);
            for (RaisedAlertData rad : q.list()) {
                AlertEvent ae = new AlertEvent(rad.getAlertDesc().getAlertId(), rad.getTime(), rad.getSeverity(), rad.getAlertCause());
                ae.setCleared(rad.getClearingAlert() != null);
                res.add(ae);
            }
        }
        return new AlertEvent.AlertEventList(res);
    }

    @Path(value="alerthistory")
    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public AlertEvent.AlertEventList getAlertHistories(@QueryParam(value="id") List<Long> ids, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2) {
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        ArrayList<AlertEvent> res = new ArrayList<AlertEvent>();
        try (Session sess = this.fac.openSession();){
            Query q = ids == null || ids.isEmpty() ? sess.createQuery("from RaisedAlertData arad") : sess.createQuery("from RaisedAlertData arad where arad.alertDesc.id in (:ids)").setParameterList("ids", ids).setReadOnly(true);
            q.setReadOnly(true);
            for (RaisedAlertData rad : q.list()) {
                AlertEvent ae = new AlertEvent(rad.getAlertDesc().getAlertId(), rad.getTime(), rad.getSeverity(), rad.getAlertCause());
                ae.setCleared(rad.getClearingAlert() != null);
                res.add(ae);
            }
        }
        return new AlertEvent.AlertEventList(res);
    }

    protected static class StatEntry {
        long low;
        long high;
        double sum1;
        double sum2;
        double min;
        double max;
        long n;

        public StatEntry(long low, long high, double sum1, double sum2, long n, double min, double max) {
            this.low = low;
            this.high = high;
            this.sum1 = sum1;
            this.sum2 = sum2;
            this.min = min;
            this.max = max;
            this.n = n;
        }

        public long getLow() {
            return this.low;
        }

        public long getHigh() {
            return this.high;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getMean() {
            return this.n > 0L ? this.sum1 / (double)this.n : 0.0;
        }

        public double getStdDev() {
            double nd = this.n;
            return this.n > 0L ? Math.sqrt(this.sum2 / nd - this.sum1 * this.sum1 / (nd * nd)) : 0.0;
        }
    }
}

