/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.blocks.Marshaller;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodInvoker;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.util.Buffer;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcher
extends MessageDispatcher {
    protected Object server_obj;
    protected Marshaller marshaller;
    protected MethodLookup method_lookup;
    protected MethodInvoker method_invoker;

    public RpcDispatcher() {
    }

    public RpcDispatcher(JChannel channel, Object server_obj) {
        super(channel);
        this.setRequestHandler(this);
        this.server_obj = server_obj;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public RpcDispatcher setMarshaller(Marshaller m) {
        this.marshaller = m;
        if (this.corr != null) {
            this.corr.setMarshaller(m);
        }
        return this;
    }

    public Object getServerObject() {
        return this.server_obj;
    }

    public RpcDispatcher setServerObject(Object server_obj) {
        this.server_obj = server_obj;
        return this;
    }

    public RpcDispatcher setMembershipListener(MembershipListener l) {
        return (RpcDispatcher)super.setMembershipListener(l);
    }

    public MethodLookup getMethodLookup() {
        return this.method_lookup;
    }

    public RpcDispatcher setMethodLookup(MethodLookup method_lookup) {
        this.method_lookup = method_lookup;
        return this;
    }

    public MethodInvoker getMethodInvoker() {
        return this.method_invoker;
    }

    public RpcDispatcher setMethodInvoker(MethodInvoker mi) {
        this.method_invoker = mi;
        return this;
    }

    public <T> RspList<T> callRemoteMethods(Collection<Address> dests, String method_name, Object[] args, Class[] types, RequestOptions options) throws Exception {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, options);
    }

    public <T> RspList<T> callRemoteMethods(Collection<Address> dests, MethodCall method_call, RequestOptions opts) throws Exception {
        if (dests != null && dests.isEmpty()) {
            this.log.trace("destination list of %s() is empty: no need to send message", method_call.methodName());
            return empty_rsplist;
        }
        Buffer buf = RpcDispatcher.methodCallToBuffer(method_call, this.marshaller);
        RspList retval = super.castMessage(dests, buf, opts);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dests=%s, method_call=%s, options=%s, responses: %s", dests, method_call, opts, retval);
        }
        return retval;
    }

    public <T> CompletableFuture<RspList<T>> callRemoteMethodsWithFuture(Collection<Address> dests, MethodCall method_call, RequestOptions options) throws Exception {
        if (dests != null && dests.isEmpty()) {
            this.log.trace("destination list of %s() is empty: no need to send message", method_call.methodName());
            return CompletableFuture.completedFuture(empty_rsplist);
        }
        Buffer buf = RpcDispatcher.methodCallToBuffer(method_call, this.marshaller);
        CompletableFuture retval = super.castMessageWithFuture(dests, buf, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dests=%s, method_call=%s, options=%s", dests, method_call, options);
        }
        return retval;
    }

    public <T> T callRemoteMethod(Address dest, String meth, Object[] args, Class[] types, RequestOptions opts) throws Exception {
        MethodCall method_call = new MethodCall(meth, args, types);
        return this.callRemoteMethod(dest, method_call, opts);
    }

    public <T> T callRemoteMethod(Address dest, MethodCall call, RequestOptions options) throws Exception {
        Buffer buf = RpcDispatcher.methodCallToBuffer(call, this.marshaller);
        Object retval = super.sendMessage(dest, buf, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=%s, method_call=%s, options=%s, retval: %s", dest, call, options, retval);
        }
        return retval;
    }

    public <T> CompletableFuture<T> callRemoteMethodWithFuture(Address dest, MethodCall call, RequestOptions opts) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=%s, method_call=%s, options=%s", dest, call, opts);
        }
        Buffer buf = RpcDispatcher.methodCallToBuffer(call, this.marshaller);
        return super.sendMessageWithFuture(dest, buf, opts);
    }

    @Override
    public Object handle(Message req) throws Exception {
        if (this.server_obj == null) {
            this.log.error(Util.getMessage("NoMethodHandlerIsRegisteredDiscardingRequest"));
            return null;
        }
        if (req == null || req.getLength() == 0) {
            this.log.error(Util.getMessage("MessageOrMessageBufferIsNull"));
            return null;
        }
        MethodCall method_call = RpcDispatcher.methodCallFromBuffer(req.getRawBuffer(), req.getOffset(), req.getLength(), this.marshaller);
        if (this.log.isTraceEnabled()) {
            this.log.trace("[sender=%s], method_call: %s", req.getSrc(), method_call);
        }
        if (method_call.mode() == 3) {
            if (this.method_invoker != null) {
                return this.method_invoker.invoke(this.server_obj, method_call.methodId(), method_call.args());
            }
            if (this.method_lookup == null) {
                throw new Exception(String.format("MethodCall uses ID=%d, but method_lookup has not been set", method_call.methodId()));
            }
            Method m = this.method_lookup.findMethod(method_call.methodId());
            if (m == null) {
                throw new Exception("no method found for " + method_call.methodId());
            }
            method_call.method(m);
        }
        return method_call.invoke(this.server_obj);
    }

    protected static Buffer methodCallToBuffer(MethodCall call, Marshaller marshaller) throws Exception {
        Object[] args = call.args();
        int estimated_size = 64;
        if (args != null) {
            for (Object arg : args) {
                estimated_size += marshaller != null ? marshaller.estimatedSize(arg) : (arg == null ? 2 : 50);
            }
        }
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(estimated_size, true);
        call.writeTo(out, marshaller);
        return out.getBuffer();
    }

    protected static MethodCall methodCallFromBuffer(byte[] buf, int offset, int length, Marshaller marshaller) throws Exception {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        MethodCall call = new MethodCall();
        call.readFrom(in, marshaller);
        return call;
    }

    @Override
    protected void correlatorStarted() {
        if (this.corr != null) {
            this.corr.setMarshaller(this.marshaller);
        }
    }
}

