/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.function.Supplier;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Measurement;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.chiller.Chiller;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.constants.ChillerAlerts;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class InTESTChillerDevice
extends Device {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alert;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent subsys;
    private final Chiller chiller = new Chiller();
    private Integer chanKey;
    private boolean readHeatCool = false;
    private double[] heatCool;
    private Chiller.ErrorWords lastErrorWords;
    private boolean clearAgain = false;
    private volatile AlertState lastErrorAlert;
    private volatile ChillerState lastState;
    private volatile boolean expectSetpoint = false;
    private boolean departedSetPoint = false;
    private volatile Measurement coldplateTemperature;
    private volatile boolean dutMode;
    private volatile int sentDut;
    @ConfigurationParameter(isFinal=true, description="IP host")
    protected volatile String host;
    private static final Logger LOG = Logger.getLogger(InTESTChillerDevice.class.getName());

    protected void initDevice() {
        this.fullName = "InTESTChiller " + this.name + " (" + this.host + ")";
        this.chanKey = 0;
        this.lastErrorAlert = AlertState.NOMINAL;
        this.lastErrorWords = new Chiller.ErrorWords(0, 0, 0, 0);
        this.lastState = ChillerState.OFFLINE;
        if (this.host == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"host", (String)"is missing");
        }
        this.alert.registerAlert(ChillerAlerts.CHILLER_ERR.newAlert());
        this.alert.registerAlert(ChillerAlerts.DEPARTED_SETPT.newAlert());
        this.stateService.registerState(ChillerState.class, "Chiller State", (Object)this.subsys);
        this.stateService.updateAgentState(new Enum[]{this.lastState});
    }

    protected String getGroupForChannel(Channel ch) {
        if (ch.getTypeStr().equals("HC")) {
            LOG.info("\n Assign heatCool group for Channel " + ch.getName());
            return "heatCool";
        }
        return null;
    }

    protected void initialize() {
        try {
            this.chiller.open(this.host);
            this.shutdownDUT();
            this.initSensors();
            this.setOnline(true);
            LOG.info("\n Connected to " + this.fullName);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe("Error connecting to or initializaing " + this.fullName + ": " + (Object)((Object)e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.chiller.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        String subtype = ch.getSubTypeStr();
        String name = ch.getName();
        try {
            switch (type) {
                case "Temp": {
                    Chiller.Query qu = Chiller.Query.valueOf((String)subtype);
                    if (!qu.getIsTemp()) {
                        throw new IllegalArgumentException("bad subtype");
                    }
                    break;
                }
                case "Flow": {
                    Chiller.Query.valueOf((String)subtype);
                    break;
                }
                case "Pres": {
                    Chiller.Query.valueOf((String)subtype);
                    break;
                }
                case "HC": {
                    if (!subtype.equals("Heat") && !subtype.equals("Cool")) {
                        throw new IllegalArgumentException("bad subtype");
                    }
                    this.readHeatCool = true;
                    break;
                }
                case "Life": {
                    Chiller.Life.valueOf((String)subtype);
                    break;
                }
                case "Register": {
                    if (!subtype.equals("Status")) {
                        throw new IllegalArgumentException("bad subtype");
                    }
                    break;
                }
                case "ColdPlate": {
                    if (!subtype.equals("Average")) {
                        throw new IllegalArgumentException("bad subtype");
                    }
                    break;
                }
                default: {
                    ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)(type + " subtype "), (Object)subtype);
        }
        Object object = this.chanKey;
        Integer n = this.chanKey = Integer.valueOf(this.chanKey + 1);
        return new int[]{this.chanKey, 0};
    }

    void updateColdplateTemp(double value, CCSTimeStamp ts) {
        this.coldplateTemperature = new Measurement(value, ts);
    }

    protected void readChannelGroup(String group) {
        if (!this.isOnline()) {
            return;
        }
        if (group.equals("heatCool") && this.readHeatCool) {
            try {
                this.heatCool = this.chiller.getHeatCool();
            }
            catch (DriverTimeoutException et) {
                LOG.severe("Chiller timeout reading HeatCool:  " + (Object)((Object)et));
                this.setOnline(false);
                this.lastState = ChillerState.OFFLINE;
                if (this.lastState != this.stateService.getState(ChillerState.class)) {
                    this.stateService.updateAgentState(new Enum[]{this.lastState});
                }
            }
            catch (DriverException e) {
                LOG.severe("Chiller exception reading HeatCool:  " + (Object)((Object)e));
            }
        }
    }

    protected double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        if (!this.isOnline()) {
            return value;
        }
        String itemType = ch.getTypeStr();
        String item = ch.getSubTypeStr();
        if (itemType.equals("HC")) {
            if (item.equals("Heat")) {
                value = this.heatCool[0];
            } else if (item.equals("Cool")) {
                value = this.heatCool[1];
            }
        } else {
            try {
                switch (itemType) {
                    case "Temp": {
                        if (item.equals("T_PROBE2") && this.sentDut < 2) break;
                        double tempValue = this.chiller.getTemperature(Chiller.Query.valueOf((String)item));
                        if (tempValue < 699.0) {
                            value = tempValue;
                        }
                        break;
                    }
                    case "Flow": {
                        value = this.chiller.getFlow(Chiller.Query.valueOf((String)item));
                        break;
                    }
                    case "Pres": {
                        value = this.chiller.getPressure(Chiller.Query.valueOf((String)item));
                        break;
                    }
                    case "Life": {
                        value = this.chiller.getLifetime(Chiller.Life.valueOf((String)item));
                        break;
                    }
                    case "ColdPlate": {
                        if (this.coldplateTemperature == null) break;
                        value = this.coldplateTemperature.getValue();
                        break;
                    }
                    case "Register": {
                        if (!item.equals("Status")) break;
                        int status = this.chiller.getStatusReg();
                        value = status;
                        Chiller.ErrorWords errorWords = this.chiller.getErrorWords();
                        this.checkForErrors(status, errorWords);
                        ChillerState st = this.getState(status);
                        if (st == this.lastState) break;
                        this.stateService.updateAgentState(new Enum[]{st});
                        this.lastState = st;
                        if (st == ChillerState.SETPOINT) {
                            this.expectSetpoint = true;
                            if (!this.departedSetPoint) break;
                            this.alert.raiseAlert(ChillerAlerts.DEPARTED_SETPT.newAlert(), AlertState.NOMINAL, "");
                            this.departedSetPoint = false;
                            break;
                        }
                        if (!this.expectSetpoint) break;
                        this.alert.raiseAlert(ChillerAlerts.DEPARTED_SETPT.newAlert(), AlertState.ALARM, "Chiller left SETPOINT for unknown reason");
                        this.departedSetPoint = true;
                        this.expectSetpoint = false;
                    }
                }
            }
            catch (DriverTimeoutException et) {
                LOG.severe("Chiller timeout reading data " + item + ": " + (Object)((Object)et));
                this.setOnline(false);
                this.lastState = ChillerState.OFFLINE;
                if (this.lastState != this.stateService.getState(ChillerState.class)) {
                    this.stateService.updateAgentState(new Enum[]{this.lastState});
                }
            }
            catch (DriverException e) {
                LOG.severe("Chiller exception reading data " + item + ": " + (Object)((Object)e));
            }
        }
        return value;
    }

    void sendDUTData() {
        if (this.isOnline()) {
            try {
                this.chiller.writeDUT(this.coldplateTemperature.getValue());
                ++this.sentDut;
                if (this.sentDut == 1) {
                    LOG.info("Sending first DUT temperature tp Chiller, " + Double.toString(this.coldplateTemperature.getValue()));
                }
            }
            catch (DriverException ex) {
                LOG.severe("Driver Exception " + (Object)((Object)ex) + " while sending DUT data");
                this.setOnline(false);
            }
        }
    }

    private ChillerState getState(int status) {
        ChillerState state = ChillerState.OFF;
        if ((status & Chiller.StatusRegister.AT_SETPT.getMask()) != 0) {
            state = ChillerState.SETPOINT;
        } else if ((status & Chiller.StatusRegister.T_CONTROL.getMask()) != 0) {
            state = ChillerState.CONTROLLING;
        } else if ((status & Chiller.StatusRegister.CMPRS_ON.getMask()) != 0) {
            state = ChillerState.IDLE;
        }
        return state;
    }

    public boolean getTempControlMode() {
        return this.dutMode;
    }

    private void checkForErrors(int status, Chiller.ErrorWords errorWords) {
        boolean raise;
        boolean warning;
        boolean error = (status & Chiller.StatusRegister.ERROR.getMask()) != 0;
        boolean bl = warning = (status & Chiller.StatusRegister.WARNING.getMask()) != 0;
        AlertState errorAlert = error ? AlertState.ALARM : (warning ? AlertState.WARNING : AlertState.NOMINAL);
        boolean bl2 = raise = errorAlert != this.lastErrorAlert;
        if (!raise && errorAlert != AlertState.NOMINAL && !errorWords.equals((Object)this.lastErrorWords)) {
            raise = true;
        }
        if (raise) {
            this.alert.raiseAlert(ChillerAlerts.CHILLER_ERR.newAlert(), errorAlert, "Chiller " + errorWords.toString());
            if (errorAlert != AlertState.NOMINAL) {
                try {
                    this.chiller.clearErrors();
                }
                catch (DriverException e) {
                    LOG.severe("Chiller exception clearing errors: " + (Object)((Object)e));
                }
                this.clearAgain = true;
            }
        } else {
            if (this.clearAgain && errorAlert != AlertState.NOMINAL) {
                try {
                    this.chiller.clearErrors();
                }
                catch (DriverException e) {
                    LOG.severe("Chiller exception clearing errors: " + (Object)((Object)e));
                }
            }
            this.clearAgain = false;
        }
        this.lastErrorWords = errorWords;
        this.lastErrorAlert = errorAlert;
        if (error) {
            this.expectSetpoint = false;
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="listQueries", description="List available queries")
    public String listQueries() {
        return this.chiller.listQueries();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="listStatusBits", description="List status register bits")
    public String listStatusBits() {
        return this.chiller.listStatusBits();
    }

    public AlertState getLastErrorAlert() {
        return this.lastErrorAlert;
    }

    public Chiller.ErrorWords getLastErrorWords() {
        return this.lastErrorWords;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="queryChiller", description="send specified query to chiller")
    public String queryChiller(@Argument(description="Read Enumerated quantity from Chiller") Chiller.Query quantity) throws DriverException {
        String response = "";
        try {
            response = this.chiller.queryChiller(quantity);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
        return response;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="readAnyParameter", description="Read value of specified parameter")
    public String readAnyParameter(@Argument(description="index of parameter") int index) throws DriverException {
        String response = "";
        try {
            String str = this.chiller.readParameter(index);
            response = str.substring(str.lastIndexOf(32) + 1);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
        return response;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="listSettableParameters", description="List parameters available for public setting")
    public String listSettableParameters() {
        return this.chiller.listNamedParameters();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="readNamedParameter", description="Read value of named parameter")
    public String readNamedParameter(@Argument(description="enum of parameter") Chiller.FParam param) throws DriverException {
        String response = "";
        try {
            String str = this.chiller.readNamedParameter(param);
            response = str.substring(str.lastIndexOf(32) + 1);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
        return response;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="showEvtReg", description="Show decoded Event Register")
    public String showEvtReg() throws DriverException {
        return this.chiller.decodeEvtReg();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showStatusReg", description="Show decoded Event Register")
    public String showStatusReg() throws DriverException {
        return this.chiller.decodeStatusReg();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showErrorWords", description="Show error and warning words in hex")
    public String showErrorWords() throws DriverException {
        return this.chiller.getErrorWords().toString();
    }

    public ChillerState getChillerState() {
        return this.lastState;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showChillerState", description="Show ChillerState")
    public String showChillerState() {
        ChillerState st = this.getChillerState();
        return st.toString() + ":  " + st.getDescription();
    }

    public double getDefaultRamp() {
        double value = Double.NaN;
        if (this.isOnline()) {
            try {
                value = Double.valueOf(this.readNamedParameter(Chiller.FParam.RAMP_DEFAULT));
            }
            catch (NumberFormatException | DriverException throwable) {
                // empty catch block
            }
        }
        return value;
    }

    private void checkCommand(DriverTimeoutException ex) throws DriverException {
        String eventReg = "";
        try {
            eventReg = this.chiller.decodeEvtReg();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (eventReg.contains("BAD_CMND")) {
            throw new DriverException("Chiller command not recognizw");
        }
        if (eventReg.contains("BAD_ARG")) {
            throw new IllegalArgumentException("Bad argument(s) to Chiller comand");
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setParam", description="Invoke Chiller command tp set named parameter")
    public void setParam(@Argument(description="enumerated parameter") Chiller.FParam param, @Argument(description="parameter value") double value) throws DriverException {
        try {
            this.chiller.setParamCommand(param, value);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setTankPressure", description="Set tank pressure in psig")
    public void setTankPressure(@Argument(description="Tank pressure set value in psig") double value) throws DriverException {
        this.setParam(Chiller.FParam.TANK_SETPOINT, value);
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="selectDUT", autoAck=false, description="Select DUT vs Normal temperature-control mode")
    public void selectDUT(@Argument(description="true for DUT") boolean dut) throws DriverException {
        this.subsys.helper().precondition(this.lastState != ChillerState.SETPOINT && this.lastState != ChillerState.CONTROLLING, "Isssue quitControllingTemperature before changing temperature-control mode", new Supplier[0]).action(() -> {
            this.setParam(Chiller.FParam.T_CTRL_MODE, dut ? 1.0 : 0.0);
            if (dut && !this.dutMode) {
                this.sendDUTData();
            } else if (!dut && this.dutMode) {
                this.sentDut = 0;
            }
            this.dutMode = dut;
        });
    }

    void shutdownDUT() throws DriverException {
        if (this.dutMode) {
            this.quitControllingTemperature();
            this.setParam(Chiller.FParam.T_CTRL_MODE, 0.0);
            this.dutMode = false;
            this.sentDut = 0;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="saveChillerParameters", description="save all current chiller F# parameters to active NVM")
    public void saveChillerParameters() throws DriverException {
        this.chiller.saveParams();
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="loadChillerParameters", description="load all chiller F# parameters from active NVM")
    public void loadChillerParameters() throws DriverException {
        this.chiller.loadParams();
    }

    public void setTemperature(@Argument(description="tempeature in degrees") double temperature) throws DriverException {
        this.expectSetpoint = false;
        try {
            this.chiller.setTemperature(temperature);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
    }

    public void setTemperatureWithRamp(@Argument(description="tempeature in degrees") double temperature, @Argument(description="ramp in degrees/min") double ramp) throws DriverException {
        this.expectSetpoint = false;
        try {
            this.chiller.setTemperatureWithRamp(temperature, ramp);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="quitControllingTemperature", description="stop controlling temperature")
    public void quitControllingTemperature() throws DriverException {
        this.expectSetpoint = false;
        this.chiller.quitControl();
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setFlow", description="set flow rate (gpm) of chilled fluie")
    public void setFlow(@Argument(description="flow rate in gpm") double flow) throws DriverException {
        try {
            this.chiller.setFlow(flow);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="emergencyCleaErrors", description="clear chiller errors and warnings")
    public void emergencyClearErrors() throws DriverException {
        this.chiller.clearErrors();
        this.chiller.clearGuiErrorScreen();
    }
}

