/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.om.XMLChar;

public class BuggyCharacterSet
implements CharacterSet {
    private static HashMap map;
    private CharsetEncoder encoder;
    private byte[] charinfo = new byte[65536];
    private static final byte GOOD = 1;
    private static final byte BAD = 2;

    private BuggyCharacterSet(Charset charset) {
        this.encoder = charset.newEncoder();
    }

    public static synchronized BuggyCharacterSet makeCharSet(Charset charset) {
        BuggyCharacterSet buggyCharacterSet;
        if (map == null) {
            map = new HashMap(10);
        }
        if ((buggyCharacterSet = (BuggyCharacterSet)map.get(charset)) == null) {
            buggyCharacterSet = new BuggyCharacterSet(charset);
            map.put(charset, buggyCharacterSet);
        }
        return buggyCharacterSet;
    }

    public final boolean inCharset(int n) {
        if (n <= 127) {
            return true;
        }
        try {
            if (n <= 65535) {
                if (this.charinfo[n] == 1) {
                    return true;
                }
                if (this.charinfo[n] == 2) {
                    return false;
                }
                this.charinfo[n] = 2;
                char[] cArray = new char[]{(char)n};
                this.encoder.encode(CharBuffer.wrap(cArray));
                this.charinfo[n] = 1;
                return true;
            }
            char[] cArray = new char[]{XMLChar.highSurrogate(n), XMLChar.lowSurrogate(n)};
            this.encoder.encode(CharBuffer.wrap(cArray));
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }
}

