/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.swagger.model.Recipient;
import com.ifountain.opsgenie.client.swagger.model.TeamRecipient;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;

public class CreateAlertRequest {
    @JsonProperty(value="user")
    private String user = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="source")
    private String source = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="alias")
    private String alias = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="teams")
    private List<TeamRecipient> teams = new ArrayList<TeamRecipient>();
    @JsonProperty(value="visibleTo")
    private List<Recipient> visibleTo = new ArrayList<Recipient>();
    @JsonProperty(value="actions")
    private List<String> actions = new ArrayList<String>();
    @JsonProperty(value="tags")
    private List<String> tags = new ArrayList<String>();
    @JsonProperty(value="details")
    private Map<String, String> details = new HashMap<String, String>();
    @JsonProperty(value="entity")
    private String entity = null;
    @JsonProperty(value="priority")
    private PriorityEnum priority = null;

    public CreateAlertRequest user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="Display name of the request owner")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public CreateAlertRequest note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="Additional note that will be added while creating the alert")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public CreateAlertRequest source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="Source field of the alert. Default value is IP address of the incoming request")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public CreateAlertRequest message(String message) {
        this.message = message;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Message of the alert")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CreateAlertRequest alias(String alias) {
        this.alias = alias;
        return this;
    }

    @ApiModelProperty(value="Client-defined identifier of the alert, that is also the key element of alert deduplication.")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public CreateAlertRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description field of the alert that is generally used to provide a detailed information about the alert.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateAlertRequest teams(List<TeamRecipient> teams) {
        this.teams = teams;
        return this;
    }

    public CreateAlertRequest addTeamsItem(TeamRecipient teamsItem) {
        this.teams.add(teamsItem);
        return this;
    }

    @ApiModelProperty(value="Teams that the alert will be routed to send notifications")
    public List<TeamRecipient> getTeams() {
        return this.teams;
    }

    public void setTeams(List<TeamRecipient> teams) {
        this.teams = teams;
    }

    public CreateAlertRequest visibleTo(List<Recipient> visibleTo) {
        this.visibleTo = visibleTo;
        return this;
    }

    public CreateAlertRequest addVisibleToItem(Recipient visibleToItem) {
        this.visibleTo.add(visibleToItem);
        return this;
    }

    @ApiModelProperty(value="Teams and users that the alert will become visible to without sending any notification")
    public List<Recipient> getVisibleTo() {
        return this.visibleTo;
    }

    public void setVisibleTo(List<Recipient> visibleTo) {
        this.visibleTo = visibleTo;
    }

    public CreateAlertRequest actions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public CreateAlertRequest addActionsItem(String actionsItem) {
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="Custom actions that will be available for the alert")
    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public CreateAlertRequest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateAlertRequest addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tags of the alert")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public CreateAlertRequest details(Map<String, String> details) {
        this.details = details;
        return this;
    }

    public CreateAlertRequest putDetailsItem(String key, String detailsItem) {
        this.details.put(key, detailsItem);
        return this;
    }

    @ApiModelProperty(value="Map of key-value pairs to use as custom properties of the alert")
    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public CreateAlertRequest entity(String entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(value="Entity field of the alert that is generally used to specify which domain alert is related to")
    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public CreateAlertRequest priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="Priority level of the alert")
    public PriorityEnum getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAlertRequest createAlertRequest = (CreateAlertRequest)o;
        return ObjectUtils.equals((Object)this.user, (Object)createAlertRequest.user) && ObjectUtils.equals((Object)this.note, (Object)createAlertRequest.note) && ObjectUtils.equals((Object)this.source, (Object)createAlertRequest.source) && ObjectUtils.equals((Object)this.message, (Object)createAlertRequest.message) && ObjectUtils.equals((Object)this.alias, (Object)createAlertRequest.alias) && ObjectUtils.equals((Object)this.description, (Object)createAlertRequest.description) && ObjectUtils.equals(this.teams, createAlertRequest.teams) && ObjectUtils.equals(this.visibleTo, createAlertRequest.visibleTo) && ObjectUtils.equals(this.actions, createAlertRequest.actions) && ObjectUtils.equals(this.tags, createAlertRequest.tags) && ObjectUtils.equals(this.details, createAlertRequest.details) && ObjectUtils.equals((Object)this.entity, (Object)createAlertRequest.entity) && ObjectUtils.equals((Object)((Object)this.priority), (Object)((Object)createAlertRequest.priority));
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.user, this.note, this.source, this.message, this.alias, this.description, this.teams, this.visibleTo, this.actions, this.tags, this.details, this.entity, this.priority});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAlertRequest {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    teams: ").append(this.toIndentedString(this.teams)).append("\n");
        sb.append("    visibleTo: ").append(this.toIndentedString(this.visibleTo)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PriorityEnum {
        P1("P1"),
        P2("P2"),
        P3("P3"),
        P4("P4"),
        P5("P5");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PriorityEnum fromValue(String text) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

