/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.AsciiFuncs;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.config.WaitForHeaderService;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.location.Location;

class PostImageFileHandling {
    private static final Logger LOG = Logger.getLogger(PostImageFileHandling.class.getName());
    private final ImageHandlingConfig config;
    private final AtomicBoolean isHeaderServiceEnabled;
    private final Map<String, CompletableFuture<List<ImageHeaderData.Header>>> futureHeaderDataForImage = new ConcurrentHashMap<String, CompletableFuture<List<ImageHeaderData.Header>>>();
    private final CommandExecutor commandExecutor;
    private final AlertService alertService;

    PostImageFileHandling(ImageHandlingConfig config, CommandExecutor commandExecutor, AlertService alertService) {
        this.config = config;
        this.isHeaderServiceEnabled = new AtomicBoolean(true);
        this.commandExecutor = commandExecutor;
        this.alertService = alertService;
    }

    CompletableFuture<FileList> handleHeaderServiceData(CompletableFuture<FileList> filesToProcess, String imageName) {
        CompletionStage<FileList> resultingFileList = filesToProcess;
        if (this.config.getWaitForHeaderService() == WaitForHeaderService.ALWAYS || this.config.getWaitForHeaderService() == WaitForHeaderService.AUTO && this.isHeaderServiceEnabled.get()) {
            CompletableFuture<List<ImageHeaderData.Header>> futureHeaderData = this.getHeaderDataFutureForImage(imageName);
            resultingFileList = resultingFileList.thenCombine(futureHeaderData, (fl, headerData) -> this.mergeHeaderServiceData((FileList)fl, (List<ImageHeaderData.Header>)headerData));
        }
        return resultingFileList;
    }

    FileList mergeHeaderServiceData(FileList fl, List<ImageHeaderData.Header> headerData) {
        String message = null;
        if (headerData == null) {
            message = "Header service data did not arrive in a timely manner";
            LOG.log(Level.WARNING, message);
        } else {
            try {
                this.fixupFitsFiles(fl, headerData);
            }
            catch (IOException | FitsException x) {
                message = "Error while fixing FITS headers";
                LOG.log(Level.WARNING, message, x);
            }
        }
        if (message != null && this.alertService != null && this.config.getRaiseAlertOnMissingOrBadHeaderServiceData()) {
            Alert alert = new Alert("missingHeaders", "Missing or malformed header service data");
            this.alertService.raiseAlert(alert, AlertState.ALARM, message);
        }
        return fl;
    }

    void handleFitsFileCommands(CompletableFuture<FileList> filesToProcess, Location location, String imageName, String mode) {
        if (!this.config.getCommands().isEmpty()) {
            filesToProcess.thenAccept(fl -> {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("BOARD", location.getBoardName());
                env.put("RAFT", location.getRaftName());
                env.put("IMAGENAME", imageName);
                env.put("MODE", mode);
                try {
                    ImageName in = new ImageName(imageName);
                    env.put("SEQNO", in.getNumberString());
                    env.put("DATE", in.getDateString());
                    env.put("CONTROLLER", in.getController().getCode());
                    env.put("SOURCE", in.getSource().getCode());
                }
                catch (IllegalArgumentException x) {
                    env.put("SEQNO", "UNKNOWN");
                    env.put("DATE", "UNKNOWN");
                    env.put("CONTROLLER", "UNKNOWN");
                    env.put("SOURCE", "UNKNOWN");
                }
                this.commandExecutor.executeFitsFileList((FileList)fl, (Map<String, String>)env);
            });
        }
    }

    private void fixupFitsFiles(FileList fileList, List<ImageHeaderData.Header> headerData) throws FitsException, IOException {
        for (File file : fileList) {
            Fits fits = new Fits(file);
            BasicHDU hdu = fits.getHDU(0);
            Header header = hdu.getHeader();
            long deltaCheckSum = 0L;
            for (ImageHeaderData.Header headerServiceHeader : headerData) {
                String keyword = headerServiceHeader.getKeyword();
                if (keyword == null || "COMMENT".equals(keyword)) continue;
                if (keyword.startsWith("HIERARCH")) {
                    keyword = keyword.replace(" ", ".");
                }
                HeaderCard card = header.findCard(keyword);
                String newValue = headerServiceHeader.getValue();
                if (card != null) {
                    String oldValue = card.getValue();
                    if ((oldValue == null || oldValue.isEmpty()) && newValue != null && !newValue.isEmpty()) {
                        long oldCheckSum = FitsCheckSum.checksum((byte[])AsciiFuncs.getBytes((String)card.toString()));
                        if (!this.isString(newValue)) {
                            card.setValue(headerServiceHeader.getValue());
                        } else {
                            card = new HeaderCard(card.getKey(), newValue, card.getComment());
                            header.updateLine(card.getKey(), card);
                        }
                        long newCheckSum = FitsCheckSum.checksum((byte[])AsciiFuncs.getBytes((String)card.toString()));
                        deltaCheckSum += newCheckSum - oldCheckSum;
                        continue;
                    }
                    if (Objects.equals(oldValue, newValue)) continue;
                    LOG.log(Level.WARNING, "For card {0} header service={1} but CCS={2}", new Object[]{card.getKey(), newValue, oldValue});
                    continue;
                }
                LOG.log(Level.WARNING, "For card {0} header service={1} but CCS was not defined", new Object[]{keyword, newValue});
            }
            FitsCheckSum.updateCheckSum((Header)header, (long)deltaCheckSum);
            header.rewrite();
        }
    }

    private boolean isString(String string) {
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return false;
        }
        try {
            Double.valueOf(string);
            return false;
        }
        catch (NumberFormatException x) {
            return true;
        }
    }

    void headerDataArrived(String imageName, List<ImageHeaderData.Header> headers) {
        CompletableFuture<List<ImageHeaderData.Header>> futureHeaderData = this.getHeaderDataFutureForImage(imageName);
        futureHeaderData.complete(headers);
    }

    private CompletableFuture<List<ImageHeaderData.Header>> getHeaderDataFutureForImage(String imageName) {
        return this.futureHeaderDataForImage.computeIfAbsent(imageName, s -> new CompletableFuture<Object>().completeOnTimeout(null, Integer.getInteger("org.lsst.ccs.subsystem.imagehandling.headerTimeoutSeconds", 15).intValue(), TimeUnit.SECONDS));
    }

    void setHeaderServiceEnabled(boolean enabled) {
        this.isHeaderServiceEnabled.set(enabled);
    }

    CompletableFuture<File> handleAdditionalFile(AdditionalFile additionalFile) {
        if (!this.config.getAdditionalFileCommands().isEmpty()) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("FileName", additionalFile.getFileName());
            props.put("FileType", additionalFile.getFileType());
            ImageName obsId = additionalFile.getObsId();
            props.put("ImageName", obsId.toString());
            props.put("ImageDate", obsId.getDateString());
            props.put("ImageNumber", obsId.getNumberString());
            props.put("ImageController", obsId.getController().getCode());
            props.put("ImageSource", obsId.getSource().getCode());
            props.put("SEQNO", obsId.getNumberString());
            props.put("DATE", obsId.getDateString());
            props.put("CONTROLLER", obsId.getController().getCode());
            props.put("SOURCE", obsId.getSource().getCode());
            props.put("MODE", "OTHER");
            File file = this.config.getAdditionalFileName(additionalFile, props);
            try {
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                    additionalFile.writeFile(out);
                }
                Map<String, String> env = props.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(), e -> (String)e.getValue()));
                return this.commandExecutor.executeAdditional(file, env);
            }
            catch (IOException x) {
                LOG.log(Level.SEVERE, "Error handling additional file: " + additionalFile.getFileName(), x);
                return CompletableFuture.failedFuture(x);
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

