/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public class DemoLocker
extends Subsystem
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger((String)DemoLocker.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private AgentMessagingLayer aml;
    private ConcurrentMessagingUtils cmu;
    private String demoName = "demo-subsystem";

    public DemoLocker() {
        super("demo-locker", AgentInfo.AgentType.WORKER);
    }

    public void postStart() {
        this.aml = this.agent.getMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.aml);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void lockDemo() throws Exception {
        try {
            try {
                this.agentLockService.lockAgent(this.demoName);
            }
            catch (Exception e) {
                this.agentLockService.attachLock(this.demoName);
            }
            LOG.log(Level.INFO, "Locking agent {0}", (Object)this.demoName);
            this.agentLockService.setLevelForAgent(this.demoName, 99);
        }
        catch (IOException | UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new ExecutionException("Failed to lock subsystem " + this.demoName, x);
        }
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void actOnDemo() throws Exception {
        try {
            this.cmu.sendSynchronousCommand(new CommandRequest(this.demoName, "switchToNormalMode"));
        }
        catch (Exception x) {
            throw x instanceof ExecutionException ? (ExecutionException)x : new ExecutionException(x);
        }
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void unlockDemo() throws Exception {
        try {
            this.agentLockService.unlockAgent(this.demoName);
            LOG.log(Level.INFO, "Unlocking agent {0}", (Object)this.demoName);
        }
        catch (IOException | UnauthorizedLockException x) {
            throw new ExecutionException("Failed to unlock subsystem " + this.demoName, x);
        }
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void loop(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            try {
                System.out.println("loop " + i);
                while (true) {
                    try {
                        this.lockDemo();
                    }
                    catch (Exception e) {
                        System.out.println("lock error " + e);
                        continue;
                    }
                    break;
                }
                System.out.println("lock " + i);
                AgentLock lock = this.agentLockService.getLockForAgent(this.demoName);
                if (lock == null) {
                    System.out.println("oups no lock");
                } else {
                    System.out.println("lock " + lock.getToken());
                }
                System.out.println("act " + i);
                try {
                    this.actOnDemo();
                }
                catch (Exception e) {
                    System.out.println("act error " + e);
                }
                System.out.println("unlock " + i);
                this.unlockDemo();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }
}

