/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ShutterSimulation
implements ShutterInterface {
    private final CCS ccs;
    private final State shutterState;
    private final MCMConfig config;
    private ScheduledFuture<?> notReadyFuture;
    private boolean imageSequence = false;
    static final Duration READY_TIME = Duration.ofMillis(4000L);
    static final Duration READY_TIME_FOR_SEVERAL_IMAGES = Duration.ofMillis(10000L);

    ShutterSimulation(CCS ccs, State shutterState, MCMConfig config) {
        this.ccs = ccs;
        this.shutterState = shutterState;
        this.config = config;
        if (config.getShutterPrepTime() > 0.0) {
            shutterState.addStateChangeListener((when, state, oldState) -> {
                if (state == Shutter.ShutterState.CLOSED) {
                    this.scheduleNotReady();
                } else {
                    this.cancelNotReady();
                }
            });
        }
    }

    @Override
    public void start(String configName) throws ExecutionException {
    }

    @Override
    public void expose(Duration exposureTime) throws ExecutionException {
        this.shutterState.checkState(new Enum[]{Shutter.ShutterState.CLOSED});
        this.shutterState.setState(Shutter.ShutterState.OPENING);
        Duration time = Shutter.MOVE_TIME;
        this.ccs.schedule(time, () -> this.shutterState.setState(Shutter.ShutterState.OPEN));
        time = time.plus(exposureTime);
        this.ccs.schedule(time, () -> this.shutterState.setState(Shutter.ShutterState.CLOSING));
        time = time.plus(Shutter.MOVE_TIME);
        this.ccs.schedule(time, () -> this.shutterState.setState(Shutter.ShutterState.CLOSED));
    }

    @Override
    public void open() throws ExecutionException {
        this.shutterState.setState(Shutter.ShutterState.OPENING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(Shutter.ShutterState.OPEN));
    }

    @Override
    public void close() throws ExecutionException {
        this.shutterState.setState(Shutter.ShutterState.CLOSING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(Shutter.ShutterState.CLOSED));
    }

    @Override
    public void prepare() {
        if (this.config.getShutterPrepTime() > 0.0) {
            this.cancelNotReady();
            this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<Shutter.ShutterReadinessState>(Shutter.ShutterReadinessState.GETTING_READY));
            this.ccs.schedule(Duration.ofMillis((long)(this.config.getShutterPrepTime() * 1000.0)), () -> {
                this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<Shutter.ShutterReadinessState>(Shutter.ShutterReadinessState.READY));
                this.scheduleNotReady();
            });
        }
    }

    private void scheduleNotReady() {
        Duration ready_time = this.imageSequence ? READY_TIME_FOR_SEVERAL_IMAGES : READY_TIME;
        this.notReadyFuture = this.ccs.schedule(ready_time, () -> this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<Shutter.ShutterReadinessState>(Shutter.ShutterReadinessState.NOT_READY)));
    }

    private void cancelNotReady() {
        if (this.notReadyFuture != null) {
            this.notReadyFuture.cancel(false);
        }
    }

    @Override
    public void setImageSequence(boolean imageSequence) {
        this.imageSequence = imageSequence;
    }
}

