/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;

public class VacMaq20Device
extends Maq20Device
implements SwitchDevice {
    public static final int SW_INST_FTPP_VALVE = 0;
    public static final int SW_INST_FTH_VALVE = 1;
    public static final int SW_INST_L3H_VALVE = 2;
    public static final int SW_INST_L3LF_VALVE = 3;
    public static final int SW_INST_FLINE_VALVE = 4;
    public static final int SW_CRYO_FLINE_VALVE = 5;
    public static final int SW_HX_FLINE_VALVE = 6;
    public static final int NUM_SWITCHES = 7;
    public static final int CRYO_FLINE_VALVE_OPEN = 0;
    public static final int CRYO_FLINE_VALVE_CLOSED = 1;
    public static final int HX_FLINE_VALVE_OPEN = 3;
    public static final int HX_FLINE_VALVE_CLOSED = 4;
    public static final int RELAY_MODID = 0;
    public static final int VALVE_POSITIONS_MODID = 1;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected List<Maq20DiscControl> maqCtrlDiscList = new ArrayList<Maq20DiscControl>();
    protected Maq20DiscControl maqRly = null;
    protected Maq20DiscControl maqValves = null;

    protected void initDevice() {
        super.initDevice();
        for (Maq20DiscControl maq : this.maqCtrlDiscList) {
            if (maq.getModIndex() == 0) {
                this.maqRly = maq;
                continue;
            }
            if (maq.getModIndex() != 1) continue;
            this.maqValves = maq;
        }
        if (this.maqRly == null) {
            throw new RuntimeException(this.path + ": Child Maq20DiscControl relay module node has not been defined");
        }
        if (this.maqValves == null) {
            throw new RuntimeException(this.path + ": Child Maq20Device valve limit switch module node has not been defined");
        }
    }

    @Override
    public int getSwitchDevice() {
        return 9;
    }

    @Override
    public void setSwitch(int sw, boolean on) throws DriverException {
        if (sw >= 256) {
            throw new RuntimeException(this.path + ": ERROR! tried to set the state of a valve limit switch.");
        }
        this.maqRly.setLineOn(sw, on);
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.maqRly.isLineOn(sw);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the limit switch state", level=0)
    public Boolean isLimitSwitchOn(int sw) {
        int isw = sw & 7;
        System.out.println("Querying valve state for isw = " + isw);
        return this.maqValves.isInputOn(isw);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the cryo foreline limit switch state as a string", level=0)
    public String getCryoLimitSwitchStateString() {
        return this.getCryoLimitSwitchState().name();
    }

    public DeviceState getCryoLimitSwitchState() {
        Integer openValue = this.maqValves.isInputOn(0) != false ? 1 : 0;
        Integer shutValue = this.maqValves.isInputOn(1) != false ? 1 : 0;
        if (openValue == null || shutValue == null) {
            return DeviceState.OFFLINE;
        }
        return openValue == 1 ? (shutValue == 0 ? DeviceState.OPEN : DeviceState.ERROR) : (shutValue == 1 ? DeviceState.SHUT : DeviceState.TRANSIT);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hx foreline limit switch state as a string", level=0)
    public String getHxLimitSwitchStateString() {
        return this.getHxLimitSwitchState().name();
    }

    public DeviceState getHxLimitSwitchState() {
        Integer openValue = this.maqValves.isInputOn(3) != false ? 1 : 0;
        Integer shutValue = this.maqValves.isInputOn(4) != false ? 1 : 0;
        if (openValue == null || shutValue == null) {
            return DeviceState.OFFLINE;
        }
        return openValue == 1 ? (shutValue == 0 ? DeviceState.OPEN : DeviceState.ERROR) : (shutValue == 1 ? DeviceState.SHUT : DeviceState.TRANSIT);
    }
}

