/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.lsst.ccs.bus.data.Measurement;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.config.HasConfigurationParameterDescription;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Channel
implements HasLifecycle,
ConfigurationBulkChangeHandler,
HasConfigurationParameterDescription {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_TEMP = 0;
    public static final int TYPE_VOLTS = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_SWITCH = 3;
    public static final int TYPE_SUM = 4;
    public static final int TYPE_DIFF = 5;
    public static final int TYPE_PROD = 6;
    public static final int TYPE_QUOT = 7;
    private static final int LIMIT_CHECK_NONE = 0;
    private static final int LIMIT_CHECK_FLAG = 1;
    private static final int LIMIT_CHECK_ALARM = 2;
    private final String DEFAULT_FORMAT = "%.2f";
    private final double MAX_HYST_FRAC = 0.75;
    private Band band = Band.UNKNOWN;
    private Band newBand;
    private static final Map<String, Integer> checkMap = new HashMap<String, Integer>();
    protected String description = "";
    protected String units = "";
    protected double hysteresis = 0.05;
    protected String devcName;
    protected int hwChan = 0;
    protected String type = "";
    protected String subtype = "";
    protected double offset = 0.0;
    protected double scale = 1.0;
    protected String checkLo = "FLAG";
    protected String alarmLo;
    protected String checkHi = "FLAG";
    protected String alarmHi;
    protected int pageId = 0;
    protected String format = "%.2f";
    protected boolean doNotTrend = false;
    protected boolean doNotPublish = false;
    @ConfigurationParameter(name="limitLo", category="Limits")
    protected volatile double limitLo = 0.0;
    @ConfigurationParameter(name="limitHi", category="Limits")
    protected volatile double limitHi = 0.0;
    @ConfigurationParameter(name="warnLo", category="Limits")
    protected volatile double warnLo = 0.0;
    @ConfigurationParameter(name="warnHi", category="Limits")
    protected volatile double warnHi = 0.0;
    @LookupName
    private String name;
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Device devc;
    protected int typeI;
    private int subtypeI;
    private int checkLoI;
    protected Alarm alarmLoA;
    private int checkHiI;
    protected Alarm alarmHiA;
    private int id;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor mon;
    private volatile double value = Double.NaN;
    private volatile CCSTimeStamp ccsTimeStamp;
    private volatile Measurement lastMeasurement;
    private volatile DataProviderState state = DataProviderState.OFF_LINE;
    private volatile boolean noWarnBandHi;
    private volatile boolean noWarnBandLo;
    private volatile double hyst_limitHi;
    private volatile double hyst_warnHi;
    private volatile double hyst_warnLo;
    private volatile double hyst_limitLo;
    private volatile double absHyst;

    @Override
    public void init() {
        String origFmt;
        this.id = this.mon.getChannelId(this);
        this.typeI = -1;
        this.subtypeI = -1;
        boolean skipDeviceCheck = this instanceof DerivedChannel;
        if (!skipDeviceCheck && this.devcName == null && this.devc == null) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "device name", "Initialization failed.");
        }
        if (this.devc == null && this.devcName != null) {
            this.devc = this.mon.getDevice(this.devcName);
        }
        if (!skipDeviceCheck && this.devc == null) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "device name", "Invalid value: " + this.devcName);
        }
        origFmt = (origFmt = this.format) == null || origFmt.isEmpty() ? "%.2f" : (origFmt.charAt(0) != '%' ? "%" + origFmt : origFmt);
        try {
            String.format(origFmt, 0.0);
        }
        catch (IllegalFormatException e) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "display format", "Invalid value: " + origFmt);
        }
        this.format = origFmt.trim();
        Integer iCheck = checkMap.get(this.checkLo.toUpperCase());
        if (iCheck == null) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "low check option", "Invalid value: " + this.checkLo);
        }
        this.checkLoI = iCheck;
        iCheck = checkMap.get(this.checkHi.toUpperCase());
        if (iCheck == null) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "high check option", "Invalid value: " + this.checkHi);
        }
        this.checkHiI = iCheck;
        if (this.alarmLo != null) {
            this.alarmLoA = this.mon.getAlarm(this.alarmLo);
        }
        if (this.alarmLoA == null && (this.checkLoI == 2 || this.alarmLo != null)) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "low alarm name", "Invalid value: " + this.alarmLo);
        }
        if (this.alarmHi != null) {
            this.alarmHiA = this.mon.getAlarm(this.alarmHi);
        }
        if (this.alarmHiA == null && (this.checkHiI == 2 || this.alarmHi != null)) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "high alarm name", "Invalid value: " + this.alarmHi);
        }
        if (this.hysteresis < 0.0 || this.hysteresis > 1.0) {
            MonitorLogUtils.reportConfigError(this.mon.subsys.getLogger(), this.name, "hysteresis fraction", "Invalid value: " + this.hysteresis);
        }
        try {
            if (!skipDeviceCheck) {
                this.devc.addChannel(this);
                int[] types = this.devc.checkChannel(this);
                this.typeI = types[0];
                this.subtypeI = types[1];
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Initialization failed for channel " + this.name, e);
        }
    }

    public void validateBulkChange(Map<String, Object> params) {
        Double limitLoParam = (Double)params.get("limitLo");
        Double limitHiParam = (Double)params.get("limitHi");
        Double warnLoParam = (Double)params.get("warnLo");
        Double warnHiParam = (Double)params.get("warnHi");
        boolean testParam = true;
        if (!this.checkHi.equalsIgnoreCase("NONE")) {
            boolean bl = testParam = testParam && limitHiParam >= warnHiParam;
        }
        if (!this.checkLo.equalsIgnoreCase("NONE")) {
            boolean bl = testParam = testParam && warnLoParam >= limitLoParam;
            if (!this.checkHi.equalsIgnoreCase("NONE")) {
                testParam = testParam && warnHiParam > warnLoParam;
            }
        }
        boolean bl = testParam = testParam || Objects.equals(limitHiParam, warnHiParam) && Objects.equals(warnHiParam, warnLoParam) && Objects.equals(warnLoParam, limitLoParam);
        if (!testParam) {
            String msg = this.checkHi.equalsIgnoreCase("NONE") ? "parameters must satisfy warnLo >= limitLo" : (this.checkLo.equalsIgnoreCase("NONE") ? "parameters must satisfy limitHi >= warnHi" : "parameters do not satisfy limitHi >= warnHi > warnLo >= limitLo, (or all four parameters equal)");
            throw new RuntimeException("Channel " + this.name + ":  " + msg);
        }
    }

    public void setParameterBulk(Map<String, Object> params) {
        Set<String> keys = params.keySet();
        if (keys.contains("limitHi")) {
            this.limitHi = (Double)params.get("limitHi");
        }
        if (keys.contains("limitLo")) {
            this.limitLo = (Double)params.get("limitLo");
        }
        if (keys.contains("warnHi")) {
            this.warnHi = (Double)params.get("warnHi");
        }
        if (keys.contains("warnLo")) {
            this.warnLo = (Double)params.get("warnLo");
        }
        boolean noCheckHi = this.checkHi.equalsIgnoreCase("NONE");
        boolean noCheckLo = this.checkLo.equalsIgnoreCase("NONE");
        this.noWarnBandHi = this.warnHi >= this.limitHi;
        boolean bl = this.noWarnBandLo = this.warnLo <= this.limitLo;
        if (noCheckLo && noCheckHi) {
            return;
        }
        this.absHyst = this.hysteresis * Math.max(this.limitHi - this.limitLo, 0.0);
        if (noCheckLo && this.limitLo == 0.0 || noCheckHi && this.limitHi == 0.0) {
            this.absHyst = 0.0;
        }
        if (!noCheckHi) {
            if (!this.noWarnBandHi) {
                this.hyst_limitHi = Math.min(this.absHyst, 0.75 * (this.limitHi - this.warnHi));
                this.hyst_warnHi = noCheckLo ? this.absHyst : Math.min(this.absHyst, 0.75 * (this.warnHi - this.warnLo));
            } else {
                this.hyst_limitHi = !noCheckLo ? Math.min(this.absHyst, 0.75 * (this.limitHi - this.warnLo)) : this.absHyst;
            }
        }
        if (!noCheckLo) {
            if (!this.noWarnBandLo) {
                this.hyst_limitLo = Math.min(this.absHyst, 0.75 * (this.warnLo - this.limitLo));
                this.hyst_warnLo = noCheckHi ? this.absHyst : Math.min(this.absHyst, 0.75 * (this.warnHi - this.warnLo));
            } else {
                this.hyst_limitLo = !noCheckHi ? Math.min(this.absHyst, 0.75 * (this.warnHi - this.limitLo)) : this.absHyst;
            }
        }
    }

    void initSensor() {
        if (this.state == DataProviderState.DISABLED) {
            return;
        }
        this.devc.initChannel(this);
    }

    double doReadNow() {
        return this.devc.readChannel(this);
    }

    double readSensor() {
        boolean isOnline = this.devc != null ? this.devc.isOnline() : true;
        double val = this.state == DataProviderState.DISABLED || !isOnline ? Double.NaN : this.doReadNow();
        double tmpVal = val;
        this.ccsTimeStamp = CCSTimeStamp.currentTime();
        if (!Double.isNaN(val)) {
            tmpVal = this.convertRawValue(val);
            if (this.state == DataProviderState.OFF_LINE) {
                this.state = DataProviderState.NOT_VALIDATED;
                this.band = Band.UNKNOWN;
            }
        } else if (this.state != DataProviderState.OFF_LINE && this.state != DataProviderState.DISABLED) {
            this.state = DataProviderState.OFF_LINE;
            if (this.alarmHiA != null) {
                this.alarmHiA.updateState(this, DataProviderState.NOMINAL, "Channel " + this.path + " has gone OFFLINE", true);
            }
            if (this.alarmLoA != null) {
                this.alarmLoA.updateState(this, DataProviderState.NOMINAL, "Channel " + this.path + " has gone OFFLINE", true);
            }
        }
        this.value = tmpVal;
        this.lastMeasurement = new Measurement(this.value, this.ccsTimeStamp);
        return this.value;
    }

    public double convertRawValue(double rawValue) {
        return this.offset + this.scale * rawValue;
    }

    void checkLimits() {
        if (this.state == DataProviderState.DISABLED || this.state == DataProviderState.OFF_LINE) {
            return;
        }
        this.newBand = this.findBand(this.value);
        boolean okayToSetState = true;
        if (this.newBand == this.band) {
            if (this.state == DataProviderState.NOMINAL && this.hasHysteresis()) {
                return;
            }
        } else {
            switch (this.band) {
                case ALARM_LO: {
                    if (this.newBand != (this.noWarnBandLo ? Band.NOMINAL : Band.WARNING_LO) || !(this.value < this.limitLo + this.hyst_limitLo)) break;
                    okayToSetState = false;
                    break;
                }
                case WARNING_LO: {
                    if (this.newBand != Band.NOMINAL || !(this.value < this.warnLo + this.hyst_warnLo)) break;
                    okayToSetState = false;
                    break;
                }
                case WARNING_HI: {
                    if (this.newBand != Band.NOMINAL || !(this.value > this.warnHi - this.hyst_warnHi)) break;
                    okayToSetState = false;
                    break;
                }
                case ALARM_HI: {
                    if (this.newBand != (this.noWarnBandHi ? Band.NOMINAL : Band.WARNING_HI) || !(this.value > this.limitHi - this.hyst_limitHi)) break;
                    okayToSetState = false;
                    break;
                }
            }
        }
        if (okayToSetState) {
            this.band = this.newBand;
        }
        String hystMsg = "";
        if (this.hasHysteresis() && this.band != Band.NOMINAL) {
            hystMsg = " Due to hysteresis, reducing severity requires value ";
            switch (this.band) {
                case ALARM_LO: {
                    hystMsg = hystMsg + String.format("above %.4G", this.limitLo + this.hyst_limitLo);
                    break;
                }
                case WARNING_LO: {
                    hystMsg = hystMsg + String.format("above %.4G", this.warnLo + this.hyst_warnLo);
                    break;
                }
                case WARNING_HI: {
                    hystMsg = hystMsg + String.format("below %.4G", this.warnHi - this.hyst_warnHi);
                    break;
                }
                case ALARM_HI: {
                    hystMsg = hystMsg + String.format("below %.4G", this.limitHi - this.hyst_limitHi);
                    break;
                }
            }
        }
        DataProviderState tempState = DataProviderState.NOMINAL;
        DataProviderState lostate = DataProviderState.NOMINAL;
        DataProviderState histate = DataProviderState.NOMINAL;
        String loCause = null;
        String hiCause = null;
        String overallCause = null;
        String svalue = String.format("%.4G", this.value);
        if (this.band == Band.ALARM_LO) {
            lostate = DataProviderState.ALARM;
        } else if (this.band == Band.WARNING_LO) {
            lostate = DataProviderState.WARNING;
        }
        switch (lostate) {
            case WARNING: {
                loCause = "WARNING: Channel " + this.getPath() + " value " + svalue + " in low warning band (" + this.limitLo + "," + this.warnLo + ")";
                break;
            }
            case ALARM: {
                loCause = "ALARM: Channel " + this.getPath() + " value " + svalue + " below low limit " + this.limitLo;
                break;
            }
            case NOMINAL: {
                loCause = "NOMINAL: Channel " + this.getPath() + " value " + svalue + " above warning limit " + this.warnLo;
                break;
            }
            default: {
                throw new RuntimeException("Illegal state " + lostate);
            }
        }
        if (lostate.ordinal() >= tempState.ordinal()) {
            tempState = lostate;
            overallCause = loCause;
        }
        if (this.band == Band.ALARM_HI) {
            histate = DataProviderState.ALARM;
        } else if (this.band == Band.WARNING_HI) {
            histate = DataProviderState.WARNING;
        }
        switch (histate) {
            case WARNING: {
                hiCause = "WARNING: Channel " + this.getPath() + " value " + svalue + " in high warning band (" + this.warnHi + "," + this.limitHi + ")";
                break;
            }
            case ALARM: {
                hiCause = "ALARM: Channel " + this.getPath() + " value " + svalue + " above high limit " + this.limitHi;
                break;
            }
            case NOMINAL: {
                hiCause = "NOMINAL: Channel " + this.getPath() + " value " + svalue + " below warning high " + this.warnHi;
                break;
            }
            default: {
                throw new RuntimeException("Illegal state " + histate);
            }
        }
        if (histate.ordinal() >= tempState.ordinal()) {
            tempState = histate;
            overallCause = hiCause;
        }
        if (this.alarmLoA == this.alarmHiA) {
            if (this.checkLoI == 2 || this.checkHiI == 2) {
                if (tempState == DataProviderState.NOMINAL) {
                    overallCause = "NOMINAL: Channel " + this.getPath() + " value " + svalue + " in nominal range (" + this.warnLo + "," + this.warnHi + ")";
                }
                this.alarmLoA.updateState(this, tempState, overallCause + hystMsg, this.hasHysteresis());
            }
        } else {
            if (this.checkLoI == 2) {
                this.alarmLoA.updateState(this, lostate, loCause + hystMsg, this.hasHysteresis());
            }
            if (this.checkHiI == 2) {
                this.alarmHiA.updateState(this, histate, hiCause + hystMsg, this.hasHysteresis());
            }
        }
        if (okayToSetState) {
            this.state = tempState;
        }
    }

    private Band findBand(double val) {
        if (Double.isNaN(val)) {
            return Band.UNKNOWN;
        }
        Band band = Band.NOMINAL;
        if (this.checkLoI != 0) {
            if (val < this.limitLo) {
                band = Band.ALARM_LO;
            } else if (!this.noWarnBandLo && val < this.warnLo) {
                band = Band.WARNING_LO;
            }
        }
        if (this.checkHiI != 0) {
            if (val > this.limitHi) {
                band = Band.ALARM_HI;
            } else if (!this.noWarnBandHi && val > this.warnHi) {
                band = Band.WARNING_HI;
            }
        }
        return band;
    }

    public final Device getDevice() {
        if (this.devc == null && this.devcName != null) {
            this.devc = this.mon.getDevice(this.devcName);
        }
        return this.devc;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String getUnits() {
        return this.units;
    }

    public int getPageId() {
        return this.pageId;
    }

    public double getLimitLo() {
        return this.limitLo;
    }

    public String getAlarmNameLo() {
        return this.checkLoI == 2 ? this.alarmLo : (this.checkLoI == 1 ? "" : null);
    }

    public double getLimitHi() {
        return this.limitHi;
    }

    public double getWarnLo() {
        return this.warnLo;
    }

    public double getWarnHi() {
        return this.warnHi;
    }

    public String getAlarmNameHi() {
        return this.checkHiI == 2 ? this.alarmHi : (this.checkHiI == 1 ? "" : null);
    }

    public int getId() {
        return this.id;
    }

    public int getHwChan() {
        return this.hwChan;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public double getValue() {
        return this.value;
    }

    public double readValue() {
        this.readSensor();
        return this.getValue();
    }

    CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    DataProviderState getState() {
        return this.state;
    }

    void setValid(boolean isValid) {
        if (!isValid) {
            this.state = DataProviderState.DISABLED;
        } else if (this.state == DataProviderState.DISABLED) {
            this.state = DataProviderState.NOT_VALIDATED;
            this.band = Band.UNKNOWN;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        String group = null;
        Device d = this.getDevice();
        if (d != null) {
            group = d.getGroupForChannel(this);
        } else if (!(this instanceof DerivedChannel)) {
            this.mon.subsys.getLogger().warn((Object)("Channel " + this.path + " has no devc defined"));
        }
        return group != null ? group : "";
    }

    public int getType() {
        return this.typeI;
    }

    public String getTypeStr() {
        return this.type;
    }

    public int getSubType() {
        return this.subtypeI;
    }

    public String getSubTypeStr() {
        return this.subtype;
    }

    public Measurement getLastMeasurement() {
        return new Measurement(this.lastMeasurement);
    }

    public boolean hasHysteresis() {
        return this.absHyst > 0.0;
    }

    public double getHysteresisLimitLo() {
        return this.getLimitLo() + this.hyst_limitLo;
    }

    public double getHysteresisLimitHi() {
        return this.getLimitHi() - this.hyst_limitHi;
    }

    public double getHysteresisWarnLo() {
        return this.getWarnLo() + this.hyst_warnLo;
    }

    public double getHysteresisWarnHi() {
        return this.getWarnHi() - this.hyst_warnHi;
    }

    public ConfigurationParameterDescription getConfigurationParameterDescription(String parName) {
        ConfigurationParameterDescription cpd = null;
        if (parName.equals("limitLo") || parName.equals("warnLo") || parName.equals("limitHi") || parName.equals("warnHi")) {
            String tmpDescription;
            boolean checkLowerBand = !this.checkLo.equalsIgnoreCase("NONE");
            boolean checkUpperBand = !this.checkHi.equalsIgnoreCase("NONE");
            String tmpUnits = this.getUnits();
            if (tmpUnits == null || tmpUnits.isEmpty()) {
                tmpUnits = "unitless";
            }
            if ((tmpDescription = this.getDescription()) == null) {
                tmpDescription = "";
            }
            cpd = new ConfigurationParameterDescription();
            cpd.withUnits(tmpUnits);
            switch (parName) {
                case "limitLo": {
                    cpd.withDescription((tmpDescription + " low alarm level").trim());
                    cpd.withIsEnabled(checkLowerBand);
                    break;
                }
                case "limitHi": {
                    cpd.withDescription((tmpDescription + " high alarm level").trim());
                    cpd.withIsEnabled(checkUpperBand);
                    break;
                }
                case "warnLo": {
                    cpd.withDescription((tmpDescription + " low warning level").trim());
                    cpd.withIsEnabled(checkLowerBand);
                    break;
                }
                case "warnHi": {
                    cpd.withDescription((tmpDescription + " high warning level").trim());
                    cpd.withIsEnabled(checkUpperBand);
                }
            }
        }
        return cpd;
    }

    static {
        checkMap.put("NONE", 0);
        checkMap.put("FLAG", 1);
        checkMap.put("ALARM", 2);
    }

    private static enum Band {
        UNKNOWN,
        ALARM_LO,
        WARNING_LO,
        NOMINAL,
        WARNING_HI,
        ALARM_HI;

    }
}

