/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.StoreSimulation;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentExecutionService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.focalplane.CCDHardwareIdConfiguration;
import org.lsst.ccs.subsystem.focalplane.ConfigListener;
import org.lsst.ccs.subsystem.focalplane.FirmwareVersion;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneCommands;
import org.lsst.ccs.subsystem.focalplane.HardwareIdConfiguration;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinatorService;
import org.lsst.ccs.subsystem.focalplane.ImageMessageHandling;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.PlaylistCommands;
import org.lsst.ccs.subsystem.focalplane.ScriptingCommands;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.focalplane.states.SequencerState;
import org.lsst.ccs.subsystem.power.states.RebHvBiasState;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.states.RebDeviceState;
import org.lsst.ccs.subsystem.rafts.states.RebValidationState;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FocalPlaneSubsystem
extends Subsystem
implements HasLifecycle,
HasDataProviderInfos {
    private static final Logger LOG = Logger.getLogger(FocalPlaneSubsystem.class.getName());
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, REBDevice> rebDevices = new LinkedHashMap<String, REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private SequencerConfig sequencerConfig;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AlertService agentAlertService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageCoordinatorService imageCoordinatorService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentExecutionService executionService;
    private Sequencers sequencers;
    private final FocalPlane focalPlaneGeometry;
    private ImageMessageHandling imageMessageHandling;
    private ComponentLookup lookupService;
    private final boolean isSimulationMode;
    private StatusMessageListener rebPowerHvBiasStatusMessageListener;

    public FocalPlaneSubsystem(FocalPlane geometry) {
        super("fp", AgentInfo.AgentType.WORKER);
        this.focalPlaneGeometry = geometry;
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        this.isSimulationMode = "simulation".equalsIgnoreCase(props.getProperty("org.lsst.ccs.run.mode", "normal"));
        if (this.isSimulationMode) {
            LOG.log(Level.INFO, "Running in simulation mode");
        }
    }

    public void build() {
        this.agentPropertiesService.setAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, HasFocalPlaneData.generatePropertyValue(FocalPlaneDataGroup.class));
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.FOCAL_PLANE.name());
        this.agentPropertiesService.setAgentProperty(RebPowerAction.class.getCanonicalName(), "uses");
        this.lookupService = this.getComponentLookup();
        ComponentNode thisComponent = this.lookupService.getComponentNodeForObject((Object)this);
        this.imageMessageHandling = new ImageMessageHandling();
        ComponentNode imageMessageHandlingNode = new ComponentNode("imageMessageHandling", (Object)this.imageMessageHandling);
        this.lookupService.addComponentNodeToLookup(thisComponent, imageMessageHandlingNode);
        for (Raft r : this.focalPlaneGeometry.getChildrenList()) {
            ComponentNode raftNode = new ComponentNode(r.getName(), (Object)new HardwareIdConfiguration());
            this.lookupService.addComponentNodeToLookup(thisComponent, raftNode);
            for (Reb reb : r.getRebs()) {
                String rebName = r.getName() + "/" + reb.getName();
                ComponentNode rebHardwareNode = new ComponentNode(reb.getName() + "_hardware", (Object)new HardwareIdConfiguration());
                this.lookupService.addComponentNodeToLookup(raftNode, rebHardwareNode);
                ComponentNode rebComponent = this.lookupService.getNodeByPath(rebName);
                for (CCD ccd : reb.getCCDs()) {
                    String sensorName = ccd.getName();
                    ComponentNode sensorNode = new ComponentNode(sensorName, (Object)new CCDHardwareIdConfiguration());
                    this.lookupService.addComponentNodeToLookup(rebComponent, sensorNode);
                }
            }
        }
        this.agentStateService.registerState(FocalPlaneState.class, "The state of the Focal Plane", (Object)this);
        this.agentStateService.registerState(SequencerState.class, "The state of the Sequencer", (Object)this);
    }

    public void init() {
        ClientFactorySimulation clientFactory = this.isSimulationMode || this.sequencerConfig.hasEmulatedDAQ() ? new ClientFactorySimulation(true) : new ClientFactory();
        for (REBDevice rebDevice : this.rebDevices.values()) {
            rebDevice.setClientFactory((ClientFactory)clientFactory);
        }
        if (this.isSimulationMode) {
            GlobalClient gbl = new GlobalClient();
            gbl.setClientFactory((ClientFactory)clientFactory);
            try {
                gbl.open(this.sequencerConfig.getPartition());
                StoreSimulation.instance().addTriggerListener((opcode, meta, registerLists) -> {
                    try {
                        if (meta == null) {
                            gbl.startSequencer(opcode);
                        } else {
                            for (Map.Entry entry : registerLists.entrySet()) {
                                gbl.setRegisterlist(((Location.LocationType)entry.getKey()).getCCDCount(), (int[])entry.getValue());
                            }
                            int[] ids = new LocationSet(meta.getLocations()).asIntArray();
                            gbl.acquireImage(meta.getName(), meta.getCreationFolderName(), opcode, meta.getAnnotation(), ids);
                        }
                    }
                    catch (REBException x) {
                        LOG.log(Level.SEVERE, "Error simulating trigger", x);
                    }
                });
                StoreSimulation.instance().setRegisterAccess(new StoreSimulation.RegisterAccess(){

                    public int readRegister(Location l, int address) {
                        try {
                            REBDevice rebDevice = this.getRebDeviceAtLocation(l);
                            if (rebDevice != null) {
                                return rebDevice.getRegister(address, 1).getValues()[0];
                            }
                            return 0;
                        }
                        catch (RaftException ex) {
                            return 0;
                        }
                    }

                    public void writeRegister(Location l, int address, int value) {
                        try {
                            this.getRebDeviceAtLocation(l).setRegister(address, new int[]{value});
                        }
                        catch (RaftException ex) {
                            throw new RuntimeException("Unable to write register", ex);
                        }
                    }

                    private REBDevice getRebDeviceAtLocation(Location l) {
                        return (REBDevice)FocalPlaneSubsystem.this.rebDevices.get(l.toString());
                    }
                });
            }
            catch (REBException x) {
                throw new RuntimeException("Failed to initialize simulation", x);
            }
        }
    }

    public void postInit() {
        this.sequencers = new Sequencers(this, this.sequencerConfig, (ExecutorService)this.executionService);
        this.agentStateService.updateAgentState(new Enum[]{FocalPlaneState.NEEDS_CLEAR, SequencerState.IDLE});
        this.dataProviderDictionaryService.registerClass(ImageMetaDataEvent.class, ImageMetaDataEvent.EVENT_KEY);
        this.rebDevices.forEach((rebName, device) -> {
            Reb reb = this.focalPlaneGeometry.getReb(rebName);
            device.setRebGeometry(reb);
            this.sequencers.add(reb, device.getSequencer());
        });
        this.agentStateService.addStateChangeListener(new StateChangeListener(){

            public void stateChanged(CCSTimeStamp stateTransitionTimestamp, Object device, Enum<?> newState, Enum<?> oldState) {
                if (newState == RebValidationState.VALID) {
                    REBDevice rebDevice = (REBDevice)device;
                    String path = FocalPlaneSubsystem.this.lookupService.getNameOfComponent(device);
                    try {
                        FirmwareVersion version = new FirmwareVersion(rebDevice.getHwVersion());
                        if (version.hasLookAtMeBug()) {
                            LOG.log(Level.INFO, "Disabled LAM for firmware {0}", version);
                            try {
                                rebDevice.setRegister(23, new int[]{0});
                            }
                            catch (RaftException x) {
                                LOG.log(Level.SEVERE, "Could not disable LAM for " + rebDevice.getName(), x);
                            }
                        }
                        FocalPlaneSubsystem.this.sequencers.load(FocalPlaneSubsystem.this.focalPlaneGeometry.getReb(path), version);
                        Integer result = rebDevice.loadAspics(true);
                        LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{rebDevice.getName(), result});
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, "Exception while loading ASPICS", x);
                    }
                }
            }
        }, new Class[]{RebDeviceState.class, RebValidationState.class});
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new LSE71Commands(this, this.sequencerConfig), (Object)"");
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new ScriptingCommands(this), (Object)"");
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new PlaylistCommands(this, this.sequencerConfig), (Object)"");
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new FocalPlaneCommands(this), (Object)"");
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (AgentInfo ai : agents) {
                    if (!ai.getAgentProperty("agentCategory", "").equals(AgentCategory.POWER.name())) continue;
                    LOG.log(Level.INFO, "Publishing raised alert summary for {0}", new Object[]{ai.getName()});
                    FocalPlaneSubsystem.this.getScheduler().execute(() -> FocalPlaneSubsystem.this.agentAlertService.publishRaisedAlertSummary());
                    break;
                }
            }
        });
    }

    public void finalizeDictionary() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            FocalPlaneDataGroup dataGroup = FocalPlaneDataGroup.findFocalPlaneDataGroup((DataProviderInfo)data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    public void start() {
        this.rebPowerHvBiasStatusMessageListener = new StatusMessageListener(){
            private AtomicBoolean isFirstStatusStateChangeNotification = new AtomicBoolean(true);

            public void onStatusMessage(StatusMessage msg) {
                Map rebHvBiasStateChanges;
                StateBundle stateToProcess = null;
                if (this.isFirstStatusStateChangeNotification.getAndSet(false)) {
                    stateToProcess = msg.getState();
                } else if (msg instanceof StatusStateChangeNotification) {
                    StatusStateChangeNotification stateChange = (StatusStateChangeNotification)msg;
                    stateToProcess = stateChange.getNewState().diffState(stateChange.getOldState());
                }
                if (stateToProcess != null && !(rebHvBiasStateChanges = stateToProcess.getComponentsWithState(RebHvBiasState.class)).isEmpty()) {
                    for (Map.Entry e : rebHvBiasStateChanges.entrySet()) {
                        REBDevice reb;
                        RebHvBiasState hvBiasState = (RebHvBiasState)e.getValue();
                        if (hvBiasState == RebHvBiasState.UNKNOWN || (reb = (REBDevice)FocalPlaneSubsystem.this.rebDevices.get(e.getKey())) != null && !reb.isOnline()) continue;
                        if (reb != null) {
                            if (hvBiasState != RebHvBiasState.OFF && hvBiasState != RebHvBiasState.ON) continue;
                            try {
                                reb.disableBackBias(hvBiasState == RebHvBiasState.OFF, "Power subsystem (" + msg.getOriginAgentInfo().getName() + ") turned HVBias " + hvBiasState.name() + " for " + reb.getPath());
                            }
                            catch (RaftException re) {
                                LOG.log(Level.WARNING, "Exception when disabling reb " + reb.getPath(), re);
                            }
                            continue;
                        }
                        LOG.log(Level.WARNING, "Could not find reb {0}.", e.getKey());
                    }
                }
            }
        };
        this.getMessagingAccess().addStatusMessageListener(this.rebPowerHvBiasStatusMessageListener, m -> m.getOriginAgentInfo().getAgentProperty("agentCategory", "").equals(AgentCategory.POWER.name()));
    }

    public void shutdown() {
        this.getMessagingAccess().removeStatusMessageListener(this.rebPowerHvBiasStatusMessageListener);
    }

    public void postStart() {
        this.configService.addConfigurationListener((ConfigurationListener)new ConfigListener(this));
        this.loadSequencers();
    }

    void loadSequencers() {
        try {
            this.sequencers.load();
        }
        catch (DAQException | REBException | RaftException x) {
            throw new RuntimeException("Error configuring sequencers", x);
        }
    }

    void loadASPICS() {
        for (REBDevice device : this.rebDevices.values()) {
            if (!device.isOnline() || !device.isSerialNumValid()) continue;
            try {
                Integer result = device.loadAspics(true);
                LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{device.getFullName(), result});
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error while loading ASPICS", ex);
            }
        }
    }

    boolean isRebOnlineAndValid(Reb reb) {
        return this.stateService.isComponentInState(reb.getFullName(), (Enum)RebValidationState.VALID);
    }

    FirmwareVersion getFirmwareVersionForReb(Reb reb) {
        return new FirmwareVersion(this.rebDevices.get(reb.getFullName()).getHwVersion());
    }

    public Sequencers getSequencers() {
        return this.sequencers;
    }

    ImageNameService getImageNameService() {
        return this.imageNameService;
    }

    Map<String, REBDevice> getRebDevices() {
        return this.rebDevices;
    }

    void loadSequencerParameters() {
        this.sequencers.loadSequencerParameters();
    }

    void sendEvent(String key, Serializable event) {
        KeyValueData kvd = new KeyValueData(key, event);
        this.publishSubsystemDataOnStatusBus(kvd);
        LOG.log(Level.INFO, "Sent: {0}", event);
    }

    void setState(FocalPlaneState newState) {
        this.agentStateService.updateAgentState(new Enum[]{newState});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateIf(Enum currentState, Enum ... newStates) {
        Object object = this.agentStateService.getStateLock();
        synchronized (object) {
            if (this.agentStateService.getState(currentState.getClass()) == currentState) {
                this.agentStateService.updateAgentState(newStates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInState(Enum ... states) {
        Object object = this.agentStateService.getStateLock();
        synchronized (object) {
            for (Enum state : states) {
                if (this.agentStateService.isInState(state)) continue;
                return false;
            }
            return true;
        }
    }

    void setState(CCSTimeStamp ts, Enum ... stateChanges) {
        this.agentStateService.updateAgentState(ts, stateChanges);
    }

    ImageCoordinatorService getImageCoordinatorService() {
        return this.imageCoordinatorService;
    }

    void setHeaderKeywords(Map<String, Serializable> headersMap) {
        this.imageCoordinatorService.addMetaData(headersMap);
    }

    void setTransparentMode(Reb reb, boolean tranparentMode) {
        this.rebDevices.get(reb.getFullName()).setAllAspic("tm", tranparentMode ? 1 : 0, false);
    }

    public boolean isSimulationMode() {
        return this.isSimulationMode;
    }
}

