/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.Alerts;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class Watchdog
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(Watchdog.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @ConfigurationParameter(description="The interval between checks of the PLC  message counter.", units="s")
    private volatile Duration checkInterval;
    private int msgCount = 0;
    private final SynchronousChannel<Runnable> inChannel = new SynchronousChannel();
    private WatchState state = WatchState.DISABLED;
    private final Scheduler sched = new Scheduler("PLCWatchdog", 2);

    public Watchdog() {
        this.checkInterval = Duration.ofSeconds(10L);
    }

    public void start() {
        this.sched.scheduleWithFixedDelay(this::watchdogBody, 0L, 10L, TimeUnit.MILLISECONDS);
        this.sched.scheduleAtFixedRate(this::timerBody, 100L, this.checkInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.sched.shutdownNow();
    }

    public void enable() throws InterruptedException {
        this.inChannel.write(this::enableImpl);
    }

    public void disable() throws InterruptedException {
        this.inChannel.write(this::disableImpl);
    }

    public void countMessage() throws InterruptedException {
        this.inChannel.write(this::countImpl);
    }

    public void checkMessageCount() throws InterruptedException {
        this.inChannel.write(this::checkImpl);
    }

    private void enableImpl() {
        if (this.state == WatchState.DISABLED) {
            this.state = WatchState.ENABLED;
        }
    }

    private void disableImpl() {
        if (this.state == WatchState.ENABLED) {
            this.state = WatchState.DISABLED;
            this.msgCount = 0;
        }
    }

    private void countImpl() {
        if (this.state == WatchState.ENABLED) {
            ++this.msgCount;
        }
    }

    private void checkImpl() {
        if (this.state == WatchState.ENABLED) {
            if (this.msgCount == 0) {
                ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(Alerts.WATCHDOG, AlertState.WARNING, "No messages are coming in from the shutter.", AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
            } else {
                this.msgCount = 0;
            }
        }
    }

    private void watchdogBody() {
        try {
            Thread.currentThread().setName("Watchdog body");
            LOG.info("Starting the PLC message watchdog.");
            while (true) {
                this.inChannel.read().run();
            }
        }
        catch (InterruptedException exc) {
            LOG.info("Normal exit of the PLC message watchdog.");
            return;
        }
    }

    private void timerBody() {
        try {
            this.checkMessageCount();
        }
        catch (InterruptedException exc) {
            LOG.info("The PLC message watchdog timer was interrupted!");
        }
    }

    private static enum WatchState {
        ENABLED,
        DISABLED;

    }
}

