/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.drivers.ads.VariableHandle;

public class VarHandleTracker {
    private Set<VariableHandle> all = new HashSet<VariableHandle>();
    private Map<Integer, VariableHandle> fromNoticeHandle = new HashMap<Integer, VariableHandle>();
    private Map<String, VariableHandle> fromName = new HashMap<String, VariableHandle>();
    private Map<VariableHandle, Integer> toNoticeHandle = new HashMap<VariableHandle, Integer>();

    public void add(VariableHandle newvh) {
        if (this.all.contains(newvh)) {
            return;
        }
        this.all.add(newvh);
        this.fromName.put(newvh.getName(), newvh);
    }

    public boolean isValid(VariableHandle vh) {
        return this.all.contains(vh);
    }

    public void remove(VariableHandle vh) {
        this.all.remove(vh);
        this.fromName.remove(vh.getName());
        this.removeNotification(vh);
    }

    public void clear() {
        this.all.clear();
        this.fromName.clear();
        this.fromNoticeHandle.clear();
        this.toNoticeHandle.clear();
    }

    public VariableHandle getByName(String name) {
        return this.fromName.get(name);
    }

    public void addNotification(VariableHandle vh, int nh) {
        this.fromNoticeHandle.put(nh, vh);
        this.toNoticeHandle.put(vh, nh);
    }

    public Integer getNotification(VariableHandle vh) {
        return this.toNoticeHandle.get(vh);
    }

    public VariableHandle getByNotification(Integer nh) {
        return this.fromNoticeHandle.get(nh);
    }

    public Integer removeNotification(VariableHandle vh) {
        Integer nh = this.toNoticeHandle.remove(vh);
        if (nh != null) {
            this.fromNoticeHandle.remove(nh);
        }
        return nh;
    }
}

