/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import org.indilib.i4j.Constants;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIDevice;
import org.indilib.i4j.client.INDIProperty;
import org.indilib.i4j.client.INDIPropertyListener;
import org.indilib.i4j.client.INDISwitchElement;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.properties.INDIStandardProperty;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.DefSwitch;
import org.indilib.i4j.protocol.DefSwitchVector;
import org.indilib.i4j.protocol.DefVector;
import org.indilib.i4j.protocol.NewSwitchVector;
import org.indilib.i4j.protocol.NewVector;
import org.indilib.i4j.protocol.OneSwitch;
import org.indilib.i4j.protocol.SetVector;

public class INDISwitchProperty
extends INDIProperty<INDISwitchElement> {
    private INDIPropertyListener uiComponent;
    private Constants.SwitchRules rule;

    protected INDISwitchProperty(DefSwitchVector xml, INDIDevice device) {
        super((DefVector<?>)xml, device);
        String rul = xml.getRule();
        if (rul.compareTo("OneOfMany") == 0) {
            this.rule = Constants.SwitchRules.ONE_OF_MANY;
        } else if (rul.compareTo("AtMostOne") == 0) {
            this.rule = Constants.SwitchRules.AT_MOST_ONE;
        } else if (rul.compareTo("AnyOfMany") == 0) {
            this.rule = Constants.SwitchRules.ANY_OF_MANY;
        } else {
            throw new IllegalArgumentException("Illegal Rule for the Switch Property");
        }
        for (DefElement element : xml.getElements()) {
            String name;
            INDISwitchElement iel;
            if (!(element instanceof DefSwitch) || (iel = this.getElement(name = element.getName())) != null) continue;
            INDISwitchElement ite = new INDISwitchElement((DefSwitch)element, this);
            this.addElement(ite);
        }
        if (!this.checkCorrectValues()) {
            if (this.getSelectedCount() != 0) {
                throw new IllegalArgumentException("Illegal initial value for Switch Property");
            }
            this.setState(Constants.PropertyStates.ALERT);
        }
    }

    @Override
    protected void update(SetVector<?> el) {
        super.update(el, OneSwitch.class);
        if (!this.checkCorrectValues()) {
            this.setState(Constants.PropertyStates.ALERT);
        }
    }

    public Constants.SwitchRules getRule() {
        return this.rule;
    }

    @Override
    protected void setPermission(Constants.PropertyPermissions permission) {
        if (permission == Constants.PropertyPermissions.WO) {
            super.setPermission(Constants.PropertyPermissions.RO);
        } else {
            super.setPermission(permission);
        }
    }

    private boolean checkCorrectValues() {
        if (this.getState() == Constants.PropertyStates.OK) {
            int selectedCount = this.getSelectedCount();
            if (this.rule == Constants.SwitchRules.ONE_OF_MANY && selectedCount != 1) {
                return false;
            }
            if (this.rule == Constants.SwitchRules.AT_MOST_ONE && selectedCount > 1) {
                return false;
            }
        }
        return true;
    }

    private int getSelectedCount() {
        int selectedCount = 0;
        for (INDISwitchElement el : this) {
            if (el.getValue() != Constants.SwitchStatus.ON) continue;
            ++selectedCount;
        }
        return selectedCount;
    }

    @Override
    protected NewVector<?> getXMLPropertyChangeInit() {
        return new NewSwitchVector();
    }

    @Override
    public INDIPropertyListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIPropertyListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createSwitchPropertyView(this);
        this.addINDIPropertyListener(this.uiComponent);
        return this.uiComponent;
    }

    @Override
    public final INDISwitchElement getElement(String name) {
        return (INDISwitchElement)super.getElement(name);
    }

    @Override
    public final INDISwitchElement getElement(INDIStandardProperty name) {
        return (INDISwitchElement)super.getElement(name.name());
    }

    @Override
    public String getValuesAsString() {
        StringBuffer aux = new StringBuffer();
        int n = 0;
        for (INDISwitchElement element : this) {
            if (element.getValue() != Constants.SwitchStatus.ON) continue;
            if (n != 0) {
                aux.append(", ");
            }
            ++n;
            aux.append(element.getLabel());
        }
        if (n > 1) {
            aux.insert(0, "[");
            aux.append("]");
        }
        return aux.toString();
    }
}

