/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

class ResourceDirectory {
    private final boolean isDistributionDir;
    private final Path resourceDirectoryPath;
    private final Set<String> extensions;
    private final URI uri;

    ResourceDirectory(URI resourceDirectoryURI, boolean isDistributionDir, Set<String> extensions) {
        this.isDistributionDir = isDistributionDir;
        this.resourceDirectoryPath = Paths.get(resourceDirectoryURI);
        this.extensions = extensions;
        this.uri = resourceDirectoryURI;
    }

    boolean isDistributionDir() {
        return this.isDistributionDir;
    }

    Path getResouceDirectoryPath() {
        return this.resourceDirectoryPath;
    }

    Set<String> findMatchingResources(Pattern pattern) {
        HashSet<String> result = new HashSet<String>();
        try {
            Files.list(this.resourceDirectoryPath).filter(p -> this.supportsExtension(BootstrapResourceUtils.getResourceExtension(p.getFileName().toString()))).filter(p -> pattern.matcher(p.getFileName().toString()).matches()).forEach(p -> result.add(p.getFileName().toString()));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    boolean supportsExtension(String extension) {
        if (extension != null && !this.extensions.isEmpty()) {
            return this.extensions.contains(extension);
        }
        return true;
    }

    URI getURI() {
        return this.uri;
    }

    URI getResourceURI(String resource) {
        return this.uri.resolve(resource);
    }
}

