/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter;

import hep.aida.IAnalysisFactory;
import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud;
import hep.aida.IDataPointSet;
import hep.aida.IFitData;
import hep.aida.IFitParameterSettings;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IModelFunction;
import hep.aida.IProfile;
import hep.aida.IRangeSet;
import hep.aida.ITree;
import hep.aida.ITupleFactory;
import hep.aida.dev.IDevFitData;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ext.IExtFitter;
import hep.aida.ext.IFitMethod;
import hep.aida.ext.IOptimizer;
import hep.aida.ext.IOptimizerFactory;
import hep.aida.ext.IVariableSettings;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.fitter.FitParameterSettings;
import hep.aida.ref.fitter.FitResult;
import hep.aida.ref.fitter.fitdata.FitDataCreator;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.FunctionCatalog;
import hep.aida.ref.function.RangeSet;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class Fitter
implements IExtFitter {
    private String engineType;
    private IOptimizer optimizer = null;
    private String fitMethodType;
    private IFitMethod fitMethod = null;
    private IFunction fitFunction;
    private Hashtable fitParHash = new Hashtable();
    private boolean useGradient = true;
    private ArrayList constraintList = new ArrayList();
    private Hashtable simpleConstraintHash = new Hashtable();
    private boolean createClone = true;

    public Fitter(String fitMethodType, String engineType, String options) throws IllegalArgumentException {
        this.setFitMethod(fitMethodType);
        this.setEngine(engineType);
        Map opt = AidaUtils.parseOptions(options);
        String val = (String)opt.get("noClone");
        if (val != null && val.trim().equalsIgnoreCase("true")) {
            this.createClone = false;
        }
    }

    public void setEngine(String engineType) throws IllegalArgumentException {
        if (engineType == null || engineType.length() == 0) {
            engineType = "jminuit";
        }
        String enType = engineType.toLowerCase();
        IOptimizerFactory tmpOptimizerFactory = null;
        Lookup.Template template = new Lookup.Template(IOptimizerFactory.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        block0: for (IOptimizerFactory of : c) {
            String[] names = of.optimizerFactoryNames();
            if (names == null || names.length == 0) {
                throw new IllegalArgumentException("IOptimizerFactory with illegal names!");
            }
            for (int j = 0; j < names.length; ++j) {
                if (!enType.equals(names[j].toLowerCase())) continue;
                tmpOptimizerFactory = of;
                continue block0;
            }
        }
        if (tmpOptimizerFactory == null) {
            throw new IllegalArgumentException("Cannot create IOptimizer of type: " + engineType);
        }
        this.engineType = engineType;
        this.optimizer = tmpOptimizerFactory.create(engineType);
    }

    public String engineName() {
        return this.engineType;
    }

    public void setFitMethod(String fitMethodType) throws IllegalArgumentException {
        if (fitMethodType == null || fitMethodType.length() == 0) {
            fitMethodType = "chi2";
        }
        String fitMet = fitMethodType.toLowerCase();
        IFitMethod tmpFitMethod = null;
        Lookup.Template template = new Lookup.Template(IFitMethod.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        block0: for (IFitMethod fm : c) {
            String[] names = fm.fitMethodNames();
            if (names == null || names.length == 0) {
                throw new IllegalArgumentException("IFitMethod with illegal names!");
            }
            for (int j = 0; j < names.length; ++j) {
                if (!fitMet.equals(names[j].toLowerCase())) continue;
                tmpFitMethod = fm;
                continue block0;
            }
        }
        if (tmpFitMethod == null) {
            throw new IllegalArgumentException("Unknown IFitMethod type: " + fitMethodType);
        }
        this.fitMethodType = fitMethodType;
        this.fitMethod = tmpFitMethod;
    }

    public IOptimizer optimizer() {
        return this.optimizer;
    }

    public String fitMethodName() {
        return this.fitMethodType;
    }

    public IFitParameterSettings fitParameterSettings(String name) {
        if (this.fitParHash.containsKey(name)) {
            return (IFitParameterSettings)this.fitParHash.get(name);
        }
        FitParameterSettings fitPar = new FitParameterSettings(name);
        this.fitParHash.put(name, fitPar);
        return fitPar;
    }

    public String[] listParameterSettings() {
        int size = this.fitParHash.size();
        String[] parNames = new String[size];
        Enumeration e = this.fitParHash.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            parNames[i] = (String)e.nextElement();
            ++i;
        }
        return parNames;
    }

    public void resetParameterSettings() {
        this.fitParHash.clear();
    }

    public IFitResult fit(Function f) {
        if (f.numberOfDependents() != 1) {
            throw new IllegalArgumentException("Currently we only fit 1 dimensional functions.");
        }
        Dependent x = f.getDependent(0);
        if (!x.isConnected()) {
            throw new IllegalArgumentException("Dependent " + x.name() + " is not connected to a data set");
        }
        IFitData data = x.data();
        return this.fit(data, (IFunction)f);
    }

    public IFitResult fit(IFitData d, IFunction originalFunction) {
        return this.fit(d, originalFunction, null);
    }

    public IFitResult fit(IFitData d, IFunction originalFunction, String range) {
        return this.fit(d, originalFunction, range, null);
    }

    private void addBounds(IRangeSet rs, int index, double[] lb, double[] ub) {
        if (lb.length == 0) {
            throw new RuntimeException("No ranges are set in the FitData. Please report the problem");
        }
        for (int j = 0; j < ub.length; ++j) {
            rs.include(lb[j], ub[j]);
        }
    }

    @Override
    public IFitResult fit(IFitData d, IFunction originalFunction, String range, Object correlationObject) {
        IModelFunction f;
        String name = "";
        name = originalFunction instanceof IManagedObject ? ((IManagedObject)originalFunction).name() : originalFunction.title();
        name = name + " " + this.engineName() + " fit";
        IFunction fClone = this.cloneFunction(name, originalFunction);
        boolean setRange = false;
        if (originalFunction instanceof IFunction) {
            setRange = true;
        }
        if (fClone instanceof IModelFunction) {
            f = (IModelFunction)fClone;
        } else if (fClone instanceof IFunction) {
            f = new BaseModelFunction(name, name, fClone);
        } else {
            throw new RuntimeException("Fitter for now can only use IModelFunctions and IFunctions. Please report this problem");
        }
        if (range != null) {
            Map optionsMap = AidaUtils.parseOptions(range);
            range = (String)optionsMap.get("range");
            RangeSet usersRange = new RangeSet(range);
            IRangeSet rs = d.range(0);
            rs.excludeAll();
            this.addBounds(rs, 0, usersRange.lowerBounds(), usersRange.upperBounds());
        }
        if (setRange) {
            f.excludeNormalizationAll();
            IRangeSet d_rs = null;
            for (int i = 0; i < d.dimension(); ++i) {
                d_rs = d.range(i);
                IRangeSet f_rs = f.normalizationRange(i);
                this.addBounds(f_rs, i, d_rs.lowerBounds(), d_rs.upperBounds());
            }
        }
        this.fitMethod.clear();
        this.fitMethod.setCorrelationObject(correlationObject);
        this.loadFitDataAndFunction(d, f);
        long startFit = System.currentTimeMillis();
        this.optimizer.optimize();
        long endFit = System.currentTimeMillis();
        double fitSeconds = (double)(endFit - startFit) / 1000.0;
        String[] parNames = f.parameterNames();
        for (int i = 0; i < parNames.length; ++i) {
            f.setParameter(parNames[i], this.optimizer.result().parameters()[i]);
        }
        double[][] covMatrix = this.optimizer.result().covarianceMatrix();
        int status = this.optimizer.result().optimizationStatus();
        int dataEntries = ((FitFunction)this.fitFunction).dataEntries();
        int freePars = ((FitFunction)this.fitFunction).nFreePars();
        int nDoF = dataEntries - freePars;
        double funcVal = this.fitFunction.value(f.parameters());
        FitResult result = new FitResult(this.fitFunction.dimension(), fitSeconds);
        result.setConstraints(this.constraints());
        result.setDataDescription(d.dataDescription());
        result.setEngineName(this.engineName());
        result.setFitMethodName(this.fitMethodName());
        result.setFitStatus(status);
        result.setFittedFunction((IFunction)f);
        result.setIsValid(true);
        result.setNdf(nDoF);
        if (this.fitMethod.fitType() == 1) {
            result.setQuality(funcVal / (double)nDoF / Math.sqrt(2.0));
        } else {
            result.setQuality(funcVal / (double)nDoF);
        }
        int countI = 0;
        for (int i = 0; i < parNames.length; ++i) {
            result.setFitParameterSettings(parNames[i], this.fitParameterSettings(parNames[i]));
            int countJ = 0;
            for (int j = 0; j < parNames.length; ++j) {
                if (this.optimizer.variableSettings(parNames[i]).isFixed() || this.optimizer.variableSettings(parNames[j]).isFixed()) continue;
                result.setCovMatrixElement(i, j, covMatrix[countI][countJ++]);
            }
            if (this.optimizer.variableSettings(parNames[i]).isFixed()) continue;
            ++countI;
        }
        return result;
    }

    public IFitResult fit(IBaseHistogram h, IFunction f) {
        return this.fit(h, f, null);
    }

    public IFitResult fit(IBaseHistogram h, IFunction f, String range) {
        if (h instanceof IHistogram || h instanceof IProfile) {
            if (this.fitMethod.fitType() == 1) {
                throw new IllegalArgumentException("Cannot perform unbinned fit on a IHistogram!!");
            }
            if (h instanceof ICloud && this.fitMethod.fitType() == 0) {
                throw new IllegalArgumentException("Cannot perform binned fit on a ICloud!!");
            }
        }
        IFitData fitData = FitDataCreator.create((Object)h);
        return this.fit(fitData, f, range);
    }

    private void setDefaultInitialParameters(IFunction f, String model, Object data) {
        if (model.equals("g") && data instanceof IHistogram1D) {
            IHistogram1D h1 = (IHistogram1D)data;
            double[] pars = new double[]{h1.maxBinHeight(), h1.mean(), h1.rms()};
            f.setParameters(pars);
        }
    }

    public IFitResult fit(IBaseHistogram h, String model) {
        return this.fit(h, model, (String)null);
    }

    public IFitResult fit(IBaseHistogram h, String model, String range) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        this.setDefaultInitialParameters(func, model, h);
        return this.fit(h, func, range);
    }

    public IFitResult fit(IBaseHistogram h, String model, double[] initialParameters) {
        return this.fit(h, model, initialParameters, null);
    }

    public IFitResult fit(IBaseHistogram h, String model, double[] initialParameters, String range) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        if (initialParameters.length != func.numberOfParameters()) {
            throw new IllegalArgumentException("Wrong number of parameters " + initialParameters.length + "! This function requires " + func.numberOfParameters());
        }
        func.setParameters(initialParameters);
        return this.fit(h, func, range);
    }

    public IFitResult fit(IDataPointSet dataPointSet, IFunction f) {
        return this.fit(dataPointSet, f, (String)null);
    }

    public IFitResult fit(IDataPointSet dataPointSet, IFunction f, String range) {
        return this.fit(dataPointSet, f, range, null);
    }

    public IFitResult fit(IDataPointSet dataPointSet, IFunction f, double[] initialParameters) {
        return this.fit(dataPointSet, f, initialParameters, null, null);
    }

    @Override
    public IFitResult fit(IDataPointSet dataPointSet, IFunction f, String range, Object correlationObject) {
        return this.fit(dataPointSet, f, null, range, correlationObject);
    }

    public IFitResult fit(IDataPointSet dataPointSet, IFunction f, double[] initialParameters, String range, Object correlationObject) {
        if (this.fitMethod.fitType() == 1) {
            throw new IllegalArgumentException("Cannot perform unbinned fit on a IDataPointSet!!");
        }
        if (dataPointSet.dimension() != f.dimension() + 1) {
            throw new IllegalArgumentException("Wrong dimension match. DataPointSets can only be fitted if their dimension is one unit bigger than the one of the function");
        }
        if (initialParameters != null) {
            if (initialParameters.length != f.numberOfParameters()) {
                throw new IllegalArgumentException("Wrong number of parameters " + initialParameters.length + "! This function requires " + f.numberOfParameters());
            }
            f.setParameters(initialParameters);
        }
        IFitData fitData = FitDataCreator.create((Object)dataPointSet);
        return this.fit(fitData, f, range, correlationObject);
    }

    public IFitResult fit(IDataPointSet dataPointSet, String model) {
        return this.fit(dataPointSet, model, (String)null);
    }

    public IFitResult fit(IDataPointSet dataPointSet, String model, String range) {
        return this.fit(dataPointSet, model, range, null);
    }

    @Override
    public IFitResult fit(IDataPointSet dataPointSet, String model, String range, Object correlationObject) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        this.setDefaultInitialParameters(func, model, dataPointSet);
        return this.fit(dataPointSet, func, range, correlationObject);
    }

    public IFitResult fit(IDataPointSet dataPointSet, String model, double[] initialParameters) {
        return this.fit(dataPointSet, model, initialParameters, null, null);
    }

    public IFitResult fit(IDataPointSet dataPointSet, String model, double[] initialParameters, String range) {
        return this.fit(dataPointSet, model, initialParameters, range, null);
    }

    @Override
    public IFitResult fit(IDataPointSet dataPointSet, String model, double[] initialParameters, String range, Object correlationObject) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        return this.fit(dataPointSet, func, initialParameters, range, correlationObject);
    }

    public IFitResult fit(IFitData d, String model, double[] initialParameters) {
        return this.fit(d, model, initialParameters, null);
    }

    public IFitResult fit(IFitData d, String model, double[] initialParameters, String range) {
        return this.fit(d, model, initialParameters, range, null);
    }

    @Override
    public IFitResult fit(IFitData d, String model, double[] initialParameters, String range, Object correlationObject) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        if (initialParameters != null) {
            if (initialParameters.length != func.numberOfParameters()) {
                throw new IllegalArgumentException("Wrong number of parameters " + initialParameters.length + "! This function requires " + func.numberOfParameters());
            }
            func.setParameters(initialParameters);
        }
        return this.fit(d, func, range, correlationObject);
    }

    public IFitResult fit(IFitData d, String model) {
        return this.fit(d, model, (String)null);
    }

    public IFitResult fit(IFitData d, String model, String range) {
        return this.fit(d, model, range, null);
    }

    @Override
    public IFitResult fit(IFitData d, String model, String range, Object correlationObject) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        return this.fit(d, func, range, correlationObject);
    }

    public void setConstraint(String expression) throws IllegalArgumentException {
        if (!this.optimizer.acceptsConstraints()) {
            throw new UnsupportedOperationException("Optimizer " + this.engineName() + " does not accept constraints.");
        }
        StringTokenizer st = new StringTokenizer(expression, "=");
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Only constraints of the form \" parName = SomeExpression \" are supported");
        }
        String parName = st.nextToken().trim();
        if (!Pattern.matches("\\w+", parName)) {
            throw new IllegalArgumentException("Incorrect parameter name " + parName);
        }
        String constrExpression = st.nextToken().trim();
        if (!Pattern.matches("\\w+", constrExpression)) {
            throw new IllegalArgumentException("This type of constraint is not supported yet " + parName + " = " + constrExpression);
        }
        this.simpleConstraintHash.put(parName, constrExpression);
        this.constraintList.add(expression);
    }

    public String[] constraints() {
        int size = this.constraintList.size();
        String[] constraints = new String[size];
        for (int i = 0; i < size; ++i) {
            constraints[i] = (String)this.constraintList.get(i);
        }
        return constraints;
    }

    public void resetConstraints() {
        this.simpleConstraintHash.clear();
        this.constraintList.clear();
    }

    public IDataPointSet createScan1D(IFitData d, IFunction originalFunction, String parName, int npts, double pmin, double pmax) {
        if (pmin > pmax) {
            throw new IllegalArgumentException("Incorret parameter limits : " + pmin + " has to be less than " + pmax);
        }
        if (npts < 1) {
            throw new IllegalArgumentException("The number of points has to be greater than zero : " + npts);
        }
        IFunction fClone = this.cloneFunction(null, originalFunction);
        Object f = fClone instanceof IModelFunction ? (IModelFunction)fClone : new BaseModelFunction("", "", fClone);
        this.loadFitDataAndFunction(d, (IModelFunction)f);
        int index = f.indexOfParameter(parName);
        IFitParameterSettings fitParSet = this.fitParameterSettings(parName);
        if (fitParSet.isFixed()) {
            throw new IllegalArgumentException("Parameter " + parName + " is fixed");
        }
        DataPointSet dps = new DataPointSet("", parName + " scan", 2, npts);
        double step = (pmax - pmin) / (double)(npts - 1);
        double startValue = this.optimizer.variableSettings(parName).value();
        for (int i = 0; i < npts; ++i) {
            double val = pmin + (double)i * step;
            if (i == npts - 1) {
                val = pmax;
            }
            this.optimizer.variableSettings(parName).setValue(val);
            String[] parNames = f.parameterNames();
            double[] fitParsVal = new double[parNames.length];
            for (int j = 0; j < parNames.length; ++j) {
                fitParsVal[j] = this.optimizer.variableSettings(parNames[j]).value();
            }
            dps.point(i).coordinate(0).setValue(val);
            dps.point(i).coordinate(0).setErrorPlus(0.0);
            dps.point(i).coordinate(0).setErrorMinus(0.0);
            dps.point(i).coordinate(1).setValue(this.fitFunction.value(fitParsVal));
            dps.point(i).coordinate(1).setErrorPlus(0.0);
            dps.point(i).coordinate(1).setErrorMinus(0.0);
        }
        this.optimizer.variableSettings(parName).setValue(startValue);
        f.setParameter(parName, startValue);
        return dps;
    }

    public IDataPointSet createContour(IFitData d, IFitResult r, String par1, String par2, int npts, double nSigmas) {
        double[][] contour;
        IFunction result = r.fittedFunction();
        Object f = result instanceof IModelFunction ? (IModelFunction)result : new BaseModelFunction("", "", result);
        this.loadFitDataAndFunction(d, (IModelFunction)f);
        if (this.optimizer.canCalculateContours()) {
            contour = this.optimizer.calculateContour(par1, par2, npts, nSigmas);
        } else {
            String eName = this.engineName();
            this.setEngine("minuit");
            contour = this.optimizer.calculateContour(par1, par2, npts, nSigmas);
            this.setEngine(eName);
        }
        int found = contour[0].length;
        DataPointSet dps = new DataPointSet("", par1 + " vs " + par2 + " " + nSigmas + " sigma contour", 2, found);
        for (int i = 0; i < found; ++i) {
            dps.point(i).coordinate(0).setValue(contour[0][i]);
            dps.point(i).coordinate(0).setErrorPlus(0.0);
            dps.point(i).coordinate(0).setErrorMinus(0.0);
            dps.point(i).coordinate(1).setValue(contour[1][i]);
            dps.point(i).coordinate(1).setErrorPlus(0.0);
            dps.point(i).coordinate(1).setErrorMinus(0.0);
        }
        return dps;
    }

    private IFunction fitFunction() {
        return this.fitFunction;
    }

    public boolean useFunctionGradient() {
        return this.useGradient;
    }

    public void setUseFunctionGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }

    private void loadFitDataAndFunction(IFitData d, IModelFunction f) {
        if (this.fitMethod.fitType() != ((IDevFitData)d).fitType()) {
            throw new IllegalArgumentException("This FitData is incompatible with the selected fit method");
        }
        if (d.dimension() != f.dimension()) {
            throw new IllegalArgumentException("Dimension mismatch!! Function's dimension " + f.dimension() + " FitData's dimension " + d.dimension());
        }
        this.optimizer.reset();
        if (this.fitMethod.fitType() == 0) {
            this.optimizer.configuration().setErrorDefinition(1);
            f.normalize(false);
        } else {
            this.optimizer.configuration().setErrorDefinition(2);
            f.normalize(true);
        }
        IDevFitDataIterator dataIter = ((IDevFitData)d).dataIterator();
        this.fitFunction = new FitFunction(dataIter, f);
        String[] parNames = f.parameterNames();
        for (int i = 0; i < parNames.length; ++i) {
            double stepSize;
            String parName = parNames[i];
            IFitParameterSettings fitPar = this.fitParameterSettings(parName);
            double parVal = f.parameter(parName);
            IVariableSettings varSet = this.optimizer.variableSettings(parName);
            varSet.setValue(parVal);
            varSet.setFixed(fitPar.isFixed());
            String simpleConstrString = (String)this.simpleConstraintHash.get(parName);
            if (simpleConstrString != null && ((FitFunction)this.fitFunction).isValidSimpleConstraint(parName, simpleConstrString)) {
                ((FitFunction)this.fitFunction).setSimpleConstraint(parName, simpleConstrString);
                varSet.setFixed(true);
            }
            if (Double.isNaN(stepSize = fitPar.stepSize()) && (stepSize = 0.1 * Math.abs(parVal)) < 1.0) {
                stepSize = 1.0;
            }
            varSet.setStepSize(stepSize);
            if (!fitPar.isBound()) continue;
            varSet.setBounds(fitPar.lowerBound(), fitPar.upperBound());
        }
        this.optimizer.setFunction(this.fitFunction);
        this.optimizer.configuration().setUseFunctionGradient(false);
        this.optimizer.configuration().setMaxIterations(500);
    }

    private IFunction cloneFunction(String name, IFunction originalFunction) {
        IFunction fClone = originalFunction;
        if (this.createClone) {
            fClone = FunctionCatalog.getFunctionCatalog().clone(name, originalFunction);
        }
        return fClone;
    }

    public static void main(String[] args) throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IFunction f = ff.createFunctionByName("parabola", "p2");
    }

    private class FitFunction
    implements IFunction {
        private IDevFitDataIterator dataIterator;
        private IModelFunction func;
        private ArrayList varSimpleConstraint1;
        private ArrayList varSimpleConstraint2;

        FitFunction(IDevFitDataIterator dataIterator, IModelFunction func) {
            this.dataIterator = dataIterator;
            this.func = func;
            this.varSimpleConstraint1 = new ArrayList();
            this.varSimpleConstraint2 = new ArrayList();
        }

        public int dimension() {
            return this.func.numberOfParameters();
        }

        public double value(double[] x) {
            if (this.varSimpleConstraint1.size() != 0) {
                this.applySimpleConstraint(x);
            }
            this.func.setParameters(x);
            return Fitter.this.fitMethod.evaluate(this.dataIterator, (IFunction)this.func);
        }

        public boolean providesGradient() {
            return this.func.providesParameterGradient();
        }

        public String variableName(int i) {
            return this.func.parameterNames()[i];
        }

        public String[] variableNames() {
            return this.func.parameterNames();
        }

        public int numberOfParameters() {
            return 0;
        }

        public double[] gradient(double[] x) {
            if (this.varSimpleConstraint1.size() != 0) {
                this.applySimpleConstraint(x);
            }
            this.func.setParameters(x);
            double[] result = Fitter.this.fitMethod.evaluateGradient(this.dimension(), this.dataIterator, (IFunction)this.func);
            return result;
        }

        public boolean isEqual(IFunction f) {
            throw new UnsupportedOperationException();
        }

        public IAnnotation annotation() {
            throw new UnsupportedOperationException();
        }

        public String codeletString() {
            throw new UnsupportedOperationException();
        }

        public void setParameters(double[] params) {
            throw new UnsupportedOperationException();
        }

        public double[] parameters() {
            throw new UnsupportedOperationException();
        }

        public int indexOfParameter(String name) {
            throw new UnsupportedOperationException();
        }

        public String[] parameterNames() {
            throw new UnsupportedOperationException();
        }

        public void setParameter(String name, double x) {
            throw new UnsupportedOperationException();
        }

        public double parameter(String name) {
            throw new UnsupportedOperationException();
        }

        public void setTitle(String str) {
            throw new UnsupportedOperationException();
        }

        public String title() {
            throw new UnsupportedOperationException();
        }

        public String normalizationParameter() {
            throw new UnsupportedOperationException();
        }

        protected int nFreePars() {
            int freePars = 0;
            String[] names = this.variableNames();
            for (int i = 0; i < names.length; ++i) {
                IFitParameterSettings fitPar = Fitter.this.fitParameterSettings(names[i]);
                if (fitPar.isFixed()) continue;
                ++freePars;
            }
            return freePars;
        }

        protected int dataEntries() {
            return this.dataIterator.entries();
        }

        protected int indexOfVariable(String varName) {
            return this.func.indexOfParameter(varName);
        }

        protected void setSimpleConstraint(String varName1, String varName2) {
            int ind1 = this.indexOfVariable(varName1);
            int ind2 = this.indexOfVariable(varName2);
            if (ind1 > -1 && ind2 > -1) {
                this.varSimpleConstraint1.add(new Integer(ind1));
                this.varSimpleConstraint2.add(new Integer(ind2));
            }
        }

        protected boolean isValidSimpleConstraint(String varName1, String varName2) {
            int ind1 = this.indexOfVariable(varName1);
            int ind2 = this.indexOfVariable(varName2);
            return ind1 > -1 && ind2 > -1;
        }

        protected void applySimpleConstraint(double[] x) {
            for (int i = 0; i < this.varSimpleConstraint1.size(); ++i) {
                int ind1 = (Integer)this.varSimpleConstraint1.get(i);
                int ind2 = (Integer)this.varSimpleConstraint2.get(i);
                x[ind1] = x[ind2];
            }
        }
    }
}

