import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.demo.main.DemoSubsystemWithMonitoring;
import org.lsst.ccs.subsystem.demo.main.device.DemoDevice;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Page;

CCSBuilder builder = ["monitor-test"]

builder.
    "main" (DemoSubsystemWithMonitoring) {
    
    Alarm1  (Alarm, [description:"Trips off all power", eventParm:0])
        
    REB0  (DemoDevice, name:"REB0")
    REB1  (DemoDevice, name:"REB1")
    REB2  (DemoDevice, name:"REB2")
    RSA  (DemoDevice, name:"RSA")

    Page1 (Page, id: 1, label: "Page1")
    Page2 (Page, id: 2, label: "Page2")
     
            "REB0/Global/Power/VP5_UNREG/Voltage"  (Channel, description:"c001", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1", pageId: 1)
    "REB0/Global/Power/VP5_UNREG/Current"  (Channel, description:"c002", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1", pageId: 2)
    "REB0/Global/Power/VP5_UNREG/Power"  (Channel, description:"c003", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Power/VP7_UNREG/Voltage"  (Channel, description:"c004", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Power/VP7_UNREG/Current"  (Channel, description:"c005", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Power/VP7_UNREG/Power"  (Channel, description:"c006", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Power/VP15_UNREG/Voltage"  (Channel, description:"c007", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Power/VP15_UNREG/Current"  (Channel, description:"c008", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Power/VP15_UNREG/Power"  (Channel, description:"c009", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Power/Total Power/Power"  (Channel, description:"c010", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")

    "REB0/Global/Clock Rails/P_LO"  (Channel, description:"c011", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB0/Global/Clock Rails/P_HI"  (Channel, description:"c012", format:"f", devcName:"REB0", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    
        "REB1/Global/Power/VP5_UNREG/Voltage"  (Channel, description:"c001", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP5_UNREG/Current"  (Channel, description:"c002", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP5_UNREG/Power"  (Channel, description:"c003", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP7_UNREG/Voltage"  (Channel, description:"c004", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP7_UNREG/Current"  (Channel, description:"c005", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP7_UNREG/Power"  (Channel, description:"c006", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP15_UNREG/Voltage"  (Channel, description:"c007", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP15_UNREG/Current"  (Channel, description:"c008", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/VP15_UNREG/Power"  (Channel, description:"c009", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Power/Total Power/Power"  (Channel, description:"c010", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    
    "REB1/Global/Clock Rails/P_LO"  (Channel, description:"c011", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "REB1/Global/Clock Rails/P_HI"  (Channel, description:"c012", format:"f", devcName:"REB1", hwChan:6, type:"VOLTS", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")

    "Cold_Temp/CLP-RTD-00"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cold_Temp/CLP-RTD-02"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cold_Temp/CLP-RTD-03"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cold_Temp/CLP-RTD-05"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cold_Temp/CLP-RTD-50"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cold_Temp/CLP-RTD-52"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cold_Temp/CLP-RTD-53"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cold_Temp/CLP-RTD-55"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")

    "Trim_Htrs/ColdHtr0_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/ColdHtr1_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/ColdHtr2_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/ColdHtr3_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/ColdHtr4_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/ColdHtr5_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/ColdTotal_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")

    "Cryo_Temp/CYP-RTD-02"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-03"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-04"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-12"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-13"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-14"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-21"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-22"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-24"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-25"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-30"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-31"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-33"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-34"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-41"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-42"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-43"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-51"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-52"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Cryo_Temp/CYP-RTD-53"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")

    "Trim_Htrs/CryoHtr0_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/CryoHtr1_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/CryoHtr2_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/CryoHtr3_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/CryoHtr4_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/CryoHtr5_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Trim_Htrs/CryoTotal_P"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")

    "Grid_Temp/CFX-RTD-01"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/CFX-RTD-02"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/CFX-RTD-03"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/CFX-RTD-04"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GFX-RTD-01"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GFX-RTD-02"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GFX-RTD-03"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GFX-RTD-04"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GRD-RTD-01"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GRD-RTD-02"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GRD-RTD-03"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    "Grid_Temp/GRD-RTD-04"  (Channel, description:"RTD-00", format:"f", devcName:"REB1", hwChan:6, type:"C", subtype:"10V", checkLo:"flag", alarmLo:null, checkHi:"alarm", alarmHi:"Alarm1")
    
}
