/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenPlutoGateway
extends PlutoGateway {
    public static final Logger LOCAL_LOG = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs.CanOpenPlutoGateway");

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the Gateway.")
    public void initializeAndCheckHardware() {
        this.checkBooted();
        try {
            FCSCst.FCSLOG.info((Object)(this.name + " BEGIN initializeHardware"));
            this.configurePlutoGateway();
            this.initialized = true;
            FCSCst.FCSLOG.info((Object)(this.name + " is INITIALIZED."));
            FCSCst.FCSLOG.info((Object)(this.name + " END initializeHardware"));
            this.publishData();
        }
        catch (FailedCommandException | SDORequestException ex) {
            throw new FcsHardwareException(this.name, ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configures this gateway for subsystem needs. If gateway's name contains loader it executes configureLoaderPlutoGatewayelse it executes configureAutochangerPlutoGateway.")
    public void configurePlutoGateway() {
        if (this.name.contains("loader")) {
            this.configureLoaderPlutoGateway();
        } else if (this.getName().startsWith("acSensors")) {
            this.configureAutochangerPlutoGateway();
        }
    }

    private void configureAutochangerPlutoGateway() {
        FCSCst.FCSLOG.info((Object)(this.name + " configureAutochangerGateway"));
        this.writeSDO(8208, 1, 1, 0);
        this.writeSDO(8209, 1, 2, 23);
        this.writeSDO(8209, 2, 2, 4);
        this.writeSDO(8210, 1, 2, 279);
        this.writeSDO(8210, 2, 2, 323);
    }

    private void configureLoaderPlutoGateway() {
        FCSCst.FCSLOG.info((Object)(this.name + " configureLoaderPlutoGateway"));
        this.writeSDO(8208, 1, 1, 1);
        this.writeSDO(8209, 1, 2, 1);
        this.writeSDO(8209, 2, 2, 2);
        this.writeSDO(8210, 1, 2, 3);
        this.writeSDO(8194, 1, 1, 7);
    }

    public void writeTransmissionType(int transmissionType) {
        this.writeSDO(8197, 1, 1, transmissionType);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return values read on the device.")
    public int[] readNewValues() {
        int WAIT = 2;
        this.checkBooted();
        try {
            for (int byteNumero = 0; byteNumero < 16; ++byteNumero) {
                int index = FcsUtils.returnIndex(byteNumero);
                int subindex = FcsUtils.returnSubindex(byteNumero);
                this.readValues[byteNumero] = (int)this.readSDO(index, subindex);
                if (byteNumero > 0) {
                    this.reReadValueInError(byteNumero, index, subindex);
                }
                FcsUtils.sleep(WAIT, this.name);
            }
        }
        catch (SDORequestException ex) {
            String message = this.name + "=> ERROR IN READING SENSOR:";
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, message, this.name, ex);
        }
        return this.readValues;
    }

    private void reReadValueInError(int i, int index, int subindex) {
        if (this.readValues[i] == this.readValues[i - 1]) {
            FCSCst.FCSLOG.warning((Object)(this.name + " error in reading values for byte=" + i + ",index=0x" + Integer.toHexString(index) + ", subindex=" + subindex));
            this.readValues[i] = (int)this.readSDO(index, subindex);
        }
    }
}

