/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.PT100Interface;
import org.lsst.ccs.subsystems.fcs.common.TTC580Interface;
import org.lsst.ccs.subsystems.fcs.errors.ControllerFaultException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Carousel
extends MobileItem
implements HardwareController,
FilterHolder,
AlertRaiser {
    private static final long serialVersionUID = -2376279469784152348L;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    private int rotationTimeout;
    private long profileVelocity;
    private long profileAcceleration;
    private long profileDeceleration;
    protected int position = 0;
    private int relativeTargetPosition;
    protected int absoluteTargetPosition;
    @ConfigurationParameter(description="Difference between target position and actual position. This is used to know if the rotation is completed.", units="Carousel encoder steps", range="0..2181120", category="carousel")
    protected volatile int deltaPosition = 1000;
    protected int readVelocity = 0;
    protected int readCurrent = 0;
    @ConfigurationParameter(description="below this value of deltaPosition, carousel position at STANDBY is correct", units="Carousel encoder steps", range="0..2181120", category="carousel")
    private volatile int minStandbyDeltaPosition = 100;
    @ConfigurationParameter(description="over this value of deltaPosition, carousel position at STANDBY is NOT correct", units="Carousel encoder steps", range="0..2181120", category="carousel")
    private volatile int maxStandbyDeltaPosition = 130;
    private final int fullTurn = 4362240;
    private final int halfTurn = 2181120;
    @ConfigurationParameter(description="velocity in slow mode", units="Carousel velocity unit", range="0..5000", category="carousel")
    public volatile int slowVelocity = 500;
    @ConfigurationParameter(description="acceleration in slow mode", units="Carousel acceleration unit", range="0..5000", category="carousel")
    public volatile int slowAcceleration = 200;
    @ConfigurationParameter(description="deceleration in slow mode", units="Carousel acceleration unit", range="0..5000", category="carousel")
    public volatile int slowDeceleration = 200;
    @ConfigurationParameter(description="in milliseconds; timeout for the rotation in slow mode", units="milliseconds", range="0..300000", category="carousel")
    public volatile int slowRotationTimeout = 100000;
    @ConfigurationParameter(description="velocity in fast mode", units="Carousel velocity unit", range="0..5000", category="carousel")
    public volatile int fastVelocity = 3400;
    @ConfigurationParameter(description="acceleration in fast mode", units="Carousel acceleration unit", range="0..5000", category="carousel")
    public volatile int fastAcceleration = 2000;
    @ConfigurationParameter(description="deceleration in fast mode", units="Carousel acceleration unit", range="0..5000", category="carousel")
    public volatile int fastDeceleration = 1000;
    @ConfigurationParameter(description="in milliseconds; timeout for the rotation in fast mode", units="milliseconds", range="0..300000", category="carousel")
    public volatile int fastRotationTimeout = 20000;
    @ConfigurationParameter(description="This is the time to wait until protection system changes its status after motions.", units="milliseconds", range="0..5000", category="carousel")
    public volatile long timeToUpdateProtectionSystem = 2000L;
    @ConfigurationParameter(description="for command unlock of carousel clamp : current to send to prepare unlock", range="-3200..3200", units="mA", category="carousel")
    protected volatile int currentToPrepareUnlock = -100;
    @ConfigurationParameter(description="for command unlock of carousel clamp : time between little current to prepare hardware and currentToLock ", range="0..500", units="milliseconds", category="carousel")
    protected volatile int timeToPrepareUnlock = 200;
    @ConfigurationParameter(description="A current to be sent to clampXminus controller during locking recovery.", units="mV", range="0..1000", category="carousel")
    public volatile int recoveryLockingCurrent = 400;
    @ConfigurationParameter(description="If the velocity in clampXminus controller goes over this value during locking recovery, it means that the recovery process has failed.", units="rpm", range="0..100", category="carousel")
    public volatile int recoveryMaxVelocity = 60;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXminusController")
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXplusController")
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carouselController")
    protected EPOSControllerForCarousel carouselController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*hyttc580")
    private TTC580Interface hyttc580;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*ai814")
    protected ADCInterface ai814;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="pt100")
    private PT100Interface pt100;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, CarouselSocket> socketsMap = new TreeMap<String, CarouselSocket>();
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="tcpProxy")
    protected BridgeToHardware tcpProxy;
    private boolean initialized = false;
    protected boolean clampsStateInitialized = false;
    protected boolean homingDone = false;
    private int socketAtStandbyID;
    protected CarouselSocket socketAtStandby;
    private boolean OUT_CS;
    private boolean OUT_CFC;
    private boolean OUT_CF0;
    private boolean OUT_CF1;
    private boolean OUT_CS_InError;
    private boolean OUT_CFC_InError;
    private boolean OUT_CF0_InError;
    private boolean OUT_CF1_InError;

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByCarousel.class, this.name);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if CANopen devices are booted and initialized and homing has been done.")
    boolean isInitialized() {
        return this.myDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if clamp state is initialized for all clamps.")
    public boolean isClampsStateInitialized() {
        return this.clampsStateInitialized;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if carouselController homing is done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    public int getCurrentToPrepareUnlock() {
        return this.currentToPrepareUnlock;
    }

    public int getTimeToPrepareUnlock() {
        return this.timeToPrepareUnlock;
    }

    public int getRecoveryLockingCurrent() {
        return this.recoveryLockingCurrent;
    }

    public int getRecoveryMaxVelocity() {
        return this.recoveryMaxVelocity;
    }

    public int getFullTurn() {
        return 4362240;
    }

    public Map<String, CarouselSocket> getSocketsMap() {
        return this.socketsMap;
    }

    public CarouselSocket getSocketByName(String socketName) {
        if (this.socketsMap.containsKey(socketName)) {
            return this.socketsMap.get(socketName);
        }
        throw new IllegalArgumentException(this.name + ": no such name for socket:" + socketName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return carousel position.", alias="printPosition")
    public int getPosition() {
        return this.position;
    }

    public EPOSController getClampXminusController() {
        return this.clampXminusController;
    }

    public EPOSController getClampXplusController() {
        return this.clampXplusController;
    }

    public CarouselClamp getClampXminus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXminus();
    }

    public CarouselClamp getClampXplus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXplus();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a socket is HALTED at STANDBY position, false otherwise.")
    public boolean isAtStandby() {
        return this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5;
    }

    public CarouselSocket getSocketAtStandby() {
        return this.socketAtStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="return ID of socket at STANDBY")
    public int getSocketAtStandbyID() {
        return this.socketAtStandbyID;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns name of filter at STANDBY position  or NO_FILTER if there is no filter at STANDBY.")
    public String getFilterAtStandbyName() {
        if (this.socketAtStandby == null) {
            return "NO FILTER";
        }
        return this.socketAtStandby.getFilterName();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns id of filter at STANDBY position  or NO_FILTER if there is no filter at STANDBY.")
    public int getFilterIDatStandby() {
        if (this.socketAtStandby == null) {
            return 0;
        }
        return this.socketAtStandby.getFilterID();
    }

    public boolean isFilterOnCarousel(int filterID) {
        return this.socketsMap.values().stream().anyMatch(socket -> socket.getFilterID() == filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To change filterID on socket which ID is given as argument.")
    public void changeFilterID(int filterID, int socketID) {
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + ": bad value - enter a digit between 1 and 5");
        }
        if (this.isFilterOnCarousel(filterID)) {
            int sockID = this.getFilterSocket(filterID).getId();
            throw new IllegalArgumentException(filterID + " filter already on carousel on socket" + sockID);
        }
        String socketName = "socket" + socketID;
        this.socketsMap.get(socketName).setFilterID(filterID);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if Autochanger is holding filter at STANDBY.")
    public boolean isAutochangerHoldingFilter() {
        this.autochanger.updateStateWithSensors();
        return this.autochanger.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize carousel hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.tcpProxy.bootProcess();
        this.postStart();
    }

    public void postStart() {
        FCSLOG.info((Object)(this.name + " BEGIN postStart."));
        if (this.carouselController.isBooted()) {
            this.initializeRotationController();
            this.profileVelocity = this.carouselController.readProfileVelocity();
            this.profileAcceleration = this.carouselController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration);
            this.profileDeceleration = this.carouselController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration);
            this.rotationTimeout = this.profileVelocity == (long)this.slowVelocity ? this.slowRotationTimeout : this.fastRotationTimeout;
        }
        if (this.clampXminusController.isBooted()) {
            this.initializeClampController(this.clampXminusController);
        }
        if (this.clampXplusController.isBooted()) {
            this.initializeClampController(this.clampXplusController);
        }
        if (this.hyttc580.isBooted()) {
            this.initializeClampsState();
        }
        FCSLOG.info((Object)(this.name + " END postStart."));
    }

    private void initializeRotationController() {
        try {
            this.carouselController.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.carouselController.getName(), ex);
        }
    }

    private void initializeClampController(EPOSController controller) {
        try {
            controller.initializeAndCheckHardware();
            if (!controller.isInMode(EPOSEnumerations.EposMode.CURRENT)) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "  is not in CURRENT mode.", controller.getName());
            }
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller ", controller.getName(), ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="CarouselHoming")
    public void homing() {
        this.homingDone = false;
        for (int tryout = 2; tryout > 0; --tryout) {
            this.doHoming();
            if (Math.abs(this.carouselController.readPosition()) < 1) continue;
            this.homingDone = true;
            break;
        }
        if (!this.homingDone) {
            throw new FcsHardwareException(this.name + " not complete because |position| < 1. This should not happen after homing.");
        }
        this.publishData();
    }

    private void doHoming() {
        this.setControllerPositionSensorTypeEncoderSSI();
        int ssiPosition = this.carouselController.readSSIPosition();
        FCSLOG.info((Object)(this.name + " ssiPosition = " + ssiPosition));
        this.carouselController.doSetSinusIncrementalEncoder();
        try {
            this.carouselController.defineAbsolutePosition(ssiPosition);
            this.carouselController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        }
        finally {
            this.carouselController.goToSwitchOnDisabled();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Disable carousel controller, set the position sensor to TypeEncoderSSI, and check that the ssi position is correct.")
    public void setControllerPositionSensorTypeEncoderSSI() {
        this.carouselController.setPositionSensorTypeEncoderSSI();
        this.position = this.carouselController.readPosition();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="slow down profile velocity, acceleration and deceleration in carousel controller.")
    public void setSlowMode() {
        this.carouselController.changeProfileVelocity(this.slowVelocity);
        this.profileVelocity = this.slowVelocity;
        this.carouselController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.slowAcceleration);
        this.profileAcceleration = this.slowAcceleration;
        this.carouselController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.slowDeceleration);
        this.profileDeceleration = this.slowDeceleration;
        this.rotationTimeout = this.slowRotationTimeout;
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="raise profile velocity, acceleration and deceleration in carousel controller.")
    public void setFastMode() {
        this.carouselController.changeProfileVelocity(this.fastVelocity);
        this.profileVelocity = this.fastVelocity;
        this.carouselController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.fastAcceleration);
        this.profileAcceleration = this.fastAcceleration;
        this.carouselController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.fastDeceleration);
        this.profileDeceleration = this.fastDeceleration;
        this.rotationTimeout = this.fastRotationTimeout;
        this.publishData();
    }

    public void waitForProtectionSystemUpdate() {
        this.waitForStateUnclampedOnFilter(this.timeToUpdateProtectionSystem);
    }

    public void waitForStateUnclampedOnFilter(long timeout) {
        long cmdBeginTime = System.currentTimeMillis();
        long waitTime = 0L;
        while (!this.isUnclampedOnFilterAtStandby() && waitTime < timeout) {
            FCSLOG.info((Object)(this.name + " waiting for local protection system update. waitTime = " + waitTime));
            FcsUtils.sleep(100, this.name);
            waitTime = System.currentTimeMillis() - cmdBeginTime;
            this.updateSocketAtStandbyWithSensors();
        }
    }

    private void checkHomingDone() {
        if (!this.isHomingDone()) {
            throw new FcsHardwareException(this.name + " homing has to be done before motion.");
        }
    }

    public void checkSensorTypeIncremental() {
        int sensorType = this.carouselController.readPositionSensorType();
        if (sensorType != 8) {
            throw new FcsHardwareException(this.name + " PositionSensorType has to be set to Incremental Encoder before motion.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="save persist file to store which filter is in socket and clamps offsets")
    public void persistData() {
        this.persistenceService.persistNow();
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData("carousel", (Serializable)this.createStatusDataPublishedByCarousel()));
    }

    public StatusDataPublishedByCarousel createStatusDataPublishedByCarousel() {
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel();
        status.setPosition(this.position);
        status.setPositionSensorType(this.carouselController.getPositionSensorType());
        status.setCurrent(this.readCurrent);
        status.setVelocity(this.readVelocity);
        status.setHomingDone(this.homingDone);
        status.setAtStandby(this.isAtStandby());
        status.setSocketAtStandbyID(this.socketAtStandbyID);
        if (this.isEmptyAtStandby()) {
            status.setFilterAtStandbyName("NO FILTER");
        } else {
            status.setFilterAtStandbyName(this.getFilterAtStandbyName());
        }
        if (this.isAtStandby()) {
            status.setSocketAtStandbyName(this.socketAtStandby.getName());
            status.setEmptyAtStandby(this.isEmptyAtStandby());
            status.setDeltaPositionAtStandby(this.socketAtStandby.getDeltaPosition());
        } else if (this.socketAtStandbyID == 0) {
            status.setSocketAtStandbyName("NO_SOCKET_AT_STANDBY");
        } else if (this.socketAtStandbyID == 7) {
            status.setSocketAtStandbyName("ERROR_READING_ID");
        }
        status.setProfileAcceleration(this.profileAcceleration);
        status.setProfileDeceleration(this.profileDeceleration);
        status.setProfileVelocity(this.profileVelocity);
        status.setRotationTimeout(this.rotationTimeout);
        status.setOUT_CF0(this.OUT_CF0);
        status.setOUT_CF1(this.OUT_CF1);
        status.setOUT_CFC(this.OUT_CFC);
        status.setOUT_CS(this.OUT_CS);
        status.setOUT_CF0_InError(this.OUT_CF0_InError);
        status.setOUT_CF1_InError(this.OUT_CF1_InError);
        status.setOUT_CFC_InError(this.OUT_CFC_InError);
        status.setOUT_CS_InError(this.OUT_CS_InError);
        status.setTemperature1(this.pt100.getTemperature(1));
        status.setTemperature2(this.pt100.getTemperature(2));
        status.setTemperature3(this.pt100.getTemperature(3));
        status.setTemperature4(this.pt100.getTemperature(4));
        status.setSensor1(this.ai814.getInput(0));
        status.setSensor2(this.ai814.getInput(1));
        status.setSensor3(this.ai814.getInput(2));
        status.setSensor4(this.ai814.getInput(3));
        status.setSensor5(this.ai814.getInput(4));
        status.setSensor6(this.ai814.getInput(5));
        status.setSensor7(this.ai814.getInput(6));
        status.setSensor8(this.ai814.getInput(7));
        return status;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if Carousel is stopped and no filter is at STANDBY position")
    public boolean isReadyToGrabAFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isEmpty() && this.socketAtStandby.isReadyToClamp();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if a filter is clamped at STANDBY position")
    public boolean isHoldingFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (this.socketAtStandby == null || this.socketAtStandby.isEmpty()) {
            return false;
        }
        return this.socketAtStandby.isClampedOnFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns false if carousel controller is SWITCH_ON_DISABLED.")
    public boolean isRotating() {
        return !this.carouselController.isInState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Set position sensor type SSI and update carousel position in reading controller.")
    public void updatePosition() {
        this.setControllerPositionSensorTypeEncoderSSI();
        try {
            this.position = this.carouselController.readPosition();
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update field current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.carouselController.readCurrent();
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    public void updateClampsStateWithSensorsFromPDO() {
        this.tcpProxy.updatePDOData();
        PDOData pdoStore = this.tcpProxy.getPDOData();
        FCSLOG.finest((Object)(this.name + ":pdoStore=" + pdoStore.toString()));
        this.socketsMap.values().stream().forEach(socket -> socket.updateState());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamps state in sending 5 sync.")
    public void initializeClampsState() {
        FCSLOG.info((Object)(this.name + " Initializing clamps state...."));
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        for (int count = 1; count <= 5; count = (int)((byte)(count + 1))) {
            FCSLOG.info((Object)(this.name + " sync no " + count));
            this.tcpProxy.updatePDOData();
            this.hyttc580.updateFromPDO(this.tcpProxy.getPDOData());
            this.updateState();
        }
        this.clampsStateInitialized = true;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp offsets.")
    public void initializeAndCheckClampsOffset() {
        FCSLOG.info((Object)(this.name + " Initializing clamps offsets...."));
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        this.socketsMap.values().stream().forEach(socket -> {
            byte socketId = (byte)socket.getId();
            long offset2 = this.hyttc580.readOffset2SDO(socketId);
            socket.checkAndUpdateOffset2(offset2);
            long offset1 = this.hyttc580.readOffset1SDO(socketId);
            socket.checkAndUpdateOffset1(offset1);
            socket.getClampXminus().publishData();
            socket.getClampXplus().publishData();
        });
        this.persistData();
    }

    public CarouselSocket getFilterSocket(int filterID) {
        CarouselSocket socket = null;
        for (CarouselSocket sock : this.socketsMap.values()) {
            if (sock.getFilterID() != filterID) continue;
            return sock;
        }
        return socket;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release clamps at standby position to get ready to clamp again")
    public void releaseClamps() {
        this.updateStateWithSensors();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't release clamps when no socket is halted at standby position.");
        }
        this.socketAtStandby.releaseClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamps at STANDBY.")
    public void unlockClamps() {
        this.updateSocketAtStandbyWithSensors();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't unlock clamps while a socket is not halted at standby position.");
        }
        FCSLOG.info((Object)"Unlocking clamps at standby.");
        this.socketAtStandby.unlockClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock clampXminus when clampXplus is already locked.")
    public void recoveryLockingXminus() {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't use command recoveryLockingXminus.");
        }
        if (this.socketAtStandby.getClampXplus().getClampState() == FcsEnumerations.FilterClampState.CLAMPEDONFILTER && this.socketAtStandby.getClampXminus().getClampState() != FcsEnumerations.FilterClampState.CLAMPEDONFILTER) {
            this.socketAtStandby.getClampXminus().recoveryLocking();
        }
    }

    public boolean isAtStandby(int filterID) {
        return this.socketAtStandby.getFilterID() != 0 && this.socketAtStandby.getFilterID() == filterID;
    }

    public void releaseClampsContact() {
    }

    @Override
    public boolean myDevicesReady() {
        return this.carouselController.isBooted() && this.carouselController.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if carousel rotation is permitted.")
    public void checkConditionsForRotation() {
        if (!this.initialized) {
            throw new FcsHardwareException("Carousel hardware is not initialized. Can't rotate.");
        }
        if (this.isAtStandby() && this.socketAtStandby.isUnclampedOnFilter()) {
            String message = "Filter at STANDBY position is not held by clamps. Can't rotate carousel.";
            FCSLOG.error((Object)message);
            throw new RejectedCommandException(message);
        }
        if (!this.autochanger.isAtHandoff()) {
            throw new RejectedCommandException(this.name + " can't rotate if autochanger is not at HANDOFF position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to a new absolute position.", timeout=60000)
    public void rotateToAbsolutePosition(int newPos) {
        boolean atPosition;
        if (this.pt100.isBooted()) {
            this.pt100.updateTemperatures();
        }
        boolean bl = atPosition = Math.abs(newPos - this.position) < this.deltaPosition;
        if (!atPosition) {
            this.checkReadyForAction();
            this.carouselController.checkInitialized();
            this.carouselController.checkFault();
            if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                throw new RejectedCommandException(this.name + " can rotate only if autochanger is at Handoff or at Online  " + newPos);
            }
            try {
                this.homing();
                this.checkHomingDone();
            }
            catch (ControllerFaultException ex) {
                throw new FcsHardwareException(String.format(this.name + " homing failed because %s is in fault", this.carouselController.getName()), ex);
            }
            int diffPos = newPos - this.position;
            this.absoluteTargetPosition = Math.abs(newPos - this.position) <= 2181120 ? newPos : (diffPos < 0 ? newPos + 4362240 : newPos - 4362240);
            FCSLOG.info((Object)(this.name + " is at position: " + this.position + "; about to rotate to absolute position: " + this.absoluteTargetPosition));
            this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION, this.rotationTimeout);
        }
    }

    public void rotateToRelativePosition(int relativePos, long timeout) {
        this.carouselController.checkInitialized();
        this.carouselController.checkFault();
        if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
            throw new RejectedCommandException(this.name + " can rotate only if autochanger is at Handoff or at Online.");
        }
        this.homing();
        this.checkHomingDone();
        this.relativeTargetPosition = relativePos;
        this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION, timeout);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a socket which name is given as argument to STANDBY position.", alias="moveSocketToStandby", timeout=50000)
    public void rotateSocketToStandby(String socketName) {
        FcsUtils.checkSocketName(socketName);
        CarouselSocket socketToMove = this.socketsMap.get(socketName);
        if (!socketToMove.isAtStandby()) {
            int requiredPosition = socketToMove.getStandbyPosition();
            if (this.position != requiredPosition) {
                FCSLOG.info((Object)(this.name + " is at position: " + this.position + "; about to rotate to position: " + requiredPosition));
                this.rotateToAbsolutePosition(requiredPosition);
            }
            this.checkDeltaPosition();
        }
        FCSLOG.info((Object)(this.name + ":" + socketName + " is at STANDBY position on carousel."));
    }

    public void checkDeltaPosition() {
        if (this.socketAtStandby != null) {
            this.socketAtStandby.updateDeltaPosition();
            long deltaPos = this.socketAtStandby.getDeltaPosition();
            if (Math.abs(deltaPos) > (long)this.maxStandbyDeltaPosition) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " delta position at standby is over " + this.maxStandbyDeltaPosition, this.name);
            } else if (Math.abs(deltaPos) > (long)this.minStandbyDeltaPosition) {
                this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " delta position at standby is over " + this.minStandbyDeltaPosition, this.name);
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel full turn. A number of turns can be given as argument.")
    public void rotateFullTurn(double nbTurn) {
        if (Math.abs(nbTurn) > 3.0) {
            throw new IllegalArgumentException("nbTurn=" + nbTurn + " should not be more than 3");
        }
        long timeout = (int)Math.abs(nbTurn) * 2 * this.slowRotationTimeout;
        int rpos = (int)(4362240.0 * nbTurn);
        this.rotateToRelativePosition(rpos, timeout);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        FCSLOG.debug((Object)(this.name + " position=" + this.position));
        this.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.main.updateAgentState(FcsEnumerations.FilterState.valueOf("ROTATING"));
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            this.carouselController.enableAndWriteRelativePosition(this.relativeTargetPosition);
        } else if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            this.carouselController.goToOperationEnable();
            this.carouselController.writeTargetPosition(this.absoluteTargetPosition);
            this.carouselController.writeControlWord(63);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.carouselController.stopPosition();
        this.carouselController.goToSwitchOnDisabled();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        this.carouselController.goToSwitchOnDisabled();
        this.main.updateAgentState(FcsEnumerations.FilterState.valueOf("CAROUSEL_STOPPED"));
        this.setControllerPositionSensorTypeEncoderSSI();
        this.position = this.carouselController.readPosition();
        this.initializeClampsState();
        this.updateStateWithSensors();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.carouselController.stopPosition();
        this.carouselController.goToSwitchOnDisabled();
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isNotHoldingFilter() {
        return !this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isAtHandoff() {
        return false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the ID of filter at STANDBY")
    public int getFilterID() {
        return this.socketAtStandby.getFilterID();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read sensors and update state", timeout=2000)
    public void updateStateWithSensors() {
        long cmdBeginTime = System.currentTimeMillis();
        this.hyttc580.checkBooted();
        if (!this.clampsStateInitialized) {
            throw new FcsHardwareException(this.name + ": clamps state not initialized.  Please launch command initializeClampsState.");
        }
        this.tcpProxy.updatePDOData();
        this.updateState();
        this.readAndUpdateOutputInterlocks();
        long duration = System.currentTimeMillis() - cmdBeginTime;
        FCSLOG.info((Object)(this.name + " updateStateWithSensors duration = " + duration));
        this.publishData();
    }

    @Override
    public boolean isAtOnline() {
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update socket at standby state from hyttc580 data.", timeout=2000)
    public void updateSocketAtStandbyWithSensors() {
        long cmdBeginTime = System.currentTimeMillis();
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        this.tcpProxy.updatePDOData();
        long duration = System.currentTimeMillis() - cmdBeginTime;
        FCSLOG.info((Object)(this.name + " hyttc580.updateFromPDO(tcpProxy.updatePDOData()) duration = " + duration));
        this.updateSocketAtStandbyState();
        duration = System.currentTimeMillis() - cmdBeginTime;
        FCSLOG.info((Object)(this.name + " updateStateWithSensorsAtStandby duration = " + duration));
    }

    public void updateSocketAtStandbyState() {
        long cmdBeginTime = System.currentTimeMillis();
        this.socketAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo1());
        if (this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5) {
            this.socketAtStandby = this.socketsMap.get("socket" + this.socketAtStandbyID);
            this.socketAtStandby.updateState();
            this.socketAtStandby.updateFilterID();
        }
        this.publishData();
        long duration = System.currentTimeMillis() - cmdBeginTime;
        FCSLOG.info((Object)(this.name + " updateSocketAtStandbyState duration = " + duration));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update state from hyttc580 data.", timeout=2000)
    public void updateState() {
        long cmdBeginTime = System.currentTimeMillis();
        this.updateSocketAtStandbyState();
        this.position = this.carouselController.getPosition();
        this.readCurrent = this.carouselController.getCurrent();
        this.readVelocity = this.carouselController.getVelocity();
        this.subs.getScheduler().schedule(() -> this.updateSocketNotAtStandby(), 0L, TimeUnit.SECONDS);
        long duration = System.currentTimeMillis() - cmdBeginTime;
        FCSLOG.info((Object)(this.name + " updateState duration = " + duration));
    }

    public void updateSocketNotAtStandby() {
        long cmdBeginTime = System.currentTimeMillis();
        short socketNotAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo2());
        if (socketNotAtStandbyID >= 1 && socketNotAtStandbyID <= 5) {
            CarouselSocket socketToUpdate = this.socketsMap.get("socket" + socketNotAtStandbyID);
            socketToUpdate.updateState();
        }
        long duration = System.currentTimeMillis() - cmdBeginTime;
        FCSLOG.info((Object)(this.name + " updateSocketNotAtStandby duration = " + duration));
    }

    public FcsEnumerations.FilterClampState getClampsStateAtStandby() {
        if (this.socketAtStandby == null) {
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        return this.socketAtStandby.getClampsState();
    }

    public boolean isEmptyAtStandby() {
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isEmpty();
    }

    public boolean isUnclampedOnFilterAtStandby() {
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isUnclampedOnFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read on hyttc580 by SDO the outputs to autochanger interlocks CS, CFC, CF0, CF1.", timeout=2000)
    public void readAndUpdateOutputInterlocks() {
        long sdo = this.hyttc580.readInterlocksSDO();
        byte signals = (byte)(sdo >> 8 & 0xFFL);
        byte val = (byte)(signals >> 7 & 1);
        byte nval = (byte)(signals >> 6 & 1);
        this.OUT_CS = val == 1;
        this.OUT_CS_InError = val == nval;
        val = (byte)(signals >> 5 & 1);
        nval = (byte)(signals >> 4 & 1);
        this.OUT_CFC = val == 1;
        this.OUT_CFC_InError = val == nval;
        val = (byte)(signals >> 3 & 1);
        nval = (byte)(signals >> 2 & 1);
        this.OUT_CF1 = val == 1;
        this.OUT_CF1_InError = val == nval;
        val = (byte)(signals >> 1 & 1);
        nval = (byte)(signals & 1);
        this.OUT_CF0 = val == 1;
        this.OUT_CF0_InError = val == nval;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read on pt100 the temperatures", timeout=2000)
    public void readTemperatures() {
        this.pt100.updateTemperatures();
    }
}

