/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import java.util.StringTokenizer;
import ndr.NdrBuffer;
import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import rpc.core.UUID;

public class PresentationSyntax
extends NdrObject {
    private static final int UUID_INDEX = 0;
    private static final int VERSION_INDEX = 1;
    UUID uuid;
    int version;

    public PresentationSyntax() {
    }

    public PresentationSyntax(String syntax) {
        this();
        this.parse(syntax);
    }

    public PresentationSyntax(UUID uuid, int majorVersion, int minorVersion) {
        this();
        this.setUuid(uuid);
        this.setVersion(majorVersion, minorVersion);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getMajorVersion() {
        return this.version & 0xFFFF;
    }

    public int getMinorVersion() {
        return this.version >> 16 & 0xFFFF;
    }

    public void setVersion(int majorVersion, int minorVersion) {
        this.setVersion(majorVersion & 0xFFFF | minorVersion << 16);
    }

    @Override
    public void encode(NetworkDataRepresentation ndr, NdrBuffer dst) throws NdrException {
        this.uuid.encode(ndr, dst);
        dst.enc_ndr_long(this.version);
    }

    @Override
    public void decode(NetworkDataRepresentation ndr, NdrBuffer src) throws NdrException {
        this.uuid = new UUID();
        this.uuid.decode(ndr, src);
        this.version = src.dec_ndr_long();
    }

    public String toString() {
        return this.getUuid().toString() + ":" + this.getMajorVersion() + "." + this.getMinorVersion();
    }

    public void parse(String syntax) {
        StringTokenizer tokenizer = new StringTokenizer(syntax, ":.");
        this.uuid = new UUID();
        this.uuid.parse(tokenizer.nextToken());
        this.setVersion(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()));
    }
}

