import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.SimDevice;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-hxtest"]

builder.main (Subscale, argMap("main", 10000, 1000, 0,
                               ["CmprLine1", "CmprLine2"],
                               ["LoadLine1", "LoadLine2"], null, [],
                               ["LoadTemp"], null)) {

    TempCtrl   (TempControl, argMap(10, 1000, 120, 100, 4, 0, 0.05, 30000))

    Sim        (SimDevice, argMap("LoadTemp", "LoadPower"))

    Power      (SimDevice.Power)

    CmprLine1  (Line, argMap("Sim", 0, null, 0))

    CmprLine2  (Line, argMap("Sim", 1, null, 0))

    LoadLine1  (Line, argMap("Sim", 2, null, 0))

    LoadLine2  (Line, argMap("Sim", 3, null, 0))

    AlarmCmpr  (Alarm, argMap("Trips off all power", null, 0))

    AlarmLoad  (Alarm, argMap("Turns off load power", null, 1))

    CmprPower  (Channel,
                argMap("Compressor\\Power", "Watts",
                       "Sim", 0, "POWER", "1200: 0: 0: 0", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "alarm", 0.0, 0.0, "AlarmCmpr"))

    CmpDisPrs  (Channel,
                argMap("Discharge pressure", "Psig",
                       "Sim", 1, "VOLTS", "400: 10: 0: 20", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "alarm", 0.0, 0.0, "AlarmCmpr"))

    CmpSucPrs  (Channel,
                argMap("Suction pressure", "Psig",
                       "Sim", 2, "VOLTS", "400: 10: 0: 20", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    CmpBodyTmp (Channel,
                argMap("Body temperature", "\u00b0C",
                       "Sim", 3, "TEMP", "100: 60: 25: 300", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "alarm", 0.0, 0.0, "AlarmCmpr"))

    CmpDisTmp  (Channel,
                argMap("Discharge temperature", "\u00b0C",
                       "Sim", 4, "TEMP", "120: 60: 25: 300", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "alarm", 0.0, 0.0, "AlarmCmpr"))

    CmpRetnTmp (Channel,
                argMap("C1 oil temperature", "\u00b0C",
                       "Sim", 5, "TEMP", "-10: 1800: 25: 3600", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    CmpSepTmp  (Channel,
                argMap("Separator temperature", "\u00b0C",
                       "Sim", 6, "TEMP", "-5: 1800: 25: 3600", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    CmpFlowSwi (Channel,
                argMap("Flow switch state", ".0f", "",
                       "Sim", 7, "SWITCH", "1: 0: 0: 0", 0, 1,
                       "flag", 1.0, 0, null,
                       "flag", 1.0, 0, null))

    CmpTmpRly  (Channel,
                argMap("Temperature relay state", ".0f", "",
                       "Sim", 8, "SWITCH", "1: 0: 0: 0", 0, 1,
                       "flag", 1.0, 0, null,
                       "flag", 1.0, 0, null))

    C3LiqdTmp  (Channel,
                argMap("Heat Exchanger\\C3 liq capillary temperature",
                       "\u00b0C",
                       "Sim", 9, "TEMP", "-60: 1800: 25: 3600", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    PreC4Tmp   (Channel,
                argMap("Pre C4 temperature", "\u00b0C",
                       "Sim", 10, "TEMP", "-100: 1800: 25: 3600", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    PostC4Tmp  (Channel,
                argMap("Post C4 temperature", "\u00b0C",
                       "Sim", 11, "TEMP", "-125: 1800: 25: 3600", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    HexVapPrs  (Channel,
                argMap("Vapor supply pressure", "Psig",
                       "Sim", 12, "VOLTS", "400: 10: 0: 20", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "alarm", 0.0, 0.0, "AlarmCmpr"))

    HexLiqPrs  (Channel,
                argMap("Liquid supply pressure", "Psig",
                       "Sim", 13, "VOLTS", "405: 10: 0: 20", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "alarm", 0.0, 0.0, "AlarmCmpr"))

    HexPrsDiff (Channel,
                argMap("Vapor/liquid delta P", "Psi",
                       null, 0, "DIFF", "HexLiqPrs:HexVapPrs", 0, 0,
                       "none", 0.0, 0.0, null,
                       "none", 0.0, 0.0, null))

    HexSucPrs  (Channel,
                argMap("Return pressure", "Psig",
                       "Sim", 14, "VOLTS", "100: 10: 0: 20", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    HexExitTmp (Channel,
                argMap("Return temperature", "\u00b0C",
                       "Sim", 15, "TEMP", "-122: 1800: 25: 3600", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    LoadTemp   (Channel,
                argMap("Load temperature RTD", "\u00b0C",
                       "Sim", 16, "TEMP", "-120: 1800: 25: 3600", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    LoadPower  (Channel,
                argMap("Heat load power", "Watts",
                       "Sim", 17, "POWER", "0: 0: 0: 0", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    AmbientTmp (Channel,
                argMap("Ambient temperature", "\u00b0C",
                       "Sim", 18, "TEMP", "25: 0: 25: 0", 0, 1,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    Running    (Channel,
                argMap("Control Chassis\\Running state", ".0f", "",
                       "Sim", 19, "SWITCH", "1: 0: 0: 0", 0, 1,
                       "flag", 1.0, 0, null,
                       "flag", 1.0, 0, null))

    Interlock  (Channel,
                argMap("Interlock state", ".0f", "",
                       "Sim", 20, "SWITCH", "1: 0: 0: 0", 0, 1,
                       "flag", 1.0, 0, null,
                       "flag", 1.0, 0, null))

    ThermRelay (Channel,
                argMap("Thermal relay state", ".0f", "",
                       "Sim", 21, "SWITCH", "1: 0: 1: 0", 0, 1,
                       "flag", 1.0, 0, null,
                       "flag", 1.0, 0, null))

    LoadEnable (Channel,
                argMap("Load enable state", ".0f", "",
                       "Sim", 22, "SWITCH", "1: 0: 0: 0", 0, 1,
                       "flag", 1.0, 0, null,
                       "flag", 1.0, 0, null))

    V5Power    (Channel,
                argMap("5-Volt power state", ".0f", "",
                       "Sim", 23, "SWITCH", "1: 0: 1: 0", 0, 1,
                       "flag", 1.0, 0, null,
                       "flag", 1.0, 0, null))
}
