/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.dcom.da.impl;

import java.util.LinkedList;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JILocalCoClass;
import org.jinterop.dcom.core.JILocalInterfaceDefinition;
import org.jinterop.dcom.core.JILocalMethodDescriptor;
import org.jinterop.dcom.core.JILocalParamsDescriptor;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIVariant;
import org.openscada.opc.dcom.common.FILETIME;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.common.Result;
import org.openscada.opc.dcom.common.ResultSet;
import org.openscada.opc.dcom.common.impl.EventHandlerImpl;
import org.openscada.opc.dcom.da.IOPCDataCallback;
import org.openscada.opc.dcom.da.ValueData;

public class OPCDataCallback
extends EventHandlerImpl {
    private IOPCDataCallback callback = null;
    private JILocalCoClass coClass = null;

    public Object[] OnDataChange(int transactionId, int serverGroupHandle, int masterQuality, int masterErrorCode, int count, JIArray clientHandles, JIArray values, JIArray qualities, JIArray timestamps, JIArray errors) {
        IOPCDataCallback callback = this.callback;
        if (callback == null) {
            return new Object[]{0};
        }
        Integer[] errorCodes = (Integer[])errors.getArrayInstance();
        Integer[] itemHandles = (Integer[])clientHandles.getArrayInstance();
        Short[] qualitiesArray = (Short[])qualities.getArrayInstance();
        JIVariant[] valuesArray = (JIVariant[])values.getArrayInstance();
        JIStruct[] timestampArray = (JIStruct[])timestamps.getArrayInstance();
        KeyedResultSet<Integer, ValueData> result = new KeyedResultSet<Integer, ValueData>();
        for (int i = 0; i < count; ++i) {
            ValueData vd = new ValueData();
            vd.setQuality(qualitiesArray[i]);
            vd.setTimestamp(FILETIME.fromStruct(timestampArray[i]).asCalendar());
            vd.setValue(valuesArray[i]);
            result.add(new KeyedResult<Integer, ValueData>(itemHandles[i], vd, errorCodes[i]));
        }
        try {
            callback.dataChange(transactionId, serverGroupHandle, masterQuality, masterErrorCode, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new Object[]{0};
    }

    public synchronized Object[] OnReadComplete(int transactionId, int serverGroupHandle, int masterQuality, int masterErrorCode, int count, JIArray clientHandles, JIArray values, JIArray qualities, JIArray timestamps, JIArray errors) {
        if (this.callback == null) {
            return new Object[]{0};
        }
        Integer[] errorCodes = (Integer[])errors.getArrayInstance();
        Integer[] itemHandles = (Integer[])clientHandles.getArrayInstance();
        Short[] qualitiesArray = (Short[])qualities.getArrayInstance();
        JIVariant[] valuesArray = (JIVariant[])values.getArrayInstance();
        JIStruct[] timestampArray = (JIStruct[])timestamps.getArrayInstance();
        KeyedResultSet<Integer, ValueData> result = new KeyedResultSet<Integer, ValueData>();
        for (int i = 0; i < count; ++i) {
            ValueData vd = new ValueData();
            vd.setQuality(qualitiesArray[i]);
            vd.setTimestamp(FILETIME.fromStruct(timestampArray[i]).asCalendar());
            vd.setValue(valuesArray[i]);
            result.add(new KeyedResult<Integer, ValueData>(itemHandles[i], vd, errorCodes[i]));
        }
        try {
            this.callback.readComplete(transactionId, serverGroupHandle, masterQuality, masterErrorCode, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new Object[]{0};
    }

    public synchronized Object[] OnWriteComplete(int transactionId, int serverGroupHandle, int masterErrorCode, int count, JIArray clientHandles, JIArray errors) {
        if (this.callback == null) {
            return new Object[]{0};
        }
        Integer[] errorCodes = (Integer[])errors.getArrayInstance();
        Integer[] itemHandles = (Integer[])clientHandles.getArrayInstance();
        ResultSet<Integer> result = new ResultSet<Integer>();
        for (int i = 0; i < count; ++i) {
            result.add(new Result<Integer>(itemHandles[i], errorCodes[i]));
        }
        try {
            this.callback.writeComplete(transactionId, serverGroupHandle, masterErrorCode, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new Object[]{0};
    }

    public synchronized Object[] OnCancelComplete(int transactionId, int serverGroupHandle) {
        if (this.callback == null) {
            return new Object[]{0};
        }
        this.callback.cancelComplete(transactionId, serverGroupHandle);
        return new Object[]{0};
    }

    public synchronized JILocalCoClass getCoClass() throws JIException {
        if (this.coClass != null) {
            return this.coClass;
        }
        this.coClass = new JILocalCoClass(new JILocalInterfaceDefinition("39C13A70-011E-11D0-9675-0020AFD8ADB3", false), this, false);
        JILocalParamsDescriptor params = new JILocalParamsDescriptor();
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsObject(new JIArray(Integer.class, null, 1, true), 0);
        params.addInParamAsObject(new JIArray(JIVariant.class, null, 1, true), 0);
        params.addInParamAsObject(new JIArray(Short.class, null, 1, true), 0);
        params.addInParamAsObject(new JIArray(FILETIME.getStruct(), null, 1, true), 0);
        params.addInParamAsObject(new JIArray(Integer.class, null, 1, true), 0);
        JILocalMethodDescriptor method = new JILocalMethodDescriptor("OnDataChange", params);
        this.coClass.getInterfaceDefinition().addMethodDescriptor(method);
        params = new JILocalParamsDescriptor();
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsObject(new JIArray(Integer.class, null, 1, true), 0);
        params.addInParamAsObject(new JIArray(JIVariant.class, null, 1, true), 0);
        params.addInParamAsObject(new JIArray(Short.class, null, 1, true), 0);
        params.addInParamAsObject(new JIArray(FILETIME.getStruct(), null, 1, true), 0);
        params.addInParamAsObject(new JIArray(Integer.class, null, 1, true), 0);
        method = new JILocalMethodDescriptor("OnReadComplete", params);
        this.coClass.getInterfaceDefinition().addMethodDescriptor(method);
        params = new JILocalParamsDescriptor();
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsObject(new JIArray(Integer.class, null, 1, true), 0);
        params.addInParamAsObject(new JIArray(Integer.class, null, 1, true), 0);
        method = new JILocalMethodDescriptor("OnWriteComplete", params);
        this.coClass.getInterfaceDefinition().addMethodDescriptor(method);
        params = new JILocalParamsDescriptor();
        params.addInParamAsType(Integer.class, 0);
        params.addInParamAsType(Integer.class, 0);
        method = new JILocalMethodDescriptor("OnCancelComplete", params);
        this.coClass.getInterfaceDefinition().addMethodDescriptor(method);
        LinkedList<String> eventInterfaces = new LinkedList<String>();
        eventInterfaces.add("39C13A70-011E-11D0-9675-0020AFD8ADB3");
        this.coClass.setSupportedEventInterfaces(eventInterfaces);
        return this.coClass;
    }

    public void setCallback(IOPCDataCallback callback) {
        this.callback = callback;
    }

    public IOPCDataCallback getCallback() {
        return this.callback;
    }
}

