/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class Scheduler {
    private final AtomicReference<ScheduledExecutorService> hwExec;
    private final AtomicReference<ScheduledExecutorService> monitorExec;
    private final List<ScheduledFuture<?>> hwTasks;
    private final AtomicReference<ScheduledFuture<?>> monitorTask;
    private final BlockingQueue<Runnable> alphaQueue;
    private final int ALPHA_QUEUE_MAX = 1000;
    private final Duration ALPHA_TASK_PERIOD = Duration.ofMillis(100L);
    private final Duration MONITOR_TASK_PERIOD = Duration.ofMillis(100L);
    private final Duration BETA_TASK_PERIOD = Duration.ofMillis(1000L);

    public Scheduler() {
        this.hwExec = new AtomicReference();
        this.monitorExec = new AtomicReference();
        this.hwTasks = new CopyOnWriteArrayList();
        this.monitorTask = new AtomicReference();
        this.alphaQueue = new ArrayBlockingQueue<Runnable>(1000);
    }

    private void startScheduling() {
        this.hwExec.set(Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "hardware-thread")));
        this.monitorExec.set(Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "monitor-thread")));
        this.hwTasks.clear();
        this.alphaQueue.clear();
        this.monitorTask.set(this.monitorExec.get().scheduleWithFixedDelay(this::monitorTaskBody, 0L, this.MONITOR_TASK_PERIOD.toMillis(), TimeUnit.MILLISECONDS));
        this.hwTasks.add(this.hwExec.get().scheduleWithFixedDelay(this::alphaTaskBody, 0L, this.ALPHA_TASK_PERIOD.toMillis(), TimeUnit.MILLISECONDS));
        this.hwTasks.add(this.hwExec.get().scheduleWithFixedDelay(this::betaTaskBody, 0L, this.BETA_TASK_PERIOD.toMillis(), TimeUnit.MILLISECONDS));
    }

    private void stopScheduling() {
        this.hwExec.get().shutdownNow();
        this.monitorTask.get().cancel(false);
        this.monitorExec.get().shutdown();
    }

    private void monitorTaskBody() {
    }

    private void alphaTaskBody() {
    }

    private void betaTaskBody() {
    }
}

