/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.motorplatform.bot.Ensemble;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ShellCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.LampStatus;
import org.lsst.ccs.utilities.logging.Logger;

public class BOTMain
extends Subsystem
implements MotorCommandListener,
ShellCommandListener,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger((String)BOTMain.class.getName());
    private ExecutorService publisher;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Ensemble controller;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final Map<String, AxisStatus> lastAxisStatus;
    private final AtomicReference<ControllerStatus> lastControllerStatus;
    private final AtomicReference<PlatformConfig> platformConfiguration;
    private final AtomicReference<LampStatus> lastLampStatus;
    private boolean haveLampOffsets;

    BOTMain() {
        super("bot", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        this.lastAxisStatus = new ConcurrentHashMap<String, AxisStatus>(3);
        this.lastControllerStatus = new AtomicReference();
        this.platformConfiguration = new AtomicReference();
        this.lastLampStatus = new AtomicReference();
        this.haveLampOffsets = false;
    }

    private void publishOrPerish(Ensemble ctrl, Subsystem subsys, ExecutorService exec) {
        try {
            KeyValueData result = ctrl.getNextResult();
            if (result.getValue().getClass() == AxisStatus.class) {
                AxisStatus status = (AxisStatus)result.getValue();
                this.lastAxisStatus.put(status.getAxisName().toUpperCase(), status);
            } else if (result.getValue().getClass() == ControllerStatus.class) {
                this.lastControllerStatus.set((ControllerStatus)result.getValue());
            } else if (result.getValue().getClass() == LampStatus.class) {
                this.lastLampStatus.set((LampStatus)result.getValue());
            }
            subsys.publishSubsystemDataOnStatusBus(result);
            exec.submit(() -> this.publishOrPerish(ctrl, subsys, exec));
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public void postInit() {
        ((AgentPropertiesService)this.getAgentService(AgentPropertiesService.class)).setAgentProperty("motorplatform.type", MotorplatformType.BOT.name());
    }

    public void postStart() {
        this.platformConfiguration.set(this.controller.getConfiguration());
        this.publisher = Executors.newSingleThreadExecutor();
        Ensemble ctrl = this.controller;
        BOTMain subsys = this;
        ExecutorService exec = this.publisher;
        exec.submit(() -> this.publishOrPerish(ctrl, subsys, exec));
    }

    public void shutdown() {
        this.publisher.shutdownNow();
    }

    @Command(description="(GUI/Jython) Enables or disables an axis.")
    public void changeAxisEnable(@Argument(name="cmd", description="An instance of ChangeAxisEnable.") ChangeAxisEnable cmd) {
        this.controller.changeAxisEnable(cmd);
    }

    @Command(description="(GUI/Jython) Change a motor controller output line state.")
    public void changeOutputLine(@Argument(name="cmd", description=")An instance of ChangeOutputLine.") ChangeOutputLine cmd) {
        this.controller.changeOutputLine(cmd);
    }

    @Command(description="(GUI/Jython) Attempt to clear all extant faults, general and axis.")
    public void clearAllFaults(@Argument(name="cmd", description="An instance of ClearAllFaults.") ClearAllFaults cmd) {
        this.controller.clearAllFaults(cmd);
    }

    @Command(description="(GUI/Jython) Attempt to clear the faults on a specific axis.")
    public void clearAxisFaults(@Argument(name="cmd", description="An instance of ClearAxisFaults.") ClearAxisFaults cmd) {
        this.controller.clearAxisFaults(cmd);
    }

    @Command(description="(GUI/Jython) Turn off data capture for subsequent motions.")
    public void clearCapture(@Argument(name="cmd", description="An instance of ClearCapture.") ClearCapture cmd) {
        this.controller.clearCapture(cmd);
    }

    @Command(description="(GUI/Jython) Enable the X and Y axes.")
    public void enableAllAxes(@Argument(name="cmd", description="An instance of EnableAllExes.") EnableAllAxes cmd) {
        this.controller.enableAllAxes(cmd);
    }

    @Command(description="(GUI/Jython) Move the axis to its low-end limit switch and set the axis position to zero.")
    public void homeAxis(@Argument(name="cmd", description="An instance of HomeAxis.") HomeAxis cmd) {
        this.controller.homeAxis(cmd);
    }

    @Command(description="(GUI/Jython) Change the axis position by the given amount in the given time.")
    public void moveAxisRelative(@Argument(name="cmd", description="An instance of MoveAxisRelative.") MoveAxisRelative cmd) {
        this.controller.moveAxisRelative(cmd);
    }

    @Command(description="(GUI/Jython) Move the axis to an absolute position at a given speed.")
    public void moveAxisAbsolute(@Argument(name="cmd", description="An instance of MoveAxisAbsolute.") MoveAxisAbsolute cmd) {
        this.controller.moveAxisAbsolute(cmd);
    }

    @Command(level=0, description="(GUI/Jython) Send an axis report on the status bus.")
    public void sendAxisStatus(@Argument(name="cmd", description="An instance of SendAxisStatus.") SendAxisStatus cmd) {
        this.controller.sendAxisStatus(cmd);
    }

    @Command(level=0, description="(GUI/Jython) Send the platform configuration on the status bus.")
    public void sendConfiguration(@Argument(name="cmd", description="An instance of SendConfiguration.") SendConfiguration cmd) {
        this.controller.sendConfiguration(cmd);
    }

    @Command(level=0, description="(GUI/Jython) Send a controller report on the status bus.")
    public void sendControllerStatus(@Argument(name="cmd", description="An instance of SendControllerStatus.") SendControllerStatus cmd) {
        this.controller.sendControllerStatus(cmd);
    }

    @Command(description="(GUI/Jython) Set up data capture for subsequent moves.")
    public void setupCapture(@Argument(name="cmd", description="An instance of SetupCapture.") SetupCapture cmd) {
        this.controller.setupCapture(cmd);
    }

    @Command(description="(GUI/Jython) Kill all motion on the platform.")
    public void stopAllMotion(@Argument(name="cmd", description="An instance of StopAllMotion.") StopAllMotion cmd) {
        this.controller.stopAllMotion(cmd);
    }

    @Command(description="(Shell) Clear all axis and global controller faults.")
    public void clearFaults() {
        this.controller.clearAllFaults(new ClearAllFaults());
    }

    @Command(description="(Shell) Stop motion on all axes and discard queued commands.")
    public void stopAll() {
        this.controller.stopAllMotion(new StopAllMotion());
    }

    @Command(description="(Shell) Enable an axis.")
    public void enable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), true));
    }

    @Command(description="(Shell) Disable an axis.")
    public void disable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), false));
    }

    @Command(description="(Shell) Send an axis to its home position.")
    public void home(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.homeAxis(new HomeAxis(this.checkAxis(axisName)));
    }

    @Command(description="(Shell) Move an axis to a new absolute position.")
    public void moveTo(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="newPosition", description="The target position in mm.") double newPosition, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        this.controller.moveAxisAbsolute(new MoveAxisAbsolute(this.checkAxis(axisName), newPosition, speed));
    }

    @Command(description="(Shell) Move an axis by a given amount from the position at the start of command execution.")
    public void moveBy(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="positionChange", description="The desired coordinate change in mm.") double positionChange, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        double time = Math.abs(positionChange) / speed;
        this.controller.moveAxisRelative(new MoveAxisRelative(this.checkAxis(axisName), positionChange, Duration.ofMillis((long)(1000.0 * time))));
    }

    @Command(level=0, description="(Shell) Get a short status report for an axis.")
    public String status(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("Controller motion enable: %s%n");
        buff.append("Controller comm link: %s%n");
        buff.append("Axis %s%n");
        buff.append("Enabled %s, Moving %s, At Home %s, At Low %s, At High %s%n");
        buff.append("Position %6.1f%n");
        ControllerStatus ctlstat = this.lastControllerStatus.get();
        AxisStatus axstat = this.lastAxisStatus.get(this.checkAxis(axisName));
        if (ctlstat == null || axstat == null) {
            return "Not yet available.";
        }
        for (String fault : axstat.getFaults()) {
            buff.append(fault);
            buff.append("%n");
        }
        return String.format(buff.toString(), ctlstat.isMotionEnabled(), ctlstat.getCommLinkStatus(), axstat.getAxisName(), axstat.isEnabled(), axstat.isMoving(), axstat.isAtHome(), axstat.isAtLowLimit(), axstat.isAtHighLimit(), axstat.getPosition());
    }

    private String checkAxis(String axisName) {
        List legalNames = this.platformConfiguration.get().getAxisNames();
        Optional<String> match = legalNames.stream().filter(x -> x.equalsIgnoreCase(axisName)).findAny();
        if (match.isPresent()) {
            return match.get();
        }
        throw new IllegalArgumentException(String.format("Invalid axis name %s. The legal set is {%s}.", axisName, legalNames.stream().collect(Collectors.joining(", "))));
    }

    @Command(autoAck=false, description="Move the light source to the given position.")
    public void setLampPosition(@Argument(description="The position X in camera coords (mm).") double xcam, @Argument(description="The position Y in camera coords (mm).") double ycam) {
        if (!this.haveLampOffsets) {
            LOG.warning((Object)"Must set light source offsets before moving the source.");
            this.alertService.raiseAlert(this.newOffsetAlert(), AlertState.WARNING, "");
            this.sendNack((Serializable)((Object)"Haven't received lamp offset"));
            return;
        }
        LampStatus stat = this.lastLampStatus.get();
        if (stat == null || stat.isMoving()) {
            this.sendNack((Serializable)((Object)"Motion already in progress"));
            return;
        }
        this.controller.setLampPosition(xcam, ycam);
        this.sendAck(null);
    }

    @Command(description="Set offset of lamp center from stage position (BOT coordinates).")
    public void setLampOffset(@Argument(description="The X offset (mm).") double xoff_ls, @Argument(description="The Y offset (mm).") double yoff_ls) {
        this.haveLampOffsets = true;
        LOG.info((Object)String.format("Received lamp offsets (%s, %s).", xoff_ls, yoff_ls));
        this.alertService.raiseAlert(this.newOffsetAlert(), AlertState.NOMINAL, "");
        this.controller.setLampOffset(xoff_ls, yoff_ls);
    }

    private Alert newOffsetAlert() {
        return new Alert("NO_LAMP_OFFSET", "Lamp offset not set before calling setLampPosition()");
    }

    @Command(type=Command.CommandType.QUERY, description="Get lamp config. as a Map.")
    public Map<String, Double> getLampParameters() {
        return this.controller.getLampParameters();
    }

    @Command(type=Command.CommandType.QUERY, description="Print the latest LampStatus.")
    public String lampStatus() {
        Map<String, Double> parms = this.controller.getLampParameters();
        StringBuilder buf = new StringBuilder();
        for (String key : parms.keySet()) {
            buf.append(key);
            buf.append(": ");
            buf.append(parms.get(key));
            buf.append("\n");
        }
        LampStatus status = this.lastLampStatus.get();
        if (status == null) {
            buf.append("Lamp position not yet available.\n");
        } else {
            buf.append("xcam: ");
            buf.append(status.getXcam());
            buf.append("\nycam: ");
            buf.append(status.getYcam());
            buf.append("\nxbot: ");
            buf.append(status.getXbot());
            buf.append("\nybot: ");
            buf.append(status.getYbot());
            buf.append("\nisMoving: ");
            buf.append(status.isMoving());
            buf.append("\nhasFault: ");
            buf.append(status.hasFault());
            buf.append("\n");
        }
        return buf.toString();
    }
}

