/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class SimMaq20Device
extends Maq20Device {
    private static final Logger LOG = Logger.getLogger(SimMaq20Device.class.getName());
    private final Map<String, Integer> channelMap = new HashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan >= 100) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
        }
        int index = this.channelValues.size();
        this.channelMap.put(name, index);
        this.channelValues.add(Double.valueOf(index));
        return new int[]{index, 0};
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return this.channelValues.get(type) + 0.2 * (Math.random() - 0.5);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws RefrigException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new RefrigException("Invalid channel name");
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

