/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class TSFluxCalib {
    double MINWL = 300.0;
    double MAXWL = 1200.0;
    double NWLSTEPS = 0.0;
    double MINSW = 6.0;
    double MAXSW = 2000.0;
    double NSWSTEPS = 100.0;
    private double[] swtab = new double[2000];
    private double[] wltab = new double[2000];
    private List[][] swtabary = new List[3000][2];
    private String configFile = System.getProperty("lsst.ccs.teststand.fluxcalfile", "TS3FluxCalData.dat");

    int wl_idx(double wl) {
        int widx = 0;
        while ((double)widx < this.NWLSTEPS && !(wl > this.wltab[widx])) {
            ++widx;
        }
        return widx;
    }

    int sw_idx(double sw) {
        return (int)((sw - this.MINSW) / (this.MAXSW - this.MINSW) * this.NSWSTEPS);
    }

    double grid_wl(int iwl) {
        return this.wltab[iwl];
    }

    double grid_sw(int isw) {
        return (double)isw / this.NSWSTEPS * (this.MAXSW - this.MINSW) + this.MINSW;
    }

    public TSFluxCalib() {
        System.out.println("Flux Calibration File path is " + this.configFile);
        this.TSFluxCalibReader();
    }

    public void setTSFluxCalibFile(String cfgfile) {
        this.configFile = cfgfile;
        System.out.println("Flux Calibration File path is " + this.configFile);
        this.TSFluxCalibReader();
    }

    public void TSFluxCalibReader() {
        System.out.println("TSFluxCalibReader called");
        File cfgFl = new File(this.configFile);
        if (cfgFl.exists()) {
            FileReader fstream = null;
            try {
                fstream = new FileReader(cfgFl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fstream != null) {
                String line = null;
                try {
                    BufferedReader in = new BufferedReader(fstream);
                    boolean istate = false;
                    int iwl = 0;
                    while (in.ready()) {
                        double sw;
                        line = in.readLine();
                        if (line.startsWith("//")) continue;
                        double wl = Double.valueOf(line.split(" ")[0]);
                        this.swtab[iwl] = sw = Double.valueOf(line.split(" ")[1]).doubleValue();
                        this.wltab[iwl] = wl;
                        ++iwl;
                    }
                    this.NWLSTEPS = iwl;
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("File " + this.configFile + " doesn't exist. Use of the slit width calibration will not be possible.");
        }
    }

    public int getRequiredSlitWidth(double wl) {
        double resp = -1.0;
        int iminwlidx = this.wl_idx(wl) - 1 >= 0 ? this.wl_idx(wl) - 1 : 0;
        int imaxwlidx = this.wl_idx(wl) + 1 >= (int)this.NWLSTEPS - 1 ? this.wl_idx(wl) + 1 : (int)this.NWLSTEPS - 1;
        double sw1 = this.swtab[this.wl_idx(wl)];
        double wl1 = wl;
        double sw2 = sw1;
        double wl2 = wl;
        if (this.wl_idx(wl) < imaxwlidx) {
            sw2 = this.swtab[this.wl_idx(wl) + 1];
            wl2 = this.wltab[this.wl_idx(wl) + 1];
        }
        resp = wl2 == wl1 ? sw1 : (wl - wl1) / (wl2 - wl1) * (sw2 - sw1) + sw1;
        return (int)resp;
    }
}

