/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.utilities.logging.Logger;

public class TSConfigCatcher
implements Serializable,
AgentPresenceListener,
StatusMessageListener {
    private static TSConfig tsc = null;
    private AgentMessagingLayer agentMessagingLayer = null;
    private static final Logger LOGGER = Logger.getLogger((String)"org.lsst.ccs.subsystem.teststand.main");
    private static String DEST = "ts";
    private ConcurrentMessagingUtils cmu;

    public TSConfigCatcher() {
    }

    public TSConfigCatcher(TSConfig tsc) {
        TSConfigCatcher.tsc = tsc;
    }

    public void initCatcher(ConfigurationInfo configInfo) {
        this.agentMessagingLayer = Agent.getEnvironmentMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        this.agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        Predicate filter = BusMessageFilterFactory.messageOrigin((String)DEST).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, filter);
        this.updateConfig(configInfo);
    }

    public void onStatusMessage(StatusMessage msg) {
        if (msg == null) {
            return;
        }
        ConfigurationInfo configInfo = null;
        if (!(msg.getObject() instanceof ConfigurationInfo)) {
            return;
        }
        configInfo = (ConfigurationInfo)msg.getObject();
        this.updateConfig(configInfo);
    }

    public void updateConfig(ConfigurationInfo configInfo) {
        List listChanges = configInfo.getLatestChanges();
        for (String componentName : TSConfig.COMPONENT_NAMES) {
            Map configForComponent = configInfo.getCurrentValuesFor(componentName);
            if (configForComponent.isEmpty()) continue;
            int istate = TSConfig.operating_states.valueOf((String)componentName).ordinal();
            double biasVAcq = Double.valueOf((String)configForComponent.get("bias"));
            double cryoTAcq = Double.valueOf((String)configForComponent.get("cryo"));
            double cryoTAcqTol = Double.valueOf((String)configForComponent.get("cryotol"));
            double minLmpPwr = Double.valueOf((String)configForComponent.get("minlmppwr"));
            double vacPAcq = Double.valueOf((String)configForComponent.get("vac"));
            double lambdaAcq = Double.valueOf((String)configForComponent.get("lambda"));
            tsc.update(istate, biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
        }
        String componentName = "TSCFG";
        Map configForComponent = configInfo.getCurrentValuesFor(componentName);
        if (!configForComponent.isEmpty()) {
            double[] filter_edges = new double[6];
            String[] filter_names = new String[6];
            for (int i = 0; i < 6; ++i) {
                filter_edges[i] = Double.valueOf((String)configForComponent.get("filteredge" + (i + 1)));
                filter_names[i] = (String)configForComponent.get("filter" + (i + 1));
            }
            tsc.setFilter_edges(filter_edges);
            tsc.setFilter_names(filter_names);
            tsc.setBiastype((String)configForComponent.get("biastype"));
            tsc.setPdtype((String)configForComponent.get("pdtype"));
            tsc.setSrctype((String)configForComponent.get("srctype"));
            tsc.setMonotype((String)configForComponent.get("monotype"));
        }
    }

    public void connecting(AgentInfo agent) {
        System.out.println("Agent name = " + agent.getName());
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        if (!agent.getName().equals(DEST)) {
            return;
        }
        LOGGER.info((Object)"connecting");
        Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
        try {
            ConfigurationInfo configInfo = (ConfigurationInfo)future.get();
            this.updateConfig(configInfo);
            DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
            Predicate filter = BusMessageFilterFactory.messageOrigin((String)DEST).and(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class));
            this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, filter);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"unable to retrieve configuration information", (Throwable)ex);
        }
    }

    public void disconnecting(AgentInfo agent) {
        System.out.println("Agent name = " + agent.getName());
        DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
        if (!agent.getName().equals(DEST)) {
            return;
        }
        LOGGER.info((Object)"disconnecting");
        Future future = this.cmu.sendAsynchronousCommand(new CommandRequest(DEST, "getConfigurationInfo"));
        try {
            DEST = System.getProperty("lsst.ccs.teststand.tsguidest", "ts2");
            this.agentMessagingLayer.removeStatusMessageListener((StatusMessageListener)this);
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"failed to stop listening", (Throwable)ex);
        }
    }
}

