/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.devices.power.distribution.APC7900Device;
import org.lsst.ccs.subsystem.common.devices.vacuum.VQMDevice;
import org.lsst.ccs.subsystem.teststand.AP9630UPSDevice;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.UPSMonitor;
import org.lsst.ccs.subsystem.teststand.data.TS7Outlets;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;
import org.lsst.ccs.utilities.logging.Logger;

public class TS7
extends Subsystem
implements HasLifecycle {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    CryoDevice cryoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VQMDevice vqmDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, APC7900Device> pduDevicesMap = new HashMap<String, APC7900Device>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AP9630UPSDevice upsDevc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService als;
    private final Logger LOGGER = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private TransitionAlgorithm vacuumTransitionAlgorithm;
    private TransitionAlgorithm coldTransitionAlgorithm1;
    private TransitionAlgorithm coldTransitionAlgorithm2;
    private TransitionAlgorithm cryoTransitionAlgorithm;
    private volatile boolean alertResponseEnabled = false;
    private UPSMonitor upsMon;

    public TS7() {
        super("ccfcs", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void postInit() {
        if (this.cryoDevc == null) {
            this.LOGGER.warning((Object)"Cryo device not defined");
        }
        ((AgentPropertiesService)this.getAgentService(AgentPropertiesService.class)).setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TS7.class.getCanonicalName());
        this.upsMon = new UPSMonitor(this, this.upsDevc, this.LOGGER, this.pts, this.als);
    }

    public void build() {
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("ups-timer", () -> this.upsMon.monitorUPS()));
        this.pts.setPeriodicTaskPeriod("ups-timer", Duration.ofSeconds(1L));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU names")
    public List<String> getPduNames() {
        return new ArrayList<String>(this.pduDevicesMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU outlet names")
    public List<String> getOutletNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            for (String outletName : this.pduDevicesMap.get(pduName).getOutletNames()) {
                names.add(pduName + "/" + outletName);
            }
        }
        return names;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the map of PDU outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        HashMap<String, Boolean> states = new HashMap<String, Boolean>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            Map pduStates = this.pduDevicesMap.get(pduName).getOutletOnStateMap();
            for (String outletName : pduStates.keySet()) {
                states.put(pduName + "/" + outletName, (Boolean)pduStates.get(outletName));
            }
        }
        return states;
    }

    @Command(type=Command.CommandType.ACTION, description="Turn Off named outlet")
    public void turnOutletOff(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, false);
    }

    @Command(type=Command.CommandType.ACTION, description="Turn On named outlet")
    public void turnOutletOn(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, true);
    }

    private void changeOutletState(TS7Outlets outlet, boolean on) throws DriverException {
        String outletName = outlet.getOutletName();
        for (APC7900Device pdu : this.pduDevicesMap.values()) {
            if (!pdu.getOutletNames().contains(outletName)) continue;
            if (on) {
                pdu.forceOutletOn(outletName);
            } else {
                pdu.forceOutletOff(outletName);
            }
            return;
        }
        throw new IllegalArgumentException("Could not find device to turn off outlet " + outletName);
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable alert response")
    public void enableAlertResponse(boolean enable) {
        this.alertResponseEnabled = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isAlertResponseEnabled() {
        return this.alertResponseEnabled;
    }
}

