/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Inclinometer;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Autochanger
implements HardwareController,
FilterHolder,
AlertRaiser,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="tcpProxy")
    private BridgeToHardware tcpProxy;
    private final PlutoGatewayInterface plutoGateway;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="filterManager")
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="filterIdentificator")
    protected FilterIdentificator filterIdentificator;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="loaderConnectedSensors")
    private ComplementarySensors loaderConnectedSensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="loaderHoldingFilterSensors")
    private ComplementarySensors loaderHoldingFilterSensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="carouselHoldingFilterSensors")
    private ComplementarySensors carouselHoldingFilterSensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="carouselStoppedAtStandbySensors")
    private ComplementarySensors carouselStoppedAtStandbySensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="carousel_CF0Sensors")
    private ComplementarySensors carousel_CF0Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="carousel_CF1Sensors")
    private ComplementarySensors carousel_CF1Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="OUT_AF0_Sensors")
    private ComplementarySensors OUT_AF0_Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="OUT_AF1_Sensors")
    private ComplementarySensors OUT_AF1_Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="OUT_AF3_Sensors")
    private ComplementarySensors OUT_AF3_Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="OUT_AP1_Sensors")
    private ComplementarySensors OUT_AP1_Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="OUT_AP2_Sensors")
    private ComplementarySensors OUT_AP2_Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="OUT_AP3_Sensors")
    private ComplementarySensors OUT_AP3_Sensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="lpmLinearRail1Status")
    private DigitalSensor lpmLinearRail1Status;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="lpmLinearRail2Status")
    private DigitalSensor lpmLinearRail2Status;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="lpmOnlineClampsStatus")
    private DigitalSensor lpmOnlineClampsStatus;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="lpmLatchesStatus")
    private DigitalSensor lpmLatchesStatus;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="autochangerTrucks")
    private AutochangerTwoTrucks autochangerTrucks;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="latches")
    protected AutochangerTwoLatches latches;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="onlineClamps")
    private AutochangerThreeOnlineClamps onlineClamps;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="loaderPresenceSensors")
    private ComplementarySensors loaderPresenceSensors;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="lockOutSensors")
    private ComplementarySensors lockOutSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="inclinometerXminus")
    private Inclinometer inclinometerXminus;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="inclinometerXplus")
    private Inclinometer inclinometerXplus;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="carousel")
    private FilterHolder carousel;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="loader")
    private FilterHolder loader;
    @ConfigurationParameter(description="time to wait until protection system signals are updated", units="milliseconds", category="autochanger")
    public volatile long timeToUpdateProtectionSystem = 2000L;
    @ConfigurationParameter(description="time to wait between activateBrake and disableOperation for online clamps", units="milliseconds", category="autochanger")
    private volatile int waitTimeForBrakeOC = 20;
    @ConfigurationParameter(description="time to wait between activateBrake and disableOperation for linear rails", units="milliseconds", category="autochanger")
    private volatile int waitTimeForBrakeLR = 20;
    @Persist
    protected int filterOnTrucksID;

    public Autochanger(PlutoGatewayInterface plutoGateway) {
        this.plutoGateway = plutoGateway;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    public int getWaitTimeForBrakeOC() {
        return this.waitTimeForBrakeOC;
    }

    public int getWaitTimeForBrakeLR() {
        return this.waitTimeForBrakeLR;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutoChanger.class, "autochangerGeneral");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if an error has been detected on sensors.")
    public boolean isSensorsInError() {
        return this.latches.isInError() || this.onlineClamps.isInError() || this.autochangerTrucks.isPositionSensorsInError();
    }

    public AutochangerTwoTrucks getAutochangerTrucks() {
        return this.autochangerTrucks;
    }

    public AutochangerThreeOnlineClamps getOnlineClamps() {
        return this.onlineClamps;
    }

    public AutochangerTwoLatches getLatches() {
        return this.latches;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="If autochanger holds a filter, return filterID, else return 0.")
    public int getFilterID() {
        return this.filterOnTrucksID;
    }

    public void setFilterOnTrucksID(int filterOnTrucksID) {
        this.filterOnTrucksID = filterOnTrucksID;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return true if filter with filterID is on AC")
    public boolean isFilterOnAC(int filterID) {
        return this.filterOnTrucksID == filterID && this.filterOnTrucksID != 0;
    }

    public boolean isFilterONLINE(int filterID) {
        return this.isFilterOnAC(filterID) && this.isAtOnline() && this.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="If a filter is in autochanger, return filter name else return NO_FILTER.")
    public String getFilterOnTrucksName() {
        if (this.filterOnTrucksID != 0) {
            return this.filterManager.getFilterNameByID(this.filterOnTrucksID);
        }
        return "NO FILTER";
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected to the camera. This command doesn't read again the sensors.")
    public boolean isLoaderConnected() {
        return this.loaderPresenceSensors.isOn() && !this.loaderPresenceSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carousel is holding the filter at STANDBY position.")
    public boolean isCarouselHoldingFilterAtStandby() {
        return this.carousel.isAtStandby() && this.carousel.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if loader is connected and holding a filter. This command doesn't read again the sensors.")
    public boolean isLoaderHoldingFilterAtHandoff() {
        return this.loader.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized.")
    public boolean isCANDevicesReady() {
        return this.tcpProxy.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized and homing of the controllers is done.")
    public boolean isHardwareReady() {
        return this.tcpProxy.allDevicesBooted() && this.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized.")
    public boolean isInitialized() {
        return this.plutoGateway.isInitialized() && this.autochangerTrucks.isInitialized() && this.latches.isInitialized() && this.onlineClamps.isInitialized();
    }

    public boolean isLinearRailMotionAllowed() {
        return this.lpmLinearRail1Status.isOn() && this.lpmLinearRail2Status.isOn();
    }

    public void waitForProtectionSystemUpdate() {
        this.waitForRailMotionAllowed(this.timeToUpdateProtectionSystem);
    }

    private void waitForRailMotionAllowed(long timeout) {
        long beginTime = System.currentTimeMillis();
        long waitTime = 0L;
        while (!this.isLinearRailMotionAllowed() && waitTime < timeout) {
            FCSCst.FCSLOG.info((Object)(this.name + " waiting for local protection system update. waitTime = " + waitTime));
            FcsUtils.sleep(100, this.name);
            waitTime = System.currentTimeMillis() - beginTime;
            this.plutoGateway.updateValues();
        }
    }

    public void postStart() {
        FCSCst.FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.plutoGateway.isBooted()) {
            this.initializeGateway();
            try {
                this.updateStateWithSensors();
            }
            catch (Exception ex) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't updateStateWithSensors in postStart ", ex);
            }
        } else {
            this.plutoGateway.raiseAlarmIfMissing();
        }
        FCSCst.FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeGateway() {
        try {
            this.plutoGateway.initializeAndCheckHardware();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize gateway", this.plutoGateway.getName(), ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="For end users, for tests and in engineering mode. This command can be used to recover after a missing hardware during fcs startup. For example, when fcs was started before hardware power up. Check all hardware and publish data.", timeout=5000)
    public void initializeHardware() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN initializeHardware"));
        this.tcpProxy.bootProcess();
        try {
            this.postStart();
            this.autochangerTrucks.postStart();
            this.onlineClamps.postStart();
            this.latches.postStart();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " couldn't initialize autochanger", ex);
        }
        FCSCst.FCSLOG.info((Object)(this.name + " END initializeHardware"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Local Protection Module allows linear rails motion.")
    public void checkLinearRailMotionAllowed() {
        if (!this.lpmLinearRail1Status.isOn() || !this.lpmLinearRail2Status.isOn()) {
            throw new RejectedCommandException(this.name + ": linear rails motion NOT allowed by Local Protection Module.");
        }
        FCSCst.FCSLOG.fine((Object)(this.name + ":linear rails motion allowed by Local Protection Module"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Local Protection Module allows latches motion.")
    public void checkLatchMotionAllowed() {
        if (!this.lpmLatchesStatus.isOn()) {
            throw new RejectedCommandException(this.name + ": latches open or close NOT allowed by Local Protection Module.");
        }
        FCSCst.FCSLOG.fine((Object)(this.name + ":latches open or close allowed by Local Protection Module"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Local Protection Module allows online clamps motion.")
    public void checkOnlineClampMotionAllowed() {
        if (!this.lpmOnlineClampsStatus.isOn()) {
            throw new RejectedCommandException(this.name + ": Online clamps open or close NOT allowed by Local Protection Module.");
        }
        FCSCst.FCSLOG.fine((Object)(this.name + ":Online clamps open or close allowed by Local Protection Module"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be opened.")
    public void checkConditionsForOpeningLatches() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for opening latches"));
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError()) {
            throw new FcsHardwareException(this.name + ": latches are in ERROR state - can't unlockClamps latches.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + ": no filter in autochanger - can't open latches.");
        }
        if (!this.autochangerTrucks.isAtStandby() && !this.autochangerTrucks.isAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter but is not at handoff position neither at standby - can't open latches.");
        }
        if (this.autochangerTrucks.isAtStandby()) {
            this.checkConditionsForOpeningLatchesAtStandby();
        } else if (this.autochangerTrucks.isAtHandoff()) {
            this.checkConditionsForOpeningLatchesAtHandoff();
        }
    }

    private void checkLatchesInitialized() {
        if (!this.latches.isInitialized()) {
            throw new RejectedCommandException(this.name + ": latches are not intialized. Please initialize hardware first.");
        }
    }

    private void checkConditionsForOpeningLatchesAtStandby() {
        if (!this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter and is  at STANDBY position but carousel doesn't hold the filter - can't open latches.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " carousel is holding filter at STANDBY => latches can be open safely."));
    }

    private void checkConditionsForOpeningLatchesAtHandoff() {
        if (!this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter and is  at HANDOFF position but loader doesn't hold the filter - can't open latches.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " loader is holding filter at HANDOFF => latches can be open safely."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Autochanger latches can be closed.")
    public void checkConditionsForClosingLatches() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking conditions for closing latches."));
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError()) {
            throw new RejectedCommandException(this.name + ": latches are in ERROR state - can't close latches.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + ": no filter in autochanger - can't close latches.");
        }
        if (!this.autochangerTrucks.isAtStandby() && !this.autochangerTrucks.isAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is not at handoff position neither at standby - can't close latches.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Check and log if actions on online clamps are allowed,throws an exception otherwise.")
    public void checkConditionsForActioningOnlineClamps() {
        if (!this.isAtOnline()) {
            throw new RejectedCommandException(this.name + " actions not allowed on ONLINE clamps when trucks are not at ONLINE.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + " actions not allowed on ONLINE clamps when no filter on trucks.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " autochangerTrucks are at ONLINE, a filter is there : actions are allowed."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if its safe for filters to move autochanger trucks.")
    public void checkFilterSafetyBeforeMotion() {
        String msg = this.name + " can't move trucks because ";
        this.updateStateWithSensors();
        if (this.isSensorsInError()) {
            this.handleSensorsError();
        } else if (this.isEmpty()) {
            FCSCst.FCSLOG.info((Object)(this.name + " trucks are empty - can move"));
        } else {
            if (!this.onlineClamps.isOpened()) {
                throw new RejectedCommandException(this.name + " : a filter is in trucks and ONLINE clamps are NOT OPENED.");
            }
            if (this.isAtStandby()) {
                this.checkFilterSafetyAtStandby(msg);
            } else if (this.autochangerTrucks.isAtHandoff()) {
                FCSCst.FCSLOG.info((Object)(this.name + " : trucks are AT HANDOFF "));
                this.checkFilterSafetyAtHandoff(msg);
            } else if (this.autochangerTrucks.isAtOnline()) {
                FCSCst.FCSLOG.info((Object)(this.name + " : trucks are at ONLINE "));
                this.checkFilterSafetyAtOnline(msg);
            } else {
                if (this.latches.isHoldingFilter() && this.carousel.isHoldingFilter()) {
                    throw new RejectedCommandException(msg + " carousel is holding filter too.");
                }
                if (!this.latches.isHoldingFilter() && !this.carousel.isHoldingFilter()) {
                    throw new RejectedCommandException(msg + " neither autochanger neither carousel is holding filter. Close latches or carousel clamps.");
                }
            }
        }
    }

    private void checkFilterSafetyAtStandby(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "both carousel and autochanger are holding filter at STANDBY");
        }
        if (!this.isHoldingFilter() && !this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "neither carousel nor autochanger are holding filter at STANDBY");
        }
        if (!this.latches.isClosed() && !this.latches.isOpened()) {
            throw new RejectedCommandException(message + " latches must be opened or closed.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " filter safe at STANDBY - can move"));
    }

    private void checkFilterSafetyAtHandoff(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at HANDOFF but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "both loader and autochanger are holding filter at HANDOFF");
        }
        if (!this.isHoldingFilter() && !this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "neither loader nor autochanger are holding filter at HANDOFF");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " filter safe at HANDOFF - can move"));
    }

    private void checkFilterSafetyAtOnline(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at ONLINE but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && !this.onlineClamps.isOpened()) {
            throw new RejectedCommandException(message + "onlineClamps have to be opened on filter at ONLINE - can't move trucks.");
        }
        if (!this.isHoldingFilter() && !this.onlineClamps.isLocked()) {
            throw new RejectedCommandException(message + "neither latches nor onlineClamps are holding filter at ONLINE");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " filter safe at ONLINE - can move"));
    }

    private void handleSensorsError() {
        boolean transientError = false;
        String msg = this.name + " error detected in sensors :";
        if (this.autochangerTrucks.isPositionSensorsInError()) {
            msg = msg + " trucks position sensors";
            transientError = this.autochangerTrucks.isPositionSensorErrorsTransient();
        }
        if (this.latches.isFilterEngagedInError()) {
            boolean bl = transientError = transientError || this.isLatchesErrorTransient();
        }
        if (this.latches.isInError()) {
            msg = msg + " latches sensors";
        }
        if (this.onlineClamps.isInError()) {
            msg = msg + " onlineClamps sensors";
        }
        if (!transientError) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(msg);
        }
        this.raiseWarning(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg + " - can be a transient error. ", this.name);
    }

    private boolean isLatchesErrorTransient() {
        return Math.abs(this.autochangerTrucks.getPosition() - 984000) < 5000;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.plutoGateway.checkInitialized();
        this.plutoGateway.updateValues();
        this.updateState();
        this.updateFilterOnTrucksID();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="update filterOnTrucksID.")
    public void updateFilterOnTrucksID() {
        this.filterOnTrucksID = !this.latches.isEmpty() ? this.filterIdentificator.getFilterId() : 0;
    }

    private void updateState() {
        this.autochangerTrucks.updateState();
        this.latches.updateState();
        this.onlineClamps.updateState();
        this.filterIdentificator.updateFilterId();
        if (this.isAtStandby() && this.carouselStoppedAtStandbySensors.isOn()) {
            this.carousel.updateStateWithSensors();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.isCANDevicesReady() && this.latches.isInitialized() && this.autochangerTrucks.isInitialized() && this.onlineClamps.isInitialized()) {
            this.main.updateFCSStateToReady();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if a filter is in trucks and latches are CLOSED.")
    public boolean isHoldingFilter() {
        return this.latches.isHoldingFilter();
    }

    @Override
    public boolean isNotHoldingFilter() {
        return this.latches.isOpened();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at HANDOFF. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.autochangerTrucks.isAtHandoff();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at STANDBY. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.autochangerTrucks.isAtStandby();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at ONLINE. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.autochangerTrucks.isAtOnline();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks position is around approachStandbyPosition. This command doesn't read again the sensors.")
    public boolean isAtApproachStandbyPosition() {
        return Math.abs(this.autochangerTrucks.getPosition() - this.autochangerTrucks.getApproachStandbyPosition()) < 1000;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.")
    public void goToHandOff() {
        this.autochangerTrucks.goToHandOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() {
        this.autochangerTrucks.goToOnline();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() {
        this.autochangerTrucks.goToStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="goToOnline with filter then adjust position then close and finally lock clamps", autoAck=false, timeout=20000)
    public void moveAndClampFilterOnline() {
        this.autochangerTrucks.moveAndClampFilterOnline();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="go slowly to appproachStandbyPosition ")
    public void moveToApproachStandbyPositionWithLowVelocity() {
        this.autochangerTrucks.moveToApproachStandbyPositionWithLowVelocity();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="go fast to appproachStandbyPosition ")
    public void moveToApproachStandbyPositionWithHighVelocity() {
        this.autochangerTrucks.moveToApproachStandbyPositionWithHighVelocity();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="go fast to appproachOnlinePosition ")
    public void moveToApproachOnlinePositionWithHighVelocity() {
        this.autochangerTrucks.moveToApproachOnlinePositionWithHighVelocity();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="go slowly to appproachOnlinePosition ")
    public void moveToApproachOnlinePositionWithLowVelocity() {
        this.autochangerTrucks.moveToApproachOnlinePositionWithLowVelocity();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="align slave and move empty from approachStandby to Handoff")
    public void alignSlaveAndMoveEmptyFromApproachToHandoff() {
        this.autochangerTrucks.alignSlaveAndMoveEmptyFromApproachToHandoff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move slowly to standby position")
    public void moveToStandbyWithLowVelocity() {
        this.autochangerTrucks.moveToStandbyWithLowVelocity();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move fast to handoff position")
    public void moveToHandoffWithHighVelocity() {
        this.autochangerTrucks.moveToHandoffWithHighVelocity();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move filter to approachPosition with high speed and move to STANDBY with lowSpeed.", autoAck=false, timeout=30000)
    public void moveFilterToStandby() {
        this.autochangerTrucks.moveFilterToStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Align slave controller position to master controller position.", timeout=20000)
    public void alignSlave() {
        this.autochangerTrucks.alignSlave();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity parameter to lowSpeed and slowProfileAcceleration and slowProfileDeceleration")
    public void slowTrucksProfile() {
        this.autochangerTrucks.slowProfile();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity and ProfileAcceleration and ProfileDeceleration parameters to highSpeed")
    public void fastTrucksProfile() {
        this.autochangerTrucks.fastProfile();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Do homing for both  controllers.")
    public void homingTrucks() {
        this.autochangerTrucks.homing();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move to approach position with high velocity then move to STANDBY with low velocity")
    public void dockingAtStandbyPositionWithoutFilter() {
        this.autochangerTrucks.moveToApproachStandbyPositionWithHighVelocity();
        this.autochangerTrucks.moveToStandbyWithLowVelocity();
    }

    public void disableYminus() {
        this.onlineClamps.disableYminus();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latches.")
    public void openLatches() {
        this.latches.open();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latches.")
    public void closeLatches() {
        this.latches.close();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the 3 online clamps in mode PROFILE_POSITION.", timeout=15000)
    public void openClamps() {
        this.onlineClamps.openClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description=" close clamps in mode PROFILE_POSITION for AC1 and AC2", timeout=6000)
    public void closeClamps() {
        this.onlineClamps.closeClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Locks clamps : closed with a strong pressure (high current).", timeout=6000)
    public void lockClamps() {
        this.onlineClamps.lockClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="unlocks clamps : decreases current in controller to decrease pressure.", timeout=15000)
    public void unlockClamps() {
        this.onlineClamps.unlockClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="do homing of the 3 ONLINE clamps : open in CURRENT mode and homing of controller", timeout=6000)
    public void homingClamps() {
        this.onlineClamps.homing();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the autochanger. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return this.latches.isEmpty();
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="grabFilter", description="Move autochanger trucks to STANDBY position, close latches and stay at STANDBY")
    public void grabFilterAtStandby() {
        this.updateState();
        if (!this.latches.isOpened()) {
            throw new RejectedCommandException(this.name + " latches must be open to execute grabFilterAtStandby");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " === About to move empty to standby position ==="));
        this.autochangerTrucks.moveToApproachStandbyPositionWithHighVelocity();
        this.alignSlave();
        this.autochangerTrucks.moveToStandbyEmptyWithLowVelocity();
        FCSCst.FCSLOG.info((Object)(this.name + " ===> filter on AC after moveToStandbyEmptyWithLowVelocity =" + this.filterOnTrucksID + " should be != 0"));
        this.updateFilterOnTrucksID();
        this.latches.close();
        FCSCst.FCSLOG.info((Object)(this.name + ": filter " + this.filterOnTrucksID + " is now on autochanger"));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="open latches then go to approachStandbyPosition with low speed and move to HANDOFF with highSpeed.", timeout=20000, autoAck=false)
    public void moveEmptyFromStandbyToHandoff() {
        if (!this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + "%s : can't open latches if carousel is not holding it.");
        }
        if (this.latches.isClosed()) {
            this.checkConditionsForOpeningLatches();
            this.latches.open();
        }
        this.waitForProtectionSystemUpdate();
        this.autochangerTrucks.moveToApproachStandbyPositionWithLowVelocity();
        this.autochangerTrucks.alignSlaveAndMoveEmptyFromApproachToHandoff();
        this.updateFilterOnTrucksID();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="set a new value for the acquisition frequency of linear rail controllers current in milliseconds.")
    public void setFastAcqRateLinearRails(int rate) {
        this.configurationService.change("acTruckXminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("acTruckXplus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.saveChangesForCategories(new String[]{"timers:fastRails"});
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="set a new value for the acquisition frequency of ONLINE clamps controllers current, in milliseconds.")
    public void setFastAcqRateOnlineClamps(int rate) {
        this.configurationService.change("onlineClampXminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("onlineClampXplus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("onlineClampYminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.saveChangesForCategories(new String[]{"timers:fast"});
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="speed up online clamps current monitoring for the 3 clamps")
    public void increaseCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:fast"});
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="slow down online clamps current monitoring for the 3 clamps")
    public void decreaseCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:slow"});
    }

    public void increaseLinearRailsCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:fastRails"});
    }

    public void decreaseLinearRailsCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:slowRails"});
    }

    private int identifyFilterAtStandby() {
        return this.filterIdentificator.getFilterId();
    }

    public StatusDataPublishedByAutoChanger createStatusDataPublishedByAutoChanger() {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setLoaderConnectedSensorValue(this.loaderConnectedSensors.isOn());
        status.setLoaderConnectedSensorsInError(this.loaderConnectedSensors.isInError());
        status.setLoaderHoldingFilterAtHandoff(this.loaderHoldingFilterSensors.isOn());
        status.setLoaderHoldingFilterAtHandoffInError(this.loaderHoldingFilterSensors.isInError());
        status.setCarouselHoldingFilter(this.carouselHoldingFilterSensors.isOn());
        status.setCarouselHoldingFilterInError(this.carouselHoldingFilterSensors.isInError());
        status.setCarousel_CS(this.carouselStoppedAtStandbySensors.isOn());
        status.setCarousel_CS_InError(this.carouselStoppedAtStandbySensors.isInError());
        status.setCarousel_CF0(this.carousel_CF0Sensors.isOn());
        status.setCarousel_CF0_InError(this.carousel_CF0Sensors.isInError());
        status.setCarousel_CF1(this.carousel_CF1Sensors.isOn());
        status.setCarousel_CF1_InError(this.carousel_CF1Sensors.isInError());
        status.setEnableRailLin1(this.lpmLinearRail1Status.isOn());
        status.setEnableRailLin2(this.lpmLinearRail2Status.isOn());
        status.setEnableClamps(this.lpmOnlineClampsStatus.isOn());
        status.setEnableLatches(this.lpmLatchesStatus.isOn());
        status.setLoaderPresence(this.loaderPresenceSensors.isOn());
        status.setLoaderPresenceInError(this.loaderPresenceSensors.isInError());
        status.setInclinaisonXminus(this.inclinometerXminus.getInclinaison());
        status.setInclinaisonXplus(this.inclinometerXplus.getInclinaison());
        status.setOUT_AF0(this.OUT_AF0_Sensors.isOn());
        status.setOUT_AF1(this.OUT_AF1_Sensors.isOn());
        status.setOUT_AF3(this.OUT_AF3_Sensors.isOn());
        status.setOUT_AP1(this.OUT_AP1_Sensors.isOn());
        status.setOUT_AP2(this.OUT_AP2_Sensors.isOn());
        status.setOUT_AP3(this.OUT_AP3_Sensors.isOn());
        status.setOUT_AF0_InError(this.OUT_AF0_Sensors.isInError());
        status.setOUT_AF1_InError(this.OUT_AF1_Sensors.isInError());
        status.setOUT_AF3_InError(this.OUT_AF3_Sensors.isInError());
        status.setOUT_AP1_InError(this.OUT_AP1_Sensors.isInError());
        status.setOUT_AP2_InError(this.OUT_AP2_Sensors.isInError());
        status.setOUT_AP3_InError(this.OUT_AP3_Sensors.isInError());
        return status;
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData("autochangerGeneral", (Serializable)this.createStatusDataPublishedByAutoChanger()));
    }

    public void lockFilterAtOnline() {
        if (!this.isAtOnline()) {
            throw new FcsHardwareException(this.name + "is not at ONLINE");
        }
        if (this.isEmpty()) {
            throw new FcsHardwareException(this.name + " must be loaded with a filter");
        }
        this.onlineClamps.lockFilterAtOnline();
    }
}

