/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.commons.annotations.scanner.FieldAnnotationScanner;
import org.lsst.ccs.commons.annotations.scanner.ReflectObject;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;

public final class PersistencyService
implements ServiceLifecycle,
HasLifecycle {
    private static final Logger log = Logger.getLogger(PersistencyService.class.getName());
    private final Agent agent;
    private String persistencyFileName;
    private String newPersistencyFileName;
    private final WriterProvider wp;
    private final Map<String, ObjectPersistensyService> objectMap = new HashMap<String, ObjectPersistensyService>();
    private boolean loadAtStartup = false;
    private boolean persistAtShutdown = false;
    private boolean hasBeenInitialized = false;
    @ConfigurationParameter(category="Services", isFinal=true)
    private volatile String persistencyDir = "";

    private PersistencyService(Agent a) {
        this.agent = a;
        this.wp = WriterProvider.getInstance();
    }

    static PersistencyService create(Agent a) {
        PersistencyService sps = new PersistencyService(a);
        FieldAnnotationScanner fas = new FieldAnnotationScanner(Persist.class);
        ComponentLookup lookup = a.getComponentLookup();
        TreeWalkerUtils.proceduralBiWalk(lookup, null, Object.class, (n, o) -> {
            ReflectObject so = fas.scan(o);
            if (so != null) {
                ObjectPersistensyService ops = new ObjectPersistensyService(o);
                ops.fields.putAll(so.getFields());
                sps.objectMap.put(n.getKey(), ops);
            }
        }, null);
        if (sps.objectMap.isEmpty()) {
            return null;
        }
        ArrayList<String> missingVolatile = new ArrayList<String>();
        for (Map.Entry<String, ObjectPersistensyService> objEntry : sps.objectMap.entrySet()) {
            ObjectPersistensyService obj = objEntry.getValue();
            for (Map.Entry field : obj.fields.entrySet()) {
                Field f = (Field)field.getValue();
                boolean isVolatileOrFinal = Modifier.isVolatile(f.getModifiers()) || Modifier.isFinal(f.getModifiers());
                if (isVolatileOrFinal) continue;
                missingVolatile.add(lookup.getComponentNodeForObject(obj.target).getPath() + "/" + f.getName());
            }
        }
        if (missingVolatile.size() > 0) {
            log.log(Level.WARNING, "Fields annotated with Persist must be declared as \"volatile\".\nPlease update your code for the following parameters:\n{0}", missingVolatile);
        }
        lookup.addComponentNodeToLookup(lookup.getTopComponentNode(), new ComponentNode("persistencyService", (Object)sps));
        return sps;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void preStart() {
        this.hasBeenInitialized = true;
        this.persistencyFileName = "persist_" + this.agent.getDescription();
        this.newPersistencyFileName = this.persistencyFileName + "_" + this.agent.getName();
        if (this.loadAtStartup) {
            this.load();
        }
    }

    @Override
    public void shutdown() {
        if (this.persistAtShutdown) {
            this.persistNow();
        }
    }

    public void setAutomatic(boolean loadAtStartup, boolean persistAtShutdown) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("this method can only be called at the intiialization step");
        }
        this.loadAtStartup = loadAtStartup;
        this.persistAtShutdown = persistAtShutdown;
    }

    @Command(description="writes persistent data in local file", category=Command.CommandCategory.SYSTEM)
    public boolean persistNow() {
        PrintWriter printWriter;
        try {
            log.log(Level.FINE, "Persisting to file {0}", this.newPersistencyFileName);
            printWriter = this.wp.getPrintWriter(this.newPersistencyFileName);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "cannot open local persistence file", ex);
            return false;
        }
        for (Map.Entry<String, ObjectPersistensyService> objEntry : this.objectMap.entrySet()) {
            ObjectPersistensyService obj = objEntry.getValue();
            for (Map.Entry field : obj.fields.entrySet()) {
                Field f = (Field)field.getValue();
                try {
                    f.setAccessible(true);
                    Object val = f.get(obj.target);
                    f.setAccessible(false);
                    String strVal = TypeUtils.stringify((Object)val);
                    printWriter.println(objEntry.getKey() + "/" + (String)field.getKey() + " = " + strVal);
                }
                catch (IllegalAccessException ex) {
                    log.log(Level.SEVERE, "cannot persist field : " + objEntry.getKey() + "/" + (String)field.getKey() + " : aborting", ex);
                    return false;
                }
            }
        }
        printWriter.flush();
        printWriter.close();
        return true;
    }

    @Command(description="loads persistent data from local file", category=Command.CommandCategory.SYSTEM)
    public boolean load() {
        Properties props = this.getPersistenceProperties();
        if (props == null) {
            return false;
        }
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            Field f;
            String name = (String)prop.getKey();
            String val = (String)prop.getValue();
            ParameterPath pp = ParameterPath.valueOf((String)name);
            ObjectPersistensyService ops = this.objectMap.get(pp.getComponentName());
            if (ops == null || (f = (Field)ops.fields.get(pp.getParameterName())) == null) continue;
            Object objVal = InputConversionEngine.convertArgToType((String)val, (Type)f.getGenericType());
            try {
                f.setAccessible(true);
                this.reconstructObject(ops.target, objVal, f);
                f.setAccessible(false);
            }
            catch (IllegalAccessException | RuntimeException ex) {
                log.log(Level.SEVERE, "cannot set " + pp, ex);
                return false;
            }
        }
        return true;
    }

    private Properties getPersistenceProperties() {
        Properties res = null;
        try {
            res = this.wp.getProperties(this.newPersistencyFileName);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "could not open persisted data file " + this.newPersistencyFileName, ex);
        }
        if (res == null) {
            try {
                res = this.wp.getProperties(this.persistencyFileName);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "could not open persisted data file " + this.persistencyFileName, ex);
            }
        }
        return res;
    }

    @Command(description="returns true if a local persistence file is present, false otherwise.", category=Command.CommandCategory.SYSTEM)
    public boolean isLocalPersistenceFilePresent() {
        return this.getPersistenceProperties() != null;
    }

    private void reconstructObject(Object target, Object objVal, Field field) throws IllegalAccessException, RuntimeException {
        Object fieldObject = field.get(target);
        if (fieldObject.getClass().isInstance(objVal)) {
            field.set(target, objVal);
        } else if (fieldObject instanceof Map) {
            Map existingMap = (Map)fieldObject;
            existingMap.clear();
            existingMap.putAll((Map)objVal);
        } else if (fieldObject instanceof List) {
            List existingList = (List)fieldObject;
            existingList.clear();
            existingList.addAll((List)objVal);
        } else if (fieldObject instanceof Set) {
            Set existingSet = (Set)fieldObject;
            existingSet.clear();
            existingSet.addAll((Set)objVal);
        } else {
            throw new RuntimeException("Failed to custom fill field " + field.getName() + " of type " + fieldObject.getClass());
        }
    }

    private static class ObjectPersistensyService {
        private final Object target;
        private final Map<String, Field> fields = new HashMap<String, Field>();

        private ObjectPersistensyService(Object obj) {
            this.target = obj;
        }
    }
}

