/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.openscada.opc.lib.da.Server;
import org.openscada.opc.lib.da.ServerStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStateReader {
    private static Logger _log = LoggerFactory.getLogger(ServerStateReader.class);
    private Server _server = null;
    private ScheduledExecutorService _scheduler = null;
    private final List<ServerStateListener> _listeners = new CopyOnWriteArrayList<ServerStateListener>();
    private ScheduledFuture<?> _job = null;

    public ServerStateReader(Server server) {
        this._server = server;
        this._scheduler = this._server.getScheduler();
    }

    public ServerStateReader(Server server, ScheduledExecutorService scheduler) {
        this._server = server;
        this._scheduler = scheduler;
    }

    public synchronized void start() {
        if (this._job != null) {
            return;
        }
        this._job = this._scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ServerStateReader.this.once();
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        this._job.cancel(false);
        this._job = null;
    }

    protected void once() {
        _log.debug("Reading server state");
        OPCSERVERSTATUS state = this._server.getServerState();
        for (ServerStateListener listener : new ArrayList<ServerStateListener>(this._listeners)) {
            listener.stateUpdate(state);
        }
    }

    public void addListener(ServerStateListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(ServerStateListener listener) {
        this._listeners.remove(listener);
    }
}

