/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShutdownManager {
    public static final int PREPARE_SEQUENCE = 0;
    public static final int CLIENT_SEQUENCE = 100;
    public static final int HUB_SEQUENCE = 200;
    private static final ShutdownManager instance_ = new ShutdownManager();
    private static final Logger logger_ = Logger.getLogger("org.astrogrid.samp");
    private final WeakHashMap hookMap_ = new WeakHashMap();

    private ShutdownManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("SAMP Shutdown"){

                public void run() {
                    ShutdownManager.this.doCleanup();
                }
            });
        }
        catch (SecurityException e) {
            logger_.log(Level.WARNING, "Can't add shutdown hook: " + e, e);
        }
    }

    public synchronized void registerHook(Object key, int iseq, Runnable runnable) {
        this.hookMap_.put(key, new Hook(runnable, iseq));
    }

    public synchronized void unregisterHook(Object key) {
        this.hookMap_.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup() {
        Object[] hooks;
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            hooks = this.hookMap_.values().toArray(new Hook[0]);
        }
        Arrays.sort(hooks);
        logger_.info("SAMP shutdown start");
        for (int ih = 0; ih < hooks.length; ++ih) {
            try {
                ((Hook)hooks[ih]).runnable_.run();
                continue;
            }
            catch (RuntimeException e) {
                ShutdownManager.forceLog(logger_, Level.WARNING, "Shutdown hook failure: " + e, e);
            }
        }
        logger_.info("SAMP shutdown end");
    }

    public static ShutdownManager getInstance() {
        return instance_;
    }

    public static void forceLog(Logger logger, Level level, String msg, Throwable error) {
        if (logger.isLoggable(level)) {
            System.err.println(level + ": " + msg);
            if (error != null) {
                error.printStackTrace(System.err);
            }
        }
    }

    private static class Hook
    implements Comparable {
        final Runnable runnable_;
        final int iseq_;

        Hook(Runnable runnable, int iseq) {
            this.runnable_ = runnable;
            this.iseq_ = iseq;
        }

        public int compareTo(Object other) {
            return this.iseq_ - ((Hook)other).iseq_;
        }
    }
}

