/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.subsystem.airwatch.main.AnalogPoint;
import org.lsst.ccs.subsystem.airwatch.main.CounterPoint;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentChannel;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;
import org.lsst.ccs.subsystem.airwatch.main.TrendableDummyRecord;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;

public class DummyInstrument
implements Instrument {
    private final int index;
    private final boolean enabled;
    private final String location;
    private final String shortName;
    private final Instant lastDataTime;
    private final long nops;
    private final Optional<HardwareException> lastExc;
    private final List<TrendableRecord> lastData;

    public DummyInstrument(InstrumentConfig config) {
        this.index = config.index;
        this.enabled = config.working;
        this.location = config.loc;
        this.shortName = config.shortName;
        this.lastDataTime = Instant.MIN;
        this.nops = 0L;
        this.lastExc = Optional.empty();
        this.lastData = Collections.emptyList();
    }

    private DummyInstrument(int index, boolean enabled, String location, String shortName, Instant lastDataTime, long nops, Optional<HardwareException> exc, List<TrendableRecord> data) {
        this.index = index;
        this.enabled = enabled;
        this.location = location;
        this.shortName = shortName;
        this.lastDataTime = lastDataTime;
        this.nops = nops;
        this.lastExc = exc;
        this.lastData = data;
    }

    @Override
    public Optional<HardwareException> getLastException() {
        return this.lastExc;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public InstrumentStatus getStatus() {
        return new InstrumentStatus(this.index, this.enabled, this.location, this.shortName, this.lastDataTime);
    }

    @Override
    public Stream<TrendableRecord> getTrendables() {
        return this.lastData.stream();
    }

    @Override
    public Instrument disable() {
        long n = this.nops + 1L;
        Optional<HardwareException> exc = n % 5L == 0L ? Optional.of(new HardwareException("Simulated exception during disable.", null)) : Optional.empty();
        return new DummyInstrument(this.index, false, this.location, this.shortName, this.lastDataTime, n, exc, this.lastData);
    }

    @Override
    public Instrument enable() {
        long n = this.nops + 1L;
        Optional<HardwareException> exc = n % 5L == 0L ? Optional.of(new HardwareException("Simulated exception during enable.", null)) : Optional.empty();
        return new DummyInstrument(this.index, true, this.location, this.shortName, this.lastDataTime, n, exc, this.lastData);
    }

    @Override
    public Instrument read() {
        long n = this.nops + 1L;
        if (n % 5L == 0L) {
            return new DummyInstrument(this.index, this.enabled, this.location, this.shortName, this.lastDataTime, n, Optional.of(new HardwareException(false, "Simulated exception during read.")), Collections.emptyList());
        }
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return new DummyInstrument(this.index, this.enabled, this.location, this.shortName, this.lastDataTime, n, Optional.empty(), Collections.emptyList());
        }
        ArrayList<TrendableRecord> tr = new ArrayList<TrendableRecord>();
        Instant now = Instant.now();
        double density = Math.cos(now.getEpochSecond());
        TreeMap<String, Serializable> items = new TreeMap<String, Serializable>();
        items.put(InstrumentChannel.COUNTER_1_0.getKey(), new CounterPoint(density * 10.0, density, density > 0.8, false));
        tr.add(new TrendableDummyRecord(this.location, now, items));
        items.clear();
        items.put(InstrumentChannel.TEMPERATURE.getKey(), new AnalogPoint(30.0, false, false));
        tr.add(new TrendableDummyRecord(this.location, now, items));
        items.clear();
        items.put(InstrumentChannel.HUMIDITY.getKey(), new AnalogPoint(60.0, false, false));
        tr.add(new TrendableDummyRecord(this.location, now, items));
        return new DummyInstrument(this.index, this.enabled, this.location, this.shortName, now, n, Optional.empty(), tr);
    }
}

