/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice;

public class VacSimPlutoDevice
extends VacPlutoDevice {
    private static final Logger LOG = Logger.getLogger(VacSimPlutoDevice.class.getName());
    private final boolean[] switches = new boolean[6];
    private final Boolean[] latches = new Boolean[8];
    private final boolean[] conditions = new boolean[10];

    @Override
    protected void initDevice() {
    }

    protected void initialize() {
        LOG.log(Level.INFO, "Connected to simulated Pluto gateway");
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) {
        return new int[]{0, 0};
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return 0.0;
    }

    public Boolean isPLCActive() {
        return true;
    }

    @Override
    public void setSwitch(int sw, boolean on) {
        this.switches[sw] = on;
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.switches[sw];
    }

    @Override
    public Boolean isLatchActive(int cond) {
        Boolean latch = this.latches[cond];
        return latch != null && latch != false;
    }

    @Override
    public Boolean isLatchLatched(int cond) {
        Boolean latch = this.latches[cond];
        return latch != null && latch == false;
    }

    @Override
    public void clearLatch(int cond) {
        Boolean latch = this.latches[cond];
        this.latches[cond] = latch != null && latch == false ? null : latch;
    }

    @Override
    public Boolean isConditionActive(int cond) {
        return this.conditions[cond];
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchActive(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = true;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchLatched(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = false;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setCondition(@Argument(description="Running condition number") int cond, @Argument(description="Condition on state") boolean set) {
        this.conditions[cond] = set;
    }
}

