/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gantry;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ShellCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.IgnoreLoadCell;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.LoadCellStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.SetOrientation;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.StopAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.WeighRaft;
import org.lsst.ccs.subsystem.motorplatform.gantry.Ensemble;

public class GantryMain
extends Subsystem
implements MotorCommandListener,
ShellCommandListener,
GantryCommandListener,
HasLifecycle {
    private ExecutorService publisher;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Ensemble controller;
    private final Map<String, AxisStatus> lastAxisStatus;
    private final AtomicReference<ControllerStatus> lastControllerStatus;
    private final AtomicReference<LoadCellStatus> lastLoadCellStatus;
    private final AtomicReference<PlatformConfig> platformConfiguration;

    GantryMain() {
        super("gantry", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        this.lastAxisStatus = new ConcurrentHashMap<String, AxisStatus>(3);
        this.lastControllerStatus = new AtomicReference();
        this.lastLoadCellStatus = new AtomicReference();
        this.platformConfiguration = new AtomicReference();
    }

    private void publishOrPerish(Ensemble ctrl, Subsystem subsys, ExecutorService exec) {
        try {
            KeyValueData result = ctrl.getNextResult();
            if (result.getValue().getClass() == AxisStatus.class) {
                AxisStatus status = (AxisStatus)result.getValue();
                this.lastAxisStatus.put(status.getAxisName().toUpperCase(), status);
            } else if (result.getValue().getClass() == ControllerStatus.class) {
                this.lastControllerStatus.set((ControllerStatus)result.getValue());
            } else if (result.getValue().getClass() == LoadCellStatus.class) {
                this.lastLoadCellStatus.set((LoadCellStatus)result.getValue());
            }
            subsys.publishSubsystemDataOnStatusBus(result);
            exec.submit(() -> this.publishOrPerish(ctrl, subsys, exec));
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public void postInit() {
        ((AgentPropertiesService)this.getAgentService(AgentPropertiesService.class)).setAgentProperty("motorplatform.type", MotorplatformType.GANTRY.name());
    }

    public void postStart() {
        this.platformConfiguration.set(this.controller.getConfiguration());
        this.publisher = Executors.newSingleThreadExecutor();
        Ensemble ctrl = this.controller;
        GantryMain subsys = this;
        ExecutorService exec = this.publisher;
        exec.submit(() -> this.publishOrPerish(ctrl, subsys, exec));
    }

    public void shutdown() {
        this.publisher.shutdownNow();
    }

    @Command(description="(GUI/Jython) Enables or disables an axis.")
    public void changeAxisEnable(@Argument(name="cmd", description="An instance of ChangeAxisEnable.") ChangeAxisEnable cmd) {
        this.controller.changeAxisEnable(cmd);
    }

    @Command(description="(GUI/Jython) Change a motor controller output line state.")
    public void changeOutputLine(@Argument(name="cmd", description=")An instance of ChangeOutputLine.") ChangeOutputLine cmd) {
        this.controller.changeOutputLine(cmd);
    }

    @Command(description="(GUI/Jython) Attempt to clear all extant faults, general and axis.")
    public void clearAllFaults(@Argument(name="cmd", description="An instance of ClearAllFaults.") ClearAllFaults cmd) {
        this.controller.clearAllFaults(cmd);
    }

    @Command(description="(GUI/Jython) Attempt to clear the faults on a specific axis.")
    public void clearAxisFaults(@Argument(name="cmd", description="An instance of ClearAxisFaults.") ClearAxisFaults cmd) {
        this.controller.clearAxisFaults(cmd);
    }

    @Command(description="(GUI/Jython) Turn off data capture for subsequent motions.")
    public void clearCapture(@Argument(name="cmd", description="An instance of ClearCapture.") ClearCapture cmd) {
        this.controller.clearCapture(cmd);
    }

    @Command(description="(GUI/Jython) Enable all axes.")
    public void enableAllAxes(@Argument(name="cmd", description="An instance of EnableAllExes.") EnableAllAxes cmd) {
        this.controller.enableAllAxes(cmd);
    }

    @Command(description="(GUI/Jython) Disable all axes.")
    public void disableAllAxes(@Argument(name="cmd", description="An instance of DisableAllAxes") DisableAllAxes cmd) {
        this.controller.disableAllAxes(cmd);
    }

    @Command(description="(GUI/Jython) Move the axis to its low-end limit switch and set the axis position to zero.")
    public void homeAxis(@Argument(name="cmd", description="An instance of HomeAxis.") HomeAxis cmd) {
        this.controller.homeAxis(cmd);
    }

    @Command(description="(GUI/Jython) Change the axis position by the given amount in the given time.")
    public void moveAxisRelative(@Argument(name="cmd", description="An instance of MoveAxisRelative.") MoveAxisRelative cmd) {
        this.controller.moveAxisRelative(cmd);
    }

    @Command(description="(GUI/Jython) Move the axis to an absolute position at a given speed.")
    public void moveAxisAbsolute(@Argument(name="cmd", description="An instance of MoveAxisAbsolute.") MoveAxisAbsolute cmd) {
        this.controller.moveAxisAbsolute(cmd);
    }

    @Command(description="(GUI/Jython) Send an axis report on the status bus.")
    public void sendAxisStatus(@Argument(name="cmd", description="An instance of SendAxisStatus.") SendAxisStatus cmd) {
        this.controller.sendAxisStatus(cmd);
    }

    @Command(type=Command.CommandType.QUERY, description="(GUI/Jython) Send the platform configuration on the status bus.", level=0)
    public void sendConfiguration(@Argument(name="cmd", description="An instance of SendConfiguration.") SendConfiguration cmd) {
        this.controller.sendConfiguration(cmd);
    }

    @Command(description="(GUI/Jython) Send a controller report on the status bus.")
    public void sendControllerStatus(@Argument(name="cmd", description="An instance of SendControllerStatus.") SendControllerStatus cmd) {
        this.controller.sendControllerStatus(cmd);
    }

    @Command(description="(GUI/Jython) Set up data capture for subsequent moves.")
    public void setupCapture(@Argument(name="cmd", description="An instance of SetupCapture.") SetupCapture cmd) {
        this.controller.setupCapture(cmd);
    }

    @Command(description="(GUI/Jython) Kill all motion on the platform.")
    public void stopAllMotion(@Argument(name="cmd", description="An instance of StopAllMotion.") StopAllMotion cmd) {
        this.controller.stopAllMotion(cmd);
    }

    @Command(description="(Shell) Clear all axis and global controller faults.")
    public void clearFaults() {
        this.controller.clearAllFaults(new ClearAllFaults());
    }

    @Command(description="(Shell) Stop motion on all axes and discard queued commands.")
    public void stopAll() {
        this.controller.stopAllMotion(new StopAllMotion());
    }

    @Command(description="(Shell) Enable an axis.")
    public void enable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), true));
    }

    @Command(description="(Shell) Disable an axis.")
    public void disable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), false));
    }

    @Command(description="(Shell) Send an axis to its home position.")
    public void home(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.homeAxis(new HomeAxis(this.checkAxis(axisName)));
    }

    @Command(description="(Shell) Move an axis to a new absolute position.")
    public void moveTo(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="newPosition", description="The target position in mm.") double newPosition, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        this.controller.moveAxisAbsolute(new MoveAxisAbsolute(this.checkAxis(axisName), newPosition, speed));
    }

    @Command(description="(Shell) Move an axis by a given amount from the position at the start of command execution.")
    public void moveBy(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="positionChange", description="The desired coordinate change in mm.") double positionChange, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        double time = Math.abs(positionChange) / speed;
        this.controller.moveAxisRelative(new MoveAxisRelative(this.checkAxis(axisName), positionChange, Duration.ofMillis((long)(1000.0 * time))));
    }

    @Command(description="(Shell) Get a short status report for an axis.")
    public String status(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("Controller motion enable: %s%n");
        buff.append("Controller comm link: %s%n");
        buff.append("Axis %s%n");
        buff.append("Enabled %s, Moving %s, At Home %s, At Low %s, At High %s%n");
        buff.append("Position %6.1f%n");
        ControllerStatus ctlstat = this.lastControllerStatus.get();
        AxisStatus axstat = this.lastAxisStatus.get(this.checkAxis(axisName));
        if (ctlstat == null || axstat == null) {
            return "Not available at present.";
        }
        for (String fault : axstat.getFaults()) {
            buff.append(fault);
            buff.append("%n");
        }
        return String.format(buff.toString(), ctlstat.isMotionEnabled(), ctlstat.getCommLinkStatus(), axstat.getAxisName(), axstat.isEnabled(), axstat.isMoving(), axstat.isAtHome(), axstat.isAtLowLimit(), axstat.isAtHighLimit(), axstat.getPosition());
    }

    private String checkAxis(String axisName) {
        List legalNames = this.platformConfiguration.get().getAxisNames();
        Optional<String> match = legalNames.stream().filter(x -> x.equalsIgnoreCase(axisName)).findAny();
        if (match.isPresent()) {
            return match.get();
        }
        throw new IllegalArgumentException(String.format("Invalid axis name %s. The legal set is {%s}.", axisName, legalNames.stream().collect(Collectors.joining(", "))));
    }

    @Command(description="(GUI/Jython) On the next move, ignore the load cell reading..")
    public void ignoreLoadCell(@Argument(name="cmd", description="An instance of IgnoreLoadCell.") IgnoreLoadCell cmd) {
        this.controller.ignoreLoadCell(cmd);
    }

    @Command(description="(Shell) On the next move, ignore the load cell reading..")
    public void ignorelc() {
        this.ignoreLoadCell(new IgnoreLoadCell(true));
    }

    @Command(description="(Shell) Returns the latest known load cell value, or NaN if none.")
    public double lcvalue() {
        double result = Double.NaN;
        if (this.lastLoadCellStatus.get() != null) {
            result = this.lastLoadCellStatus.get().getLcReading();
        }
        return result;
    }

    @Command(description="(GUI/Jython) Store the current load cell reading as the raft weight.")
    public void weighRaft(@Argument(description="An instance of WeighRaftNow.") WeighRaft cmd) {
        this.controller.weighRaft(cmd);
    }

    @Command(description="(Shell) Store the current load cell reading as the raft weight.")
    public void weighraft() {
        this.weighRaft(new WeighRaft());
    }

    @Command(description="(GUI/Jython) Stop motion on the given axis.")
    public void stopAxis(StopAxis cmd) {
        this.controller.stopAxis(cmd);
    }

    @Command(description="(GUI/Jython) Set the orientation of the gantry w.r.t. BOT.")
    public void setOrientation(SetOrientation cmd) {
        this.controller.setOrientation(cmd);
    }
}

