import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.vacuum.VacuumMain
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpControl
import org.lsst.ccs.subsystem.vacuum.Mks9xxDevice
import org.lsst.ccs.subsystem.vacuum.CryoTurboDevice
import org.lsst.ccs.subsystem.vacuum.constants.Latches
import org.lsst.ccs.subsystem.vacuum.constants.Switches
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Alarm

CCSBuilder builder = ["pump-plate"]

builder.main (VacuumMain, cryoPressChan:"CryoVac", turboPressChan:"TurboVac",
              turboSpeedChan:"TurboSpeed", forelinePressChan:"ForelineVac",
              switches:[Switches.SW_CRYO_TURBO_PUMP, Switches.SW_CRYO_ION_PUMP1,
                        Switches.SW_CRYO_ION_PUMP2, Switches.SW_CRYO_ION_PUMP3,
                        Switches.SW_CRYO_ION_PUMP4, Switches.SW_CRYO_ION_PUMP5,
                        Switches.SW_CRYO_ION_PUMP6, Switches.SW_CRYO_GATE_VALVE]) {

    AlarmGeneric (Alarm, description:"Pump Plate Alarm - Generic", eventParm:23)

    VacPluto (VacPlutoDevice, node:"192.168.1.131",
              condsUsed:[Latches.LATCH_CR_GATE_AO, Latches.LATCH_CR_GATE_NFC,
                         Latches.LATCH_CR_PUMP])

    IonPumps (IonPumpDevice, ipAddr:"192.168.1.72") {

        CIP1C (IonPumpControl, hwChan:0, voltage:5000, current:0.002, power:9.9)

        CIP2C (IonPumpControl, hwChan:1, voltage:5000, current:0.002, power:9.9)

        CIP3C (IonPumpControl, hwChan:2, voltage:5000, current:0.002, power:9.9)

        CIP4C (IonPumpControl, hwChan:3, voltage:5000, current:0.002, power:9.9)

        CIP5C (IonPumpControl, hwChan:4, voltage:5000, current:0.002, power:9.9)

        CIP6C (IonPumpControl, hwChan:5, voltage:5000, current:0.002, power:9.9)

        CIP1_I (Channel, description:"Cryo ion pump 1 current", units:"mA",
                hwChan:0, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP2_I (Channel, description:"Cryo ion pump 2 current", units:"mA",
                hwChan:1, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP3_I (Channel, description:"Cryo ion pump 3 current", units:"mA",
                hwChan:2, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP4_I (Channel, description:"Cryo ion pump 4 current", units:"mA",
                hwChan:3, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP5_I (Channel, description:"Cryo ion pump 5 current", units:"mA",
                hwChan:4, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP6_I (Channel, description:"Cryo ion pump 6 current", units:"mA",
                hwChan:5, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        CIP1_V (Channel, description:"Cryo ion pump 1 voltage", units:"Volts", format:".1f",
                hwChan:0, type:"VOLTAGE")

        CIP2_V (Channel, description:"Cryo ion pump 2 voltage", units:"Volts", format:".1f",
                hwChan:1, type:"VOLTAGE")

        CIP3_V (Channel, description:"Cryo ion pump 3 voltage", units:"Volts", format:".1f",
                hwChan:2, type:"VOLTAGE")

        CIP4_V (Channel, description:"Cryo ion pump 4 voltage", units:"Volts", format:".1f",
                hwChan:3, type:"VOLTAGE")

        CIP5_V (Channel, description:"Cryo ion pump 5 voltage", units:"Volts", format:".1f",
                hwChan:4, type:"VOLTAGE")

        CIP6_V (Channel, description:"Cryo ion pump 6 voltage", units:"Volts", format:".1f",
                hwChan:5, type:"VOLTAGE")

    }

    TurboPump (CryoTurboDevice, devcId:"/dev/ttyUSB0", model304:true, lowSpeedMode:false, waterCooling:false,
               ventValveByCmnd:false, interlockType:true, softStartMode:true, activeStopMode:true) {

        TurboSpeed (Channel, description:"Turbo pump speed", units:"rpm", format:".0f",
                    type:"Numeric", subtype:"DRIVEFREQ", scale:60, limitHi:100000)

        TurboCurrent (Channel, description:"TurboPump current", units:"mA dc",
                      type:"Numeric", subtype:"CURRENT",
                      checkLo:"none", checkHi:"none", format:"%.0f")

        TurboVoltage (Channel, description:"TurboPump voltage", units:"V dc",
                      type:"Numeric", subtype:"VOLTAGE",
                      checkLo:"none", checkHi:"none", format:"%.0f")

        TurboPower   (Channel, description:"TurboPump power", units:"W",
                      type:"Numeric", subtype:"POWER",
                      checkLo:"none", checkHi:"alarm", alarmHi:"AlarmGeneric", format:"%.0f",
                      limitHi:150.0, dbandHi:100.0)

        TurboPumpTemp (Channel, description:"TurboPump pump temperature",
                       units:"deg C",
                       type:"Numeric", subtype:"PUMP_TEMP", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0,
                       limitHi:40.0, checkHi:"alarm", alarmHi:"AlarmGeneric", dbandHi:10.0)
    }

    CryoVacGauge (Mks9xxDevice, devcId:"/dev/ttyS0", busAddr:1) {

        CryoVac (Channel, description:"Cryostat vacuum", units:"Torr", format:".3g",
                 limitHi:1000)
    }

    TurboVacGauge (Mks9xxDevice, devcId:"/dev/ttyS0", busAddr:2) {

        TurboVac (Channel, description:"Turbo pump vacuum", units:"Torr", format:".3g",
                  limitHi:1000)
    }

    ForelineVacGauge (Mks9xxDevice, devcId:"/dev/ttyUSB3") {

        ForelineVac (Channel, description:"Foreline pump vacuum", units:"Torr", format:".3g",
                     limitHi:1000)
    }


/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1, pageId:0, 
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

}
