/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.ims.Catalog;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Playlist;
import org.lsst.ccs.daq.ims.Utils;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;

public class PlaylistCommands {
    private final FocalPlaneSubsystem subsys;
    private final SequencerConfig config;
    private static final Logger LOG = Logger.getLogger(PlaylistCommands.class.getName());

    PlaylistCommands(FocalPlaneSubsystem subsys, SequencerConfig config) {
        this.subsys = subsys;
        this.config = config;
    }

    @Command(type=Command.CommandType.ACTION, description="Start a playlist", level=0, autoAck=false)
    public void play(String playListFileName, @Argument(defaultValue="false") boolean repeat) throws IOException {
        Path playListPath = this.getPlaylistBaseDir(playListFileName);
        this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(this.config.hasEmulatedDAQ(), "play command only evailable with emulated DAQ", new Object[0]).precondition(Files.exists(playListPath, new LinkOption[0]), "play list backing file does not exist", new Object[0]).action(() -> {
            try (Playlist playList = this.config.getEmulator().openPlaylist(playListPath.toFile());){
                playList.start(repeat);
            }
            return null;
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Define a playlist", level=0, autoAck=false)
    public void definePlaylist(String playListFileName, String daqFolder, String ... imageNames) {
        this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(this.config.hasEmulatedDAQ(), "play command only evailable with eumlated DAQ", new Object[0]).action(() -> {
            Catalog catalog;
            Folder folder;
            Path playListPath = this.getPlaylistBaseDir(playListFileName);
            if (Files.deleteIfExists(playListPath)) {
                // empty if block
            }
            if ((folder = (catalog = this.config.getStore().getCatalog()).find(daqFolder)) == null) {
                throw new RuntimeException("Specified daq folder does not exist: " + daqFolder);
            }
            ArrayList<Image> images = new ArrayList<Image>();
            for (String imageName : imageNames) {
                Image image = folder.find(imageName);
                if (image == null) {
                    throw new RuntimeException("Specified image does not exist: " + imageName);
                }
                images.add(image);
            }
            try (Playlist playList = this.config.getEmulator().openPlaylist(playListPath.toFile());){
                for (Image image : images) {
                    playList.add(image);
                }
            }
            return null;
        });
    }

    @Command(type=Command.CommandType.QUERY, description="Show contents of a playlist", level=0, autoAck=false)
    public String showPlaylist(String playListFileName) throws IOException {
        Path playListPath = this.getPlaylistBaseDir(playListFileName);
        return (String)this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(this.config.hasEmulatedDAQ(), "playlists only evailable with eumlated DAQ", new Object[0]).precondition(Files.exists(playListPath, new LinkOption[0]), "play list backing file does not exist", new Object[0]).action(() -> {
            try (Playlist playList = this.config.getEmulator().openPlaylist(playListPath.toFile());){
                List images = playList.getImages();
                String string = images.stream().map(image -> String.format("%s %s %s %s", image.getMetaData().getName(), Utils.imageSize((Image)image), image.getMetaData().getTimestamp(), image.getMetaData().getAnnotation())).collect(Collectors.joining("\n"));
                return string;
            }
        });
    }

    private Path getPlaylistBaseDir(String playlistFileName) throws IOException {
        if (!playlistFileName.endsWith(".playlist")) {
            playlistFileName = playlistFileName + ".playlist";
        }
        return this.config.getPlaylistBaseDir().resolve(playlistFileName);
    }
}

