/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.utilities.logging.Logger;

public final class FcsUtils {
    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    public static final int MAX_VALUE_2BYTES = 65535;
    public static final int MAX_NODE_ID = 127;
    public static final int TICKMILLIS = 3000;
    private static final String[] CAN_OPEN_COMMANDS = new String[]{"sync", "scan", "rsdo", "wsdo", "info", "quit", "srtr", "reset"};

    public static void checkSocketName(String name) {
        String errorMsg = ": invalid socket name - Socket name must be \"socketX\" where 0 <= X <= 5";
        if (name.isEmpty() || name.contentEquals("AC")) {
            return;
        }
        if (!name.startsWith("socket")) {
            throw new IllegalArgumentException(name + errorMsg);
        }
        String end = name.substring(6);
        try {
            int ix = Integer.parseInt(end);
            if (ix < 1 || ix > 5) {
                throw new IllegalArgumentException(name + errorMsg);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(name + errorMsg, ex);
        }
    }

    public static int force2zero(int val, int bit) {
        if (bit < 0 || bit > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : >0 and <15", bit));
        }
        return val & ~(1 << bit);
    }

    public static int force2one(int val, int bit) {
        if (bit < 0 || bit > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : >0 and <15", bit));
        }
        return val | 1 << bit;
    }

    public static int forceBit(int val, int bit, int zeroOne) {
        if (zeroOne == 0) {
            return FcsUtils.force2zero(val, bit);
        }
        return FcsUtils.force2one(val, bit);
    }

    public static String buildWsdoCommand(int nodeID, int index, int subindex, int size, int data) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("wsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex)).append(sep);
        sb.append(Integer.toHexString(size)).append(sep);
        sb.append(Integer.toHexString(data));
        return sb.toString();
    }

    public static String buildRsdoCommand(int nodeID, int index, int subindex) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("rsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex));
        return sb.toString();
    }

    public static boolean isValidCommandWord(String command) {
        for (String s : CAN_OPEN_COMMANDS) {
            if (!s.equals(command)) continue;
            return true;
        }
        return false;
    }

    public static void checkCommand(String command) {
        if (command == null) {
            throw new IllegalArgumentException(" null command");
        }
        String[] words = command.split(",");
        if (words.length == 0 || !FcsUtils.isValidCommandWord(words[0])) {
            throw new IllegalArgumentException(command + " invalid command");
        }
    }

    public static byte convertInteger8(long integer8) {
        if ((double)integer8 >= Math.pow(2.0, 8.0)) {
            throw new IllegalArgumentException(integer8 + " too big. Should be coded on 8 bits, so < Math.pow(2,8)");
        }
        return (byte)integer8;
    }

    public static short convertInteger16(long integer16) {
        if ((double)integer16 >= Math.pow(2.0, 16.0)) {
            throw new IllegalArgumentException(integer16 + " too big. Should be coded on 16 bits, so < Math.pow(2,16)");
        }
        return (short)integer16;
    }

    public static int convertInteger32(long integer32) {
        if ((double)integer32 >= Math.pow(2.0, 32.0)) {
            throw new IllegalArgumentException(integer32 + " too big. Should be coded on 32 bits, so < Math.pow(2,32)");
        }
        return (int)integer32;
    }

    public static String displayListParameters(String modeInString) {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.EposMode.valueOf(modeInString).getParameters()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String displayListParameters() {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.Parameter.values()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int getSignedStepHeight(int initialValue, int finalValue, int increment) {
        if (finalValue - initialValue > 0) {
            return increment;
        }
        return -increment;
    }

    public static void main(String[] args) {
        System.out.println(FcsUtils.displayListParameters("HOMING"));
        System.out.println(FcsUtils.displayListParameters("CURRENT"));
        System.out.println(FcsUtils.displayListParameters("PROFILE_POSITION"));
        System.out.println(FcsUtils.displayListParameters());
    }

    public static boolean finalValueReached(int stepHeight, int newCurrentValue, int finalValue) {
        boolean goingUp = stepHeight > 0 && newCurrentValue > finalValue;
        boolean goingDown = stepHeight < 0 && newCurrentValue < finalValue;
        return goingUp || goingDown;
    }

    public static int computeNewCurrentValue(int stepHeight, int currentValue, int finalValue) {
        if (stepHeight > 0) {
            return Math.min(currentValue + stepHeight, finalValue);
        }
        return Math.max(currentValue + stepHeight, finalValue);
    }

    public static void sleep(int duration, String itemName) {
        try {
            FCSLOG.finest((Object)(itemName + " BEGIN SLEEP for " + duration + " milliseconds"));
            Thread.sleep(duration);
            FCSLOG.finest((Object)(itemName + " END SLEEP for " + duration + " milliseconds"));
        }
        catch (InterruptedException ex) {
            String msg = itemName + " interrupted while sleeping";
            FCSLOG.error((Object)(itemName + msg), (Throwable)ex);
        }
    }

    public static void checkPositive(int arg) {
        if (arg < 0) {
            throw new IllegalArgumentException(arg + ":illegal value. Must be > 0");
        }
    }

    public static int returnIndex(int byteNumero) {
        int index = 24576 + byteNumero / 4;
        return index;
    }

    public static int returnSubindex(int byteNumero) {
        int subindex = 1 + byteNumero % 4;
        return subindex;
    }
}

