/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;

public class CanCBXAI814
extends CanOpenDevice
implements ADCInterface {
    public static final double adcVoltsPerBit = 0.3125;
    public static final double waterFreezeTemp = 273.15;
    @ConfigurationParameter(description="UNDEFINED", units="unitless")
    protected volatile int transmissionType;
    public int[] inputs = new int[8];
    protected int cobid1 = this.nodeID + 640;
    protected int cobid2 = this.nodeID + 896;

    public CanCBXAI814(int nodeID, String serialNB, int transmissionType) {
        super(nodeID, serialNB);
        this.transmissionType = transmissionType;
    }

    @Override
    public long getInput(int i) {
        return this.inputs[i];
    }

    public int[] getInputs() {
        return this.inputs;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
        this.tcpProxy.addReceivedPDO(this.cobid2);
        FCSCst.FCSLOG.info((Object)(this.name + " pdos have been initialized with cobid1 = " + Integer.toHexString(this.cobid1) + " and cobid2 = " + Integer.toHexString(this.cobid2)));
    }

    @Override
    public void initializeAndCheckHardware() {
        for (int i = 0; i < 8; ++i) {
            this.inputs[i] = 0;
        }
        if (this.isBooted()) {
            this.writeTransmissionTypeToDevice(this.transmissionType);
            this.initialized = true;
            this.publishData();
        }
    }

    @Override
    public int readAnalogInput(int inputNB) {
        if (!this.tcpProxy.isReady()) {
            throw new HardwareNotDetectedException(this.name + ": hardware not connected.");
        }
        if (this.isBooted()) {
            if (inputNB < 1 || inputNB > 8) {
                throw new IllegalArgumentException("CAN-CBX-AI814 : input has to be 1..8");
            }
            return (int)this.readSDO(25601, inputNB);
        }
        String message = String.format("Module %s / nodeID=%s is UNREACHABLE", this.getName(), this.nodeID);
        FCSCst.FCSLOG.error((Object)message);
        throw new HardwareNotDetectedException(this.name + " MISSING", this.name, this.nodeID, this.serialNB);
    }

    @Override
    public double readVoltage(int inputNB) {
        return (double)this.readAnalogInput(inputNB) * 0.3125;
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        boolean updated = false;
        if (this.isBooted()) {
            long pdoVal;
            if (pdo.getPDOs().containsKey(this.cobid1)) {
                FCSCst.FCSLOG.finest((Object)(this.name + " updating from pdo with cobid = 0x" + Integer.toHexString(this.cobid1)));
                pdoVal = (Long)pdo.getPDOs().get(this.cobid1);
                this.inputs[3] = (int)(pdoVal >> 48);
                this.inputs[2] = (int)(pdoVal >> 32 & 0xFFFFL);
                this.inputs[1] = (int)(pdoVal >> 16 & 0xFFFFL);
                this.inputs[0] = (int)(pdoVal & 0xFFFFL);
                updated = true;
            }
            if (pdo.getPDOs().containsKey(this.cobid2)) {
                FCSCst.FCSLOG.info((Object)(this.name + " updating from pdo with cobid = 0x" + Integer.toHexString(this.cobid2)));
                pdoVal = (Long)pdo.getPDOs().get(this.cobid2);
                this.inputs[7] = (int)(pdoVal >> 48);
                this.inputs[6] = (int)(pdoVal >> 32 & 0xFFFFL);
                this.inputs[5] = (int)(pdoVal >> 16 & 0xFFFFL);
                this.inputs[4] = (int)(pdoVal & 0xFFFFL);
                updated = true;
            }
            if (updated) {
                this.publishData();
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print input values. For test and debug.")
    public String printInputs() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (int i = 0; i < 8; ++i) {
            sb.append("\n inputs[");
            sb.append(i);
            sb.append("]=");
            sb.append(this.inputs[i]);
        }
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the string representation of CanCBXAI814.", alias="print_cobid")
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("cobid1=");
        sb.append(this.cobid1);
        sb.append("(hexa=0x");
        sb.append(Integer.toHexString(this.cobid1));
        sb.append(")/cobid2=");
        sb.append(this.cobid2);
        sb.append("(hexa=0x");
        sb.append(Integer.toHexString(this.cobid2));
        sb.append(")");
        return sb.toString();
    }

    public void postStart() {
        FCSCst.FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        this.initializeAndCheckHardware();
        FCSCst.FCSLOG.fine((Object)(this.name + " END postStart."));
    }
}

