/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChannelUnits {
    COUNTS("counts", "#"),
    PERCENTAGE("percent", "%"),
    CELSIUS("Celsius", "C"),
    FAHRENHEIT("Fahrenheit", "F");

    private final String fileText;
    private final String deviceText;
    private static final Map<String, ChannelUnits> labelMap;

    private ChannelUnits(String fileText, String deviceText) {
        this.fileText = fileText;
        this.deviceText = deviceText;
    }

    public String toString() {
        return this.fileText;
    }

    public String getDeviceText() {
        return this.deviceText;
    }

    public static ChannelUnits fromUnitsLabel(String label) {
        return labelMap.get(label);
    }

    static {
        labelMap = Collections.unmodifiableMap(Stream.of(ChannelUnits.values()).collect(Collectors.toMap(ChannelUnits::getDeviceText, Function.identity())));
    }
}

